/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6.access;

import com.oracle.coherence.hibernate.cache.v6.access.AbstractCoherenceEntityDataAccess;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoherenceReadOnlyNaturalIdAccess
extends AbstractCoherenceEntityDataAccess
implements NaturalIdDataAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoherenceReadOnlyNaturalIdAccess.class);

    public CoherenceReadOnlyNaturalIdAccess(DomainDataRegion domainDataRegion, DomainDataStorageAccess domainDataStorageAccess) {
        super(domainDataRegion, domainDataStorageAccess, null);
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("insert({}, {})", key, value);
        }
        return false;
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("afterInsert({}, {})", key, value);
        }
        this.getCoherenceRegion().putValue(key, this.newCacheValue(value, null));
        return true;
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("update({}, {})", key, value);
        }
        throw new UnsupportedOperationException("Write operations are not supported in the read-only cache concurrency strategy.");
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("afterUpdate({}, {}, {})", new Object[]{key, value, lock});
        }
        throw new UnsupportedOperationException("Write operations are not supported in the read-only cache concurrency strategy.");
    }

    public Object generateCacheKey(Object naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return this.getCacheKeysFactory().createNaturalIdKey(naturalIdValues, persister, session);
    }

    public Object getNaturalIdValues(Object cacheKey) {
        return this.getCacheKeysFactory().getNaturalIdValues(cacheKey);
    }

    public AccessType getAccessType() {
        return AccessType.READ_ONLY;
    }
}

