/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6.access;

import com.oracle.coherence.hibernate.cache.v6.access.AbstractCoherenceEntityDataAccess;
import java.util.Comparator;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.support.AbstractDomainDataRegion;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoherenceNonstrictReadWriteEntityAccess
extends AbstractCoherenceEntityDataAccess
implements EntityDataAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoherenceNonstrictReadWriteEntityAccess.class);

    public CoherenceNonstrictReadWriteEntityAccess(DomainDataRegion domainDataRegion, DomainDataStorageAccess domainDataStorageAccess, Comparator<?> versionComparator) {
        super(domainDataRegion, domainDataStorageAccess, versionComparator);
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("insert({}, {}, {})", new Object[]{key, value, version});
        }
        return false;
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("afterInsert({}, {}, {})", new Object[]{key, value, version});
        }
        return false;
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("update({}, {}, {}, {})", new Object[]{key, value, currentVersion, previousVersion});
        }
        return false;
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("afterUpdate({}, {}, {}, {}, {})", new Object[]{key, value, currentVersion, previousVersion, lock});
        }
        this.remove(session, key);
        this.unlockItem(session, key, lock);
        return false;
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor sessionFactoryImplementor, String tenantIdentifier) {
        return ((AbstractDomainDataRegion)this.getRegion()).getEffectiveKeysFactory().createEntityKey(id, persister, sessionFactoryImplementor, tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return this.getCacheKeysFactory().getEntityId(cacheKey);
    }

    public AccessType getAccessType() {
        return AccessType.NONSTRICT_READ_WRITE;
    }

    @Override
    public boolean contains(Object key) {
        return false;
    }
}

