/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6.access;

import com.oracle.coherence.hibernate.cache.v6.access.CoherenceNonstrictReadWriteCollectionAccess;
import com.oracle.coherence.hibernate.cache.v6.access.CoherenceNonstrictReadWriteEntityAccess;
import com.oracle.coherence.hibernate.cache.v6.access.CoherenceNonstrictReadWriteNaturalIdAccess;
import com.oracle.coherence.hibernate.cache.v6.access.CoherenceReadOnlyCollectionAccess;
import com.oracle.coherence.hibernate.cache.v6.access.CoherenceReadOnlyEntityAccess;
import com.oracle.coherence.hibernate.cache.v6.access.CoherenceReadOnlyNaturalIdAccess;
import com.oracle.coherence.hibernate.cache.v6.access.CoherenceReadWriteCollectionAccess;
import com.oracle.coherence.hibernate.cache.v6.access.CoherenceReadWriteEntityAccess;
import com.oracle.coherence.hibernate.cache.v6.access.CoherenceReadWriteNaturalIdAccess;
import java.util.Comparator;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.CollectionDataCachingConfig;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.cfg.spi.EntityDataCachingConfig;
import org.hibernate.cache.cfg.spi.NaturalIdDataCachingConfig;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.support.DomainDataRegionImpl;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.cache.spi.support.RegionFactoryTemplate;

public class CoherenceDomainDataRegionImpl
extends DomainDataRegionImpl {
    public CoherenceDomainDataRegionImpl(DomainDataRegionConfig regionConfig, RegionFactoryTemplate regionFactory, DomainDataStorageAccess domainDataStorageAccess, CacheKeysFactory defaultKeysFactory, DomainDataRegionBuildingContext buildingContext) {
        super(regionConfig, regionFactory, domainDataStorageAccess, defaultKeysFactory, buildingContext);
    }

    protected EntityDataAccess generateTransactionalEntityDataAccess(EntityDataCachingConfig entityAccessConfig) {
        throw new CacheException("The transactional cache concurrency strategy is not supported.");
    }

    protected NaturalIdDataAccess generateTransactionalNaturalIdDataAccess(NaturalIdDataCachingConfig accessConfig) {
        throw new CacheException("The transactional cache concurrency strategy is not supported.");
    }

    protected CollectionDataAccess generateTransactionalCollectionDataAccess(CollectionDataCachingConfig accessConfig) {
        throw new CacheException("The transactional cache concurrency strategy is not supported.");
    }

    protected EntityDataAccess generateReadOnlyEntityAccess(EntityDataCachingConfig accessConfig) {
        Comparator versionComparator = accessConfig.getVersionComparatorAccess() != null ? (Comparator)accessConfig.getVersionComparatorAccess().get() : null;
        return new CoherenceReadOnlyEntityAccess((DomainDataRegion)this, this.getCacheStorageAccess(), versionComparator);
    }

    protected EntityDataAccess generateReadWriteEntityAccess(EntityDataCachingConfig accessConfig) {
        Comparator versionComparator = accessConfig.getVersionComparatorAccess() != null ? (Comparator)accessConfig.getVersionComparatorAccess().get() : null;
        return new CoherenceReadWriteEntityAccess((DomainDataRegion)this, this.getCacheStorageAccess(), versionComparator);
    }

    protected EntityDataAccess generateNonStrictReadWriteEntityAccess(EntityDataCachingConfig accessConfig) {
        Comparator versionComparator = accessConfig.getVersionComparatorAccess() != null ? (Comparator)accessConfig.getVersionComparatorAccess().get() : null;
        return new CoherenceNonstrictReadWriteEntityAccess((DomainDataRegion)this, this.getCacheStorageAccess(), versionComparator);
    }

    protected NaturalIdDataAccess generateReadOnlyNaturalIdAccess(NaturalIdDataCachingConfig accessConfig) {
        return new CoherenceReadOnlyNaturalIdAccess((DomainDataRegion)this, this.getCacheStorageAccess());
    }

    protected NaturalIdDataAccess generateReadWriteNaturalIdAccess(NaturalIdDataCachingConfig accessConfig) {
        return new CoherenceReadWriteNaturalIdAccess((DomainDataRegion)this, this.getCacheStorageAccess());
    }

    protected NaturalIdDataAccess generateNonStrictReadWriteNaturalIdAccess(NaturalIdDataCachingConfig accessConfig) {
        return new CoherenceNonstrictReadWriteNaturalIdAccess((DomainDataRegion)this, this.getCacheStorageAccess());
    }

    public CollectionDataAccess generateCollectionAccess(CollectionDataCachingConfig accessConfig) {
        Comparator versionComparator = accessConfig.getOwnerVersionComparator() != null ? accessConfig.getOwnerVersionComparator() : null;
        switch (accessConfig.getAccessType()) {
            case READ_ONLY: {
                return new CoherenceReadOnlyCollectionAccess((DomainDataRegion)this, this.getCacheStorageAccess(), versionComparator);
            }
            case READ_WRITE: {
                return new CoherenceReadWriteCollectionAccess((DomainDataRegion)this, this.getCacheStorageAccess(), versionComparator);
            }
            case NONSTRICT_READ_WRITE: {
                return new CoherenceNonstrictReadWriteCollectionAccess((DomainDataRegion)this, this.getCacheStorageAccess(), versionComparator);
            }
            case TRANSACTIONAL: {
                return this.generateTransactionalCollectionDataAccess(accessConfig);
            }
        }
        throw new IllegalArgumentException("Unrecognized cache AccessType - " + accessConfig.getAccessType());
    }
}

