/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6.access;

import com.oracle.coherence.hibernate.cache.v6.access.AbstractCoherenceEntityDataAccess;
import com.oracle.coherence.hibernate.cache.v6.access.processor.AfterInsertProcessor;
import com.oracle.coherence.hibernate.cache.v6.access.processor.AfterUpdateProcessor;
import com.oracle.coherence.hibernate.cache.v6.access.processor.GetProcessor;
import com.oracle.coherence.hibernate.cache.v6.access.processor.ReadWritePutFromLoadProcessor;
import com.oracle.coherence.hibernate.cache.v6.access.processor.SoftLockItemProcessor;
import com.oracle.coherence.hibernate.cache.v6.access.processor.SoftUnlockItemProcessor;
import com.oracle.coherence.hibernate.cache.v6.region.CoherenceRegionValue;
import com.tangosol.util.InvocableMap;
import java.util.Comparator;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractReadWriteCoherenceEntityDataAccess
extends AbstractCoherenceEntityDataAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReadWriteCoherenceEntityDataAccess.class);

    AbstractReadWriteCoherenceEntityDataAccess(DomainDataRegion domainDataRegion, DomainDataStorageAccess domainDataStorageAccess, Comparator<?> versionComparator) {
        super(domainDataRegion, domainDataStorageAccess, versionComparator);
    }

    @Override
    public Object get(SharedSessionContractImplementor session, Object key) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("get({})", key);
        }
        return this.getCoherenceRegion().invoke(key, (InvocableMap.EntryProcessor)new GetProcessor());
    }

    @Override
    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("lockItem({}, {})", key, version);
        }
        CoherenceRegionValue valueIfAbsent = this.newCacheValue(null, version);
        CoherenceRegionValue.SoftLock newSoftLock = this.newSoftLock();
        SoftLockItemProcessor processor = new SoftLockItemProcessor(valueIfAbsent, newSoftLock);
        this.getCoherenceRegion().invoke(key, (InvocableMap.EntryProcessor)processor);
        return newSoftLock;
    }

    @Override
    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, Object version, boolean minimalPutOverride) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("putFromLoad({}, {}, {}, {})", new Object[]{key, value, version, minimalPutOverride});
        }
        CoherenceRegionValue newCacheValue = this.newCacheValue(value, version);
        ReadWritePutFromLoadProcessor processor = new ReadWritePutFromLoadProcessor(minimalPutOverride, this.getCoherenceRegion().nextTimestamp(), newCacheValue, super.getVersionComparator());
        return (Boolean)this.getCoherenceRegion().invoke(key, (InvocableMap.EntryProcessor)processor);
    }

    @Override
    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("unlockItem({}, {})", key, (Object)lock);
        }
        SoftUnlockItemProcessor processor = new SoftUnlockItemProcessor(lock, this.getCoherenceRegion().nextTimestamp());
        this.getCoherenceRegion().invoke(key, (InvocableMap.EntryProcessor)processor);
    }

    protected boolean afterInsert(Object key, CoherenceRegionValue value) {
        AfterInsertProcessor afterInsertProcessor = new AfterInsertProcessor(value);
        return (Boolean)this.getCoherenceRegion().invoke(key, (InvocableMap.EntryProcessor)afterInsertProcessor);
    }

    protected boolean afterUpdate(Object key, CoherenceRegionValue value, SoftLock softLock) {
        long timeOfSoftLockRelease = this.getCoherenceRegion().nextTimestamp();
        AfterUpdateProcessor afterUpdateProcessor = new AfterUpdateProcessor(value, softLock, timeOfSoftLockRelease);
        return (Boolean)this.getCoherenceRegion().invoke(key, (InvocableMap.EntryProcessor)afterUpdateProcessor);
    }

    private CoherenceRegionValue.SoftLock newSoftLock() {
        long lockExpirationTime = this.getCoherenceRegion().newSoftLockExpirationTime();
        return new CoherenceRegionValue.SoftLock(this.getUuid(), this.nextSoftLockSequenceNumber(), lockExpirationTime);
    }
}

