/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6.access;

import com.oracle.coherence.hibernate.cache.v6.access.CoherenceStorageAccessImpl;
import com.oracle.coherence.hibernate.cache.v6.access.processor.PutFromLoadProcessor;
import com.oracle.coherence.hibernate.cache.v6.configuration.support.Assert;
import com.oracle.coherence.hibernate.cache.v6.region.CoherenceRegion;
import com.oracle.coherence.hibernate.cache.v6.region.CoherenceRegionValue;
import com.tangosol.util.InvocableMap;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.support.AbstractDomainDataRegion;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCoherenceEntityDataAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCoherenceEntityDataAccess.class);
    public static final String TRANSACTIONAL_STRATEGY_NOT_SUPPORTED_MESSAGE = "The transactional cache concurrency strategy is not supported.";
    protected static final String WRITE_OPERATIONS_NOT_SUPPORTED_MESSAGE = "Write operations are not supported in the read-only cache concurrency strategy.";
    private final DomainDataRegion domainDataRegion;
    private final DomainDataStorageAccess domainDataStorageAccess;
    private Comparator<?> versionComparator;
    private AtomicLong softLockSequenceNumber = new AtomicLong(0L);
    private UUID uuid = UUID.randomUUID();

    public AbstractCoherenceEntityDataAccess(DomainDataRegion domainDataRegion, DomainDataStorageAccess domainDataStorageAccess, Comparator<?> versionComparator) {
        Assert.notNull(domainDataRegion, "domainDataRegion must not be null.");
        Assert.notNull(domainDataStorageAccess, "storageAccess must not be null.");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Constructing AbstractCoherenceEntityDataAccess.");
        }
        this.domainDataRegion = domainDataRegion;
        this.domainDataStorageAccess = domainDataStorageAccess;
        this.versionComparator = versionComparator;
    }

    protected CoherenceRegion getCoherenceRegion() {
        return ((CoherenceStorageAccessImpl)this.domainDataStorageAccess).getDelegate();
    }

    public DomainDataRegion getRegion() {
        return this.domainDataRegion;
    }

    protected DomainDataStorageAccess getDomainDataStorageAccess() {
        return this.domainDataStorageAccess;
    }

    protected Comparator<?> getVersionComparator() {
        return this.versionComparator;
    }

    protected CacheKeysFactory getCacheKeysFactory() {
        return ((AbstractDomainDataRegion)this.getRegion()).getEffectiveKeysFactory();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public long nextSoftLockSequenceNumber() {
        return this.softLockSequenceNumber.incrementAndGet();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append("(");
        stringBuilder.append("coherenceRegion=").append(this.getCoherenceRegion());
        stringBuilder.append(", uuid=").append(this.uuid);
        stringBuilder.append(", softLockSequenceNumber=").append(this.softLockSequenceNumber);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public Object get(SharedSessionContractImplementor session, Object key) throws CacheException {
        CoherenceRegionValue cacheValue;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getValue({})", key);
        }
        return (cacheValue = (CoherenceRegionValue)this.getCoherenceRegion().getValue(key)) != null ? cacheValue.getValue() : null;
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("putFromLoad({}, {}, {})", new Object[]{key, value, version});
        }
        return this.putFromLoad(session, key, value, version, this.getCoherenceRegion().getRegionFactory().isMinimalPutsEnabledByDefault());
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, Object version, boolean minimalPutOverride) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("putFromLoad({}, {}, {}, {})", new Object[]{key, value, version, minimalPutOverride});
        }
        CoherenceRegionValue newCacheValue = this.newCacheValue(value, version);
        PutFromLoadProcessor processor = new PutFromLoadProcessor(minimalPutOverride, newCacheValue);
        return (Boolean)this.getCoherenceRegion().invoke(key, (InvocableMap.EntryProcessor)processor);
    }

    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("lockItem({}, {})", key, version);
        }
        return null;
    }

    public SoftLock lockRegion() throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("lockRegion()");
        }
        this.getCoherenceRegion().lockCache();
        return null;
    }

    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("lockItem({}, {})", key, (Object)lock);
        }
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("unlockRegion({})", (Object)lock);
        }
        this.getCoherenceRegion().unlockCache();
    }

    public void remove(SharedSessionContractImplementor session, Object key) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("remove({})", key);
        }
        this.evict(key);
    }

    public void removeAll(SharedSessionContractImplementor session) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("removeAll()");
        }
        this.evictAll();
    }

    public void evict(Object key) throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("evict({})", key);
        }
        this.getCoherenceRegion().evict(key);
    }

    public void evictAll() throws CacheException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("evictAll()");
        }
        this.getCoherenceRegion().evictAll();
    }

    public CoherenceRegionValue newCacheValue(Object value, Object version) {
        return new CoherenceRegionValue(value, version, this.getCoherenceRegion().nextTimestamp());
    }

    public boolean contains(Object key) {
        return this.domainDataStorageAccess.contains(key);
    }
}

