/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.hibernate.cache.v6;

import com.oracle.coherence.hibernate.cache.v6.access.CoherenceDomainDataRegionImpl;
import com.oracle.coherence.hibernate.cache.v6.access.CoherenceStorageAccessImpl;
import com.oracle.coherence.hibernate.cache.v6.configuration.session.SessionType;
import com.oracle.coherence.hibernate.cache.v6.configuration.support.Assert;
import com.oracle.coherence.hibernate.cache.v6.configuration.support.CoherenceHibernateProperties;
import com.oracle.coherence.hibernate.cache.v6.configuration.support.CoherenceHibernateSystemPropertyResolver;
import com.oracle.coherence.hibernate.cache.v6.configuration.support.ConfigUtils;
import com.oracle.coherence.hibernate.cache.v6.region.CoherenceRegion;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultCacheServer;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.net.options.WithClassLoader;
import com.tangosol.net.options.WithConfiguration;
import java.util.ArrayList;
import java.util.Map;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.cache.spi.support.RegionFactoryTemplate;
import org.hibernate.cache.spi.support.StorageAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoherenceRegionFactory
extends RegionFactoryTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoherenceRegionFactory.class);
    private static final long serialVersionUID = -8434943540794407358L;
    protected transient CoherenceHibernateSystemPropertyResolver systemPropertyResolver;
    protected transient Session coherenceSession;
    private final boolean requiresShutDown;
    private transient DefaultCacheServer defaultCacheServer;
    private Cluster cluster = null;
    private transient SessionFactoryOptions sessionFactoryOptions;
    private transient CacheKeysFactory cacheKeysFactory;

    public CoherenceRegionFactory() {
        this.coherenceSession = null;
        this.requiresShutDown = true;
    }

    public CoherenceRegionFactory(Session coherenceSession) {
        Assert.notNull(coherenceSession, "The passed-in coherenceSession must not be null.");
        this.coherenceSession = coherenceSession;
        this.requiresShutDown = false;
    }

    protected CacheKeysFactory getImplicitCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    protected Session getCoherenceSession() {
        return this.coherenceSession;
    }

    protected void setCoherenceSession(Session coherenceSession) {
        this.coherenceSession = coherenceSession;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "(coherenceSession=" + (this.coherenceSession != null ? this.coherenceSession.toString() : "N/A") + ", sessionFactoryOptions=" + this.sessionFactoryOptions + ")";
    }

    protected void prepareForUse(SessionFactoryOptions settings, Map configValues) {
        this.sessionFactoryOptions = settings;
        CoherenceHibernateProperties coherenceHibernateProperties = new CoherenceHibernateProperties(configValues);
        Map<String, Object> coherenceProperties = coherenceHibernateProperties.getCoherenceProperties();
        this.systemPropertyResolver = new CoherenceHibernateSystemPropertyResolver(coherenceProperties);
        if (this.systemPropertyResolver.getProperty("coherence.log") == null) {
            this.systemPropertyResolver.addCoherenceProperty("coherence.log", "slf4j");
        }
        if (this.sessionFactoryOptions != null) {
            StrategySelector selector = (StrategySelector)this.sessionFactoryOptions.getServiceRegistry().getService(StrategySelector.class);
            this.cacheKeysFactory = (CacheKeysFactory)selector.resolveDefaultableStrategy(CacheKeysFactory.class, configValues.get("hibernate.cache.keys_factory"), (Object)new DefaultCacheKeysFactory());
        } else {
            this.cacheKeysFactory = new DefaultCacheKeysFactory();
        }
        this.systemPropertyResolver.initialize();
        this.prepareCoherenceSessionIfNeeded(coherenceHibernateProperties);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("start({}, {})", (Object)settings, (Object)configValues);
        }
    }

    private void prepareCoherenceSessionIfNeeded(CoherenceHibernateProperties coherenceHibernateProperties) {
        if (this.coherenceSession == null) {
            if (coherenceHibernateProperties.getSessionType() == null || SessionType.SERVER.equals((Object)coherenceHibernateProperties.getSessionType())) {
                if (coherenceHibernateProperties.isStartCacheServer()) {
                    ExtensibleConfigurableCacheFactory.Dependencies deps = ExtensibleConfigurableCacheFactory.DependenciesHelper.newInstance((String)coherenceHibernateProperties.getCacheConfigFilePath());
                    ExtensibleConfigurableCacheFactory cacheFactory = new ExtensibleConfigurableCacheFactory(deps);
                    this.defaultCacheServer = new DefaultCacheServer((ConfigurableCacheFactory)cacheFactory);
                    this.defaultCacheServer.startDaemon(5000L);
                }
                CacheFactory.ensureCluster();
            }
            ArrayList<Object> sessionOptions = new ArrayList<Object>();
            if (coherenceHibernateProperties.getSessionName() != null) {
                sessionOptions.add(ConfigUtils.getSessionNameOption(coherenceHibernateProperties.getSessionName()));
            }
            WithConfiguration cacheConfigFilePathOption = WithConfiguration.using((String)coherenceHibernateProperties.getCacheConfigFilePath());
            WithClassLoader classLoaderOption = WithClassLoader.using((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            sessionOptions.add(cacheConfigFilePathOption);
            sessionOptions.add(classLoaderOption);
            Session sessionToSet = Session.create((Session.Option[])sessionOptions.toArray(new Session.Option[0]));
            this.setCoherenceSession(sessionToSet);
        }
    }

    protected void releaseFromUse() {
        block8: {
            if (this.getCoherenceSession() != null) {
                try {
                    this.coherenceSession.close();
                }
                catch (Exception ex) {
                    if (!LOGGER.isErrorEnabled()) break block8;
                    LOGGER.error("Unable to close session '{}'.", (Object)this.coherenceSession, (Object)ex);
                }
            }
        }
        if (this.requiresShutDown) {
            CacheFactory.getCluster().shutdown();
            CacheFactory.shutdown();
            if (this.defaultCacheServer != null) {
                this.defaultCacheServer.shutdownServer();
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Skipping Coherence shutdown as requiresShutDown flag is false.");
        }
        System.clearProperty("coherence.log");
        this.systemPropertyResolver.unset();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Shutdown of Coherence complete.");
        }
        this.setCoherenceSession(null);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.READ_WRITE;
    }

    public long nextTimestamp() {
        if (this.cluster == null) {
            return System.currentTimeMillis();
        }
        return CacheFactory.ensureCluster().getTimeMillis();
    }

    protected NamedCache<?, ?> ensureNamedCache(String cacheName) {
        return this.coherenceSession.getCache(cacheName, new NamedMap.Option[0]);
    }

    protected DomainDataStorageAccess createDomainDataStorageAccess(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        return new CoherenceStorageAccessImpl(this.createCoherenceRegion(regionConfig.getRegionName(), buildingContext.getSessionFactory()));
    }

    protected StorageAccess createTimestampsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        return new CoherenceStorageAccessImpl(this.createCoherenceRegion(regionName, sessionFactory));
    }

    protected StorageAccess createQueryResultsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        return new CoherenceStorageAccessImpl(this.createCoherenceRegion(regionName, sessionFactory));
    }

    protected CoherenceRegion createCoherenceRegion(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory) {
        return new CoherenceRegion((RegionFactory)this, this.ensureNamedCache(unqualifiedRegionName), sessionFactory.getProperties());
    }

    public DomainDataRegion buildDomainDataRegion(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        return new CoherenceDomainDataRegionImpl(regionConfig, this, this.createDomainDataStorageAccess(regionConfig, buildingContext), this.cacheKeysFactory, buildingContext);
    }
}

