/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.google.protobuf.ByteString;
import com.oracle.coherence.client.AsyncNamedCacheClient;
import com.oracle.coherence.grpc.EntryResult;
import com.tangosol.net.RequestIncompleteException;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.PagedIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public abstract class RemoteCollection<K, V, T>
implements Collection<T> {
    protected final AsyncNamedCacheClient<K, V> f_client;

    protected RemoteCollection(AsyncNamedCacheClient<K, V> client) {
        this.f_client = client;
    }

    @Override
    public int size() {
        try {
            return this.f_client.size().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.f_client.isEmpty().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("add operations are not supported");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("add operations are not supported");
    }

    @Override
    public void clear() {
        try {
            this.f_client.clear().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    @Override
    public boolean containsAll(Collection<?> colKeys) {
        if (colKeys == null) {
            throw new NullPointerException("collection parameter cannot be null");
        }
        if (colKeys.isEmpty()) {
            return true;
        }
        for (Object o : colKeys) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> colKeys) {
        boolean fModified = false;
        if (this.size() > colKeys.size()) {
            for (Object colKey : colKeys) {
                fModified |= this.remove(colKey);
            }
        } else {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                if (!colKeys.contains(iter.next())) continue;
                iter.remove();
                fModified = true;
            }
        }
        return fModified;
    }

    @Override
    public boolean retainAll(Collection<?> colKeys) {
        boolean fModified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (colKeys.contains(o)) continue;
            iter.remove();
            fModified = true;
        }
        return fModified;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Collection) {
            Collection colOther = (Collection)other;
            if (colOther.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(colOther);
            }
            catch (ClassCastException | NullPointerException unused) {
                return false;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Object obj : this) {
            if (obj == null) continue;
            h += obj.hashCode();
        }
        return h;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(name='" + this.f_client.getCacheName() + "')";
    }

    protected AsyncNamedCacheClient<K, V> getCache() {
        return this.f_client;
    }

    protected EntryAdvancer<K, V> createEntryAdvancer() {
        return new EntryAdvancer<K, V>(this.getCache());
    }

    protected static class EntryAdvancer<K, V>
    implements PagedIterator.Advancer {
        protected boolean m_exhausted;
        protected ByteString m_cookie;
        protected final AsyncNamedCacheClient<K, V> m_client;

        protected EntryAdvancer(AsyncNamedCacheClient<K, V> client) {
            this.m_client = client;
        }

        public void remove(Object oCurr) {
            Map.Entry entry = (Map.Entry)oCurr;
            try {
                this.m_client.removeInternal(entry.getKey()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RequestIncompleteException((Throwable)e);
            }
        }

        public Collection nextPage() {
            if (this.m_exhausted) {
                return null;
            }
            LinkedList list = this.m_client.getEntriesPage(this.m_cookie).collect(Collectors.toCollection(LinkedList::new));
            this.m_cookie = list.size() > 0 ? ((EntryResult)list.poll()).getCookie() : null;
            this.m_exhausted = this.m_cookie == null || this.m_cookie.isEmpty();
            ConverterCollections.ConverterCollection entries = ConverterCollections.getCollection((Collection)list, this::fromEntryResult, this::toEntryResult);
            return ConverterCollections.getEntrySet((Collection)entries, this.m_client::fromByteString, this.m_client::toKeyByteString, this.m_client::fromByteString, this.m_client::toByteString);
        }

        protected Map.Entry<ByteString, ByteString> fromEntryResult(EntryResult result) {
            return new EntryResultMapEntry(result);
        }

        protected EntryResult toEntryResult(Map.Entry<ByteString, ByteString> entry) {
            return EntryResult.newBuilder().setKey(this.m_client.toKeyByteString(entry.getKey())).setValue(this.m_client.toByteString(entry.getValue())).build();
        }
    }

    protected static class EntryResultMapEntry
    implements Map.Entry<ByteString, ByteString> {
        private EntryResult entryResult;

        protected EntryResultMapEntry(EntryResult entryResult) {
            this.entryResult = entryResult;
        }

        @Override
        public ByteString getKey() {
            return this.entryResult.getKey();
        }

        @Override
        public ByteString getValue() {
            return this.entryResult.getValue();
        }

        @Override
        public ByteString setValue(ByteString value) {
            ByteString old = this.entryResult.getValue();
            this.entryResult = this.entryResult.toBuilder().setValue(value).build();
            return old;
        }
    }
}

