/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.GrpcRemoteCacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.internal.AbstractEventDispatcher;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.net.events.partition.cache.CacheLifecycleEventDispatcher;
import com.tangosol.net.events.partition.cache.PartitionedCacheDispatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GrpcCacheLifecycleEventDispatcher
extends AbstractEventDispatcher
implements CacheLifecycleEventDispatcher {
    protected static final Set<Enum> EVENT_TYPES = new HashSet<Enum>();
    private final String f_sCacheName;
    private final GrpcRemoteCacheService f_service;

    GrpcCacheLifecycleEventDispatcher(String sCacheName, GrpcRemoteCacheService service) {
        super(EVENT_TYPES);
        this.f_sCacheName = sCacheName;
        this.f_service = Objects.requireNonNull(service);
    }

    public String getCacheName() {
        return this.f_sCacheName;
    }

    public String getServiceName() {
        return this.f_service == null ? "" : this.f_service.getInfo().getServiceName();
    }

    public String getScopeName() {
        return this.f_service == null ? "$SYS" : this.f_service.getScopeName();
    }

    public void dispatchCacheCreated(NamedCache<?, ?> cache) {
        this.dispatchCacheEvent(CacheLifecycleEvent.Type.CREATED, cache);
    }

    public void dispatchCacheDestroyed(NamedCache<?, ?> cache) {
        this.dispatchCacheEvent(CacheLifecycleEvent.Type.DESTROYED, cache);
    }

    public void dispatchCacheTruncated(NamedCache<?, ?> cache) {
        this.dispatchCacheEvent(CacheLifecycleEvent.Type.TRUNCATED, cache);
    }

    public GrpcRemoteCacheService getService() {
        return this.f_service;
    }

    protected void dispatchCacheEvent(CacheLifecycleEvent.Type eventType, NamedCache<?, ?> cache) {
        List list = (List)this.getInterceptorMap().get(eventType);
        if (list != null) {
            new GrpcCacheLifecycleEvent(this, eventType, cache).dispatch(list);
        }
    }

    static {
        EVENT_TYPES.addAll(Arrays.asList(CacheLifecycleEvent.Type.values()));
    }

    protected static class GrpcCacheLifecycleEvent
    extends AbstractEvent<CacheLifecycleEvent.Type>
    implements CacheLifecycleEvent {
        private final NamedCache<?, ?> f_cache;

        protected GrpcCacheLifecycleEvent(GrpcCacheLifecycleEventDispatcher dispatcher, CacheLifecycleEvent.Type eventType, NamedCache<?, ?> cache) {
            super(dispatcher, eventType);
            this.f_cache = cache;
        }

        protected String getDescription() {
            return super.getDescription() + ", Session=" + this.getSessionName() + ", Scope=" + this.getScopeName() + ", Cache=" + this.getCacheName();
        }

        public String getCacheName() {
            return this.f_cache.getCacheName();
        }

        public String getServiceName() {
            return null;
        }

        public String getScopeName() {
            return this.getEventDispatcher().getScopeName();
        }

        public String getSessionName() {
            GrpcCacheLifecycleEventDispatcher dispatcher = (GrpcCacheLifecycleEventDispatcher)this.getEventDispatcher();
            GrpcRemoteCacheService cacheService = dispatcher.getService();
            String sName = (String)cacheService.getBackingMapManager().getCacheFactory().getResourceRegistry().getResource(String.class, "$SESSION$");
            return sName == null ? "" : sName;
        }

        public CacheLifecycleEventDispatcher getEventDispatcher() {
            return (CacheLifecycleEventDispatcher)this.m_dispatcher;
        }

        public PartitionedCacheDispatcher getDispatcher() {
            return null;
        }

        protected void dispatch(Collection<? extends EventInterceptor<?>> colIter) {
            super.dispatch(colIter);
        }
    }

    protected static abstract class AbstractEvent<T extends Enum<T>>
    extends com.tangosol.net.events.internal.AbstractEvent<T> {
        public AbstractEvent(GrpcCacheLifecycleEventDispatcher dispatcher, T eventType) {
            super((EventDispatcher)dispatcher, eventType);
        }
    }
}

