/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.common.base.Logger;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ClientLoggingInterceptor
implements ClientInterceptor {
    public static final Metadata.Key<String> TRACE_ID_KEY = Metadata.Key.of((String)"loggingId", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final AtomicLong TRACE_ID = new AtomicLong();

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions options, Channel next) {
        return new ClientLoggingForwardingClientCall<ReqT, RespT>(method, next.newCall(method, options.withDeadlineAfter(10000L, TimeUnit.MILLISECONDS))){

            public void sendMessage(ReqT message) {
                Logger.info(() -> String.format("In sendMessage method=%s, message=%s", method, message));
                super.sendMessage(message);
            }

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(TRACE_ID_KEY, (Object)String.valueOf(TRACE_ID.getAndIncrement()));
                Logger.info(() -> String.format("In start method=%s", method));
                ClientLoggingListener backendListener = new ClientLoggingListener(this.methodName, responseListener);
                super.start(backendListener, headers);
            }

            public void request(int numMessages) {
                Logger.info(() -> String.format("In request method=%s", method));
                super.request(numMessages);
            }

            public void cancel(String message, Throwable cause) {
                Logger.info(() -> String.format("In cancel method=%s", method));
                super.cancel(message, cause);
            }

            public void halfClose() {
                Logger.info(() -> String.format("In halfClose method=%s", method));
                super.halfClose();
            }

            public void setMessageCompression(boolean enabled) {
                Logger.info(() -> String.format("In setMessageCompression method=%s", method));
                super.setMessageCompression(enabled);
            }

            public boolean isReady() {
                Logger.info(() -> String.format("In isReady method=%s", method));
                return super.isReady();
            }

            public Attributes getAttributes() {
                Logger.info(() -> String.format("In getAttributes method=%s", method));
                return super.getAttributes();
            }
        };
    }

    private static class ClientLoggingForwardingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        String methodName;

        protected ClientLoggingForwardingClientCall(MethodDescriptor<ReqT, RespT> method, ClientCall<ReqT, RespT> delegate) {
            super(delegate);
            this.methodName = method.getFullMethodName();
        }
    }

    private static class ClientLoggingListener<RespT>
    extends ClientCall.Listener<RespT> {
        String methodName;
        ClientCall.Listener<RespT> responseListener;

        protected ClientLoggingListener(String methodName, ClientCall.Listener<RespT> responseListener) {
            this.methodName = methodName;
            this.responseListener = responseListener;
        }

        public void onMessage(RespT message) {
            Logger.info(() -> String.format("In onMessage method=%s, message=%s", this.methodName, message));
            this.responseListener.onMessage(message);
        }

        public void onHeaders(Metadata headers) {
            this.responseListener.onHeaders(headers);
        }

        public void onClose(Status status, Metadata trailers) {
            this.responseListener.onClose(status, trailers);
        }

        public void onReady() {
            this.responseListener.onReady();
        }
    }
}

