/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.AsyncNamedCacheClient;
import com.oracle.coherence.client.RemoteCollection;
import com.tangosol.net.RequestIncompleteException;
import com.tangosol.util.Filters;
import com.tangosol.util.PagedIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class RemoteEntrySet<K, V>
extends RemoteCollection<K, V, Map.Entry<K, V>>
implements Set<Map.Entry<K, V>> {
    protected RemoteEntrySet(AsyncNamedCacheClient<K, V> map) {
        super(map);
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new NullPointerException("entry cannot be null");
        }
        if (o instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)o;
            Object oKey = entry.getKey();
            Object oValue = entry.getValue();
            return this.getCache().containsEntry(oKey, oValue);
        }
        return false;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new PagedIterator(this.createEntryAdvancer());
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)o;
            Object oKey = entry.getKey();
            Object oValue = entry.getValue();
            try {
                return this.getCache().remove(oKey, oValue).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RequestIncompleteException((Throwable)e);
            }
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        try {
            return ((Set)this.getCache().entrySet(Filters.always()).get()).toArray();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    @Override
    public <T1> T1[] toArray(T1[] array) {
        try {
            return ((Set)this.getCache().entrySet(Filters.always()).get()).toArray(array);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }
}

