/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Empty;
import com.google.protobuf.Int32Value;
import com.oracle.coherence.client.SingleValueStreamObserver;
import com.oracle.coherence.client.StreamStreamObserver;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.grpc.AddIndexRequest;
import com.oracle.coherence.grpc.AggregateRequest;
import com.oracle.coherence.grpc.ClearRequest;
import com.oracle.coherence.grpc.ContainsEntryRequest;
import com.oracle.coherence.grpc.ContainsKeyRequest;
import com.oracle.coherence.grpc.ContainsValueRequest;
import com.oracle.coherence.grpc.DestroyRequest;
import com.oracle.coherence.grpc.Entry;
import com.oracle.coherence.grpc.EntryResult;
import com.oracle.coherence.grpc.GetAllRequest;
import com.oracle.coherence.grpc.GetRequest;
import com.oracle.coherence.grpc.InvokeAllRequest;
import com.oracle.coherence.grpc.InvokeRequest;
import com.oracle.coherence.grpc.IsEmptyRequest;
import com.oracle.coherence.grpc.MapListenerRequest;
import com.oracle.coherence.grpc.MapListenerResponse;
import com.oracle.coherence.grpc.NamedCacheServiceGrpc;
import com.oracle.coherence.grpc.OptionalValue;
import com.oracle.coherence.grpc.PageRequest;
import com.oracle.coherence.grpc.PutAllRequest;
import com.oracle.coherence.grpc.PutIfAbsentRequest;
import com.oracle.coherence.grpc.PutRequest;
import com.oracle.coherence.grpc.RemoveIndexRequest;
import com.oracle.coherence.grpc.RemoveMappingRequest;
import com.oracle.coherence.grpc.RemoveRequest;
import com.oracle.coherence.grpc.ReplaceMappingRequest;
import com.oracle.coherence.grpc.ReplaceRequest;
import com.oracle.coherence.grpc.SizeRequest;
import com.oracle.coherence.grpc.TruncateRequest;
import com.oracle.coherence.grpc.ValuesRequest;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;

class NamedCacheGrpcClient {
    private final NamedCacheServiceGrpc.NamedCacheServiceStub f_stub;

    NamedCacheGrpcClient(Channel channel) {
        this.f_stub = NamedCacheServiceGrpc.newStub((Channel)channel);
    }

    CompletionStage<Empty> clear(ClearRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.clear(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BoolValue> containsEntry(ContainsEntryRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.containsEntry(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BoolValue> containsKey(ContainsKeyRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.containsKey(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BoolValue> containsValue(ContainsValueRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.containsValue(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BoolValue> isEmpty(IsEmptyRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.isEmpty(request, observer);
        return observer.completionStage();
    }

    CompletionStage<Int32Value> size(SizeRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.size(request, observer);
        return observer.completionStage();
    }

    CompletionStage<OptionalValue> get(GetRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.get(request, observer);
        return observer.completionStage();
    }

    Stream<Entry> getAll(GetAllRequest request) {
        try {
            StreamStreamObserver observer = new StreamStreamObserver();
            this.f_stub.getAll(request, observer);
            return observer.future().get().stream();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    CompletionStage<BytesValue> put(PutRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.put(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BytesValue> putIfAbsent(PutIfAbsentRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.putIfAbsent(request, observer);
        return observer.completionStage();
    }

    CompletionStage<Empty> putAll(PutAllRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.putAll(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BytesValue> remove(RemoveRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.remove(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BoolValue> removeMapping(RemoveMappingRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.removeMapping(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BytesValue> replace(ReplaceRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.replace(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BoolValue> replaceMapping(ReplaceMappingRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.replaceMapping(request, observer);
        return observer.completionStage();
    }

    Stream<BytesValue> nextKeySetPage(PageRequest request) {
        try {
            StreamStreamObserver observer = new StreamStreamObserver();
            this.f_stub.nextKeySetPage(request, observer);
            return observer.future().get().stream();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    Stream<EntryResult> nextEntrySetPage(PageRequest request) {
        try {
            StreamStreamObserver observer = new StreamStreamObserver();
            this.f_stub.nextEntrySetPage(request, observer);
            return observer.future().get().stream();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    CompletionStage<Empty> truncate(TruncateRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.truncate(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BytesValue> invoke(InvokeRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.invoke(request, observer);
        return observer.completionStage();
    }

    void invokeAll(InvokeAllRequest request, StreamObserver<Entry> observer) {
        this.f_stub.invokeAll(request, observer);
    }

    CompletionStage<Empty> destroy(DestroyRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.destroy(request, observer);
        return observer.completionStage();
    }

    CompletionStage<Empty> addIndex(AddIndexRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.addIndex(request, observer);
        return observer.completionStage();
    }

    CompletionStage<Empty> removeIndex(RemoveIndexRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.removeIndex(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BytesValue> aggregate(AggregateRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.f_stub.aggregate(request, observer);
        return observer.completionStage();
    }

    Stream<BytesValue> values(ValuesRequest request) {
        try {
            StreamStreamObserver observer = new StreamStreamObserver();
            this.f_stub.values(request, observer);
            return observer.future().get().stream();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    StreamObserver<MapListenerRequest> events(StreamObserver<MapListenerResponse> observer) {
        return this.f_stub.events(observer);
    }
}

