/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.template;

import com.openshift.restclient.model.template.IParameter;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;

public class Parameter
implements IParameter {
    private static final String VALUE = "value";
    private ModelNode node;

    public Parameter(ModelNode node) {
        this.node = node;
    }

    @Override
    public IParameter clone() {
        return new Parameter(this.node.clone());
    }

    @Override
    public String getName() {
        return this.asString("name");
    }

    @Override
    public String getDescription() {
        return this.asString("description");
    }

    @Override
    public void setValue(String value) {
        this.node.get(VALUE).set(value);
    }

    @Override
    public String getValue() {
        return this.asString(VALUE);
    }

    @Override
    public String getGeneratorName() {
        return StringUtils.defaultIfEmpty((String)this.asString("generate"), (String)this.asString("generator"));
    }

    @Override
    public String getFrom() {
        return this.asString("from");
    }

    @Override
    public boolean isRequired() {
        if (this.node.hasDefined("required")) {
            return this.node.get("required").asBoolean();
        }
        return false;
    }

    private String asString(String key) {
        ModelNode value = this.node.get(key);
        if (value.isDefined()) {
            return value.asString();
        }
        return "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getFrom() == null ? 0 : this.getFrom().hashCode()) + (this.getGeneratorName() == null ? 0 : this.getGeneratorName().hashCode()) + (this.getName() == null ? 0 : this.getName().hashCode()) + (this.getValue() == null ? 0 : this.getValue().hashCode()) + Boolean.valueOf(this.isRequired()).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.getFrom() == null ? other.getFrom() != null : !this.getFrom().equals(other.getFrom())) {
            return false;
        }
        if (this.getGeneratorName() == null ? other.getGeneratorName() != null : !this.getGeneratorName().equals(other.getGeneratorName())) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getValue() == null ? other.getValue() != null : !this.getValue().equals(other.getValue())) {
            return false;
        }
        return this.isRequired() == other.isRequired();
    }
}

