/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.capability.resources.AbstractOpenShiftBinaryCapability;
import com.openshift.restclient.IClient;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.capability.resources.IPortForwardable;
import com.openshift.restclient.model.IPod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OpenShiftBinaryPortForwarding
extends AbstractOpenShiftBinaryCapability
implements IPortForwardable {
    private final IPod pod;
    private final Collection<IPortForwardable.PortPair> pairs = new ArrayList<IPortForwardable.PortPair>();

    public OpenShiftBinaryPortForwarding(IPod pod, IClient client) {
        super(client);
        this.pod = pod;
    }

    @Override
    protected void cleanup() {
        this.pairs.clear();
    }

    @Override
    protected boolean validate() {
        return !this.pairs.isEmpty();
    }

    @Override
    public boolean isForwarding() {
        return this.getProcess() != null && this.getProcess().isAlive();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return OpenShiftBinaryPortForwarding.class.getSimpleName();
    }

    @Override
    public Collection<IPortForwardable.PortPair> getPortPairs() {
        return this.pairs;
    }

    @Override
    public synchronized void forwardPorts(Collection<IPortForwardable.PortPair> ports, IBinaryCapability.OpenShiftBinaryOption ... options) {
        if (ports == null || ports.isEmpty()) {
            throw new OpenShiftException("Port-forwarding was invoked but not port was specified.", new Object[0]);
        }
        this.pairs.addAll(ports);
        this.start(options);
    }

    @Override
    protected String buildArgs(List<IBinaryCapability.OpenShiftBinaryOption> options) {
        StringBuilder argBuilder = new StringBuilder();
        argBuilder.append("port-forward ");
        if (options.contains((Object)IBinaryCapability.OpenShiftBinaryOption.SKIP_TLS_VERIFY)) {
            argBuilder.append(this.getSkipTlsVerifyFlag());
        }
        argBuilder.append(this.getServerFlag()).append(this.getTokenFlag()).append("-n ").append(this.pod.getNamespace()).append(" ").append("-p ").append(this.pod.getName()).append(" ");
        for (IPortForwardable.PortPair pair : this.pairs) {
            argBuilder.append(pair.getLocalPort()).append(":").append(pair.getRemotePort()).append(" ");
        }
        return argBuilder.toString();
    }
}

