/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.internal.client.utils.Assert;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractCartridgeSelector {
    protected <C extends ICartridge> Collection<C> getAllMatching(Collection<C> cartridges) {
        ArrayList<ICartridge> matchingCartridges = new ArrayList<ICartridge>();
        if (cartridges == null) {
            return matchingCartridges;
        }
        for (ICartridge cartridge : cartridges) {
            if (!this.matches(cartridge)) continue;
            matchingCartridges.add(cartridge);
        }
        return matchingCartridges;
    }

    public abstract <C extends ICartridge> boolean matches(C var1);

    protected IOpenShiftConnection getConnection(IApplication application) {
        Assert.notNull(application);
        return application.getDomain().getUser().getConnection();
    }

    protected IOpenShiftConnection getConnection(IDomain domain) {
        Assert.notNull(domain);
        return domain.getUser().getConnection();
    }
}

