/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.eventtracker;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import com.ning.metrics.eventtracker.EventSender;
import com.ning.metrics.eventtracker.EventType;
import com.ning.metrics.eventtracker.ExpirationTimer;
import com.ning.metrics.serialization.writer.CallbackHandler;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSender
implements EventSender {
    private static final Logger log = LoggerFactory.getLogger(HttpSender.class);
    private static final Map<EventType, String> headers = new HashMap<EventType, String>();
    private final AtomicLong activeRequests = new AtomicLong(0L);
    private final Timer sendTimer;
    public static final String URI_PATH = "/rest/1.0/event";
    private static final int DEFAULT_IDLE_CONNECTION_IN_POOL_TIMEOUT_IN_MS = 120000;
    private final EventType eventType;
    private final long httpMaxWaitTimeInMillis;
    private final String collectorURI;
    private final AsyncHttpClientConfig clientConfig;
    private AsyncHttpClient client;
    private final ExpirationTimer httpConnectionExpiration;

    public HttpSender(String collectorHost, int collectorPort, EventType eventType, long httpMaxWaitTimeInMillis, long httpMaxKeepAliveInMillis) {
        this.eventType = eventType;
        this.httpMaxWaitTimeInMillis = httpMaxWaitTimeInMillis;
        this.httpConnectionExpiration = new ExpirationTimer(httpMaxKeepAliveInMillis);
        this.collectorURI = String.format("http://%s:%d%s", collectorHost, collectorPort, URI_PATH);
        this.sendTimer = Metrics.newTimer(HttpSender.class, (String)this.collectorURI.replace(":", "_"), (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.clientConfig = new AsyncHttpClientConfig.Builder().setIdleConnectionInPoolTimeoutInMs(120000).setConnectionTimeoutInMs(100).setMaximumConnectionsPerHost(-1).build();
    }

    public void send(final File file, final CallbackHandler handler) {
        if (this.client == null || this.client.isClosed()) {
            this.client = new AsyncHttpClient(this.clientConfig);
        }
        log.info("Sending local file to collector: {}", (Object)file.getAbsolutePath());
        final long startTime = System.nanoTime();
        boolean needToClose = this.httpConnectionExpiration.isExpired(System.currentTimeMillis());
        Request request = this.createPostRequest(file, needToClose);
        try {
            this.client.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response response) {
                    HttpSender.this.activeRequests.decrementAndGet();
                    if (response.getStatusCode() == 202) {
                        handler.onSuccess(file);
                    } else {
                        handler.onError((Throwable)new IOException(String.format("Received response %d: %s", response.getStatusCode(), response.getStatusText())), file);
                    }
                    HttpSender.this.sendTimer.update(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
                    return response;
                }

                public void onThrowable(Throwable t) {
                    HttpSender.this.activeRequests.decrementAndGet();
                    handler.onError(t, file);
                }
            });
            this.activeRequests.incrementAndGet();
        }
        catch (IOException e) {
            this.client.close();
            handler.onError((Throwable)e, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.client != null && !this.client.isClosed()) {
            try {
                if (this.activeRequests.get() > 0L) {
                    log.info(String.format("%d HTTP request(s) in progress, giving them some time to finish...", this.activeRequests.get()));
                }
                for (long sleptInMillins = this.httpMaxWaitTimeInMillis; this.activeRequests.get() > 0L && sleptInMillins >= 0L; sleptInMillins -= 200L) {
                    Thread.sleep(200L);
                }
                if (this.activeRequests.get() > 0L) {
                    log.warn("Giving up on pending HTTP requests, shutting down NOW!");
                }
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for active queries to finish");
                Thread.currentThread().interrupt();
            }
            finally {
                this.client.close();
            }
        }
    }

    private Request createPostRequest(File file, boolean needToClose) {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = ((AsyncHttpClient.BoundRequestBuilder)this.client.preparePost(this.collectorURI).setBody(file)).setHeader("Content-Type", headers.get(this.eventType));
        if (needToClose) {
            requestBuilder = requestBuilder.setHeader("Connection", "close");
        }
        return requestBuilder.build();
    }

    static {
        headers.put(EventType.SMILE, "application/json+smile");
        headers.put(EventType.JSON, "application/json");
        headers.put(EventType.THRIFT, "ning/thrift");
        headers.put(EventType.DEFAULT, "ning/1.0");
    }
}

