/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.eventtracker;

public class ExpirationTimer {
    private final long maxKeepAliveMsecs;
    private long expirationTime = 0L;

    public ExpirationTimer(long max) {
        this.maxKeepAliveMsecs = max;
    }

    public final boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    public synchronized boolean isExpired(long now) {
        if (this.expirationTime == 0L) {
            this.expirationTime = now + this.maxKeepAliveMsecs;
            return false;
        }
        if (now >= this.maxKeepAliveMsecs) {
            this.expirationTime = 0L;
            return true;
        }
        return false;
    }
}

