/*
 * Decompiled with CFR 0.152.
 */
package com.ning.metrics.eventtracker;

import com.ning.metrics.eventtracker.CollectorControllerModule;
import com.ning.metrics.eventtracker.EventSender;
import com.ning.metrics.eventtracker.HttpSender;
import com.ning.metrics.eventtracker.NoLoggingSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorControllerHttpModule
extends CollectorControllerModule {
    private static final Logger log = LoggerFactory.getLogger(CollectorControllerHttpModule.class);

    protected void configure() {
        super.configure();
        switch (this.eventTrackerConfig.getType()) {
            case COLLECTOR: {
                HttpSender httpSender = new HttpSender(this.eventTrackerConfig.getCollectorHost(), this.eventTrackerConfig.getCollectorPort(), this.eventTrackerConfig.getEventType(), this.eventTrackerConfig.getHttpMaxWaitTimeInMillis(), this.eventTrackerConfig.getHttpMaxKeepAlive().getMillis());
                this.bind(EventSender.class).toInstance((Object)httpSender);
                log.info("Enabled HTTP Event Logging");
                break;
            }
            case NO_LOGGING: {
                this.bind(EventSender.class).to(NoLoggingSender.class).asEagerSingleton();
                log.info("Disabled Event Logging");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type " + this.eventTrackerConfig.getType());
            }
        }
    }
}

