/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.grants.password.webapi;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.provider.spi.InitContext;
import com.nimbusds.openid.connect.provider.spi.grants.PasswordGrantAuthorization;
import com.nimbusds.openid.connect.provider.spi.grants.PasswordGrantHandler;
import com.nimbusds.openid.connect.provider.spi.grants.password.webapi.Configuration;
import com.nimbusds.openid.connect.provider.spi.grants.password.webapi.HandlerRequest;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import net.minidev.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PasswordGrantWebAPI
implements PasswordGrantHandler {
    public static final String CONFIG_FILE_PATH = "/WEB-INF/passwordGrantHandlerWebAPI.properties";
    private Configuration config;
    private static final Logger mainLog = LogManager.getLogger((String)"MAIN");
    private static final Logger tokenEndpointLog = LogManager.getLogger((String)"TOKEN");

    private static Configuration loadConfiguration(InitContext initContext) throws Exception {
        InputStream inputStream = initContext.getResourceAsStream(CONFIG_FILE_PATH);
        if (inputStream == null) {
            throw new Exception("Couldn't find password grant handler configuration file: /WEB-INF/passwordGrantHandlerWebAPI.properties");
        }
        Properties props = new Properties();
        props.load(inputStream);
        PasswordGrantWebAPI.logOverridingSystemProperties();
        props.putAll((Map<?, ?>)System.getProperties());
        return new Configuration(props);
    }

    public static void logOverridingSystemProperties() {
        Properties sysProps = System.getProperties();
        StringBuilder sb = new StringBuilder();
        for (String key : sysProps.stringPropertyNames()) {
            if (!key.startsWith("op.grantHandler.password.webAPI.")) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(key);
        }
        mainLog.info("Overriding system properties: {}", new Object[]{sb});
    }

    public void init(InitContext initContext) throws Exception {
        mainLog.info("Initializing password grant handler...");
        this.config = PasswordGrantWebAPI.loadConfiguration(initContext);
        this.config.log();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public boolean isEnabled() {
        return this.config.enable;
    }

    public GrantType getGrantType() {
        return GrantType.PASSWORD;
    }

    public PasswordGrantAuthorization processGrant(ResourceOwnerPasswordCredentialsGrant grant, Scope scope, ClientID clientID, boolean confidentialClient, OIDCClientMetadata clientMetadata) throws GeneralException {
        HTTPResponse httpResponse;
        if (!this.config.enable) {
            throw new GeneralException("Grant handler disabled", OAuth2Error.UNSUPPORTED_GRANT_TYPE);
        }
        tokenEndpointLog.debug("Password grant handler: Received request with username={} password=[hidden] scope={}", new Object[]{grant.getUsername(), scope});
        HandlerRequest request = new HandlerRequest(grant, scope, clientID, confidentialClient, clientMetadata);
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.config.url);
        httpRequest.setAuthorization(this.config.apiAccessToken.toAuthorizationHeader());
        httpRequest.setContentType(CommonContentTypes.APPLICATION_JSON);
        httpRequest.setQuery(request.toJSONObject().toJSONString());
        httpRequest.setConnectTimeout(this.config.connectTimeout);
        httpRequest.setReadTimeout(this.config.readTimeout);
        tokenEndpointLog.debug("Password grant handler: Making HTTP post request to {}", new Object[]{httpRequest.getURL()});
        try {
            httpResponse = httpRequest.send();
        }
        catch (IOException e) {
            tokenEndpointLog.error("Password grant handler: HTTP exception: " + e.getMessage(), (Throwable)e);
            throw new GeneralException("Server error", OAuth2Error.SERVER_ERROR);
        }
        if (httpResponse.getStatusCode() != 200) {
            ErrorObject errorObject = PasswordGrantWebAPI.processNon200Response(httpResponse);
            throw new GeneralException(errorObject.getCode(), errorObject);
        }
        tokenEndpointLog.debug("Password grant handler: Received authorization response: {}", new Object[]{httpResponse.getContent()});
        try {
            return PasswordGrantAuthorization.parse((JSONObject)httpResponse.getContentAsJSONObject());
        }
        catch (Exception e) {
            tokenEndpointLog.error("Password grant handler: Invalid authorization response: {}", new Object[]{e.getMessage(), e});
            throw new GeneralException("Server error", OAuth2Error.SERVER_ERROR);
        }
    }

    public static ErrorObject processNon200Response(HTTPResponse httpResponse) {
        if (httpResponse.getStatusCode() != 400) {
            tokenEndpointLog.error("Password grant handler: Unexpected HTTP response: {}", new Object[]{httpResponse.getStatusCode()});
            return OAuth2Error.SERVER_ERROR;
        }
        ErrorObject errorObject = ErrorObject.parse((HTTPResponse)httpResponse);
        if (errorObject.getCode() == null || !errorObject.equals((Object)OAuth2Error.INVALID_GRANT) && !errorObject.equals((Object)OAuth2Error.INVALID_SCOPE)) {
            tokenEndpointLog.error("Password grant handler: Missing or unexpected error code: {}", new Object[]{errorObject.getCode()});
            return OAuth2Error.SERVER_ERROR;
        }
        tokenEndpointLog.info("Password grant handler: Token request denied: {}", new Object[]{errorObject.getCode()});
        return errorObject;
    }

    public void shutdown() throws Exception {
    }
}

