/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.grants.password.webapi;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import net.minidev.json.JSONObject;

public final class HandlerRequest {
    private final ResourceOwnerPasswordCredentialsGrant grant;
    private final Scope scope;
    private final ClientID clientID;
    private final boolean confidentialClient;
    private final OIDCClientMetadata clientMetadata;

    public HandlerRequest(ResourceOwnerPasswordCredentialsGrant grant, Scope scope, ClientID clientID, boolean confidentialClient, OIDCClientMetadata clientMetadata) {
        if (grant == null) {
            throw new IllegalArgumentException("The grant must not be null");
        }
        this.grant = grant;
        this.scope = scope;
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID not be null");
        }
        this.clientID = clientID;
        this.confidentialClient = confidentialClient;
        if (clientMetadata == null) {
            throw new IllegalArgumentException("The client metadata must not be null");
        }
        this.clientMetadata = clientMetadata;
    }

    public ResourceOwnerPasswordCredentialsGrant getGrant() {
        return this.grant;
    }

    public Scope getScope() {
        return this.scope;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public boolean isConfidentialClient() {
        return this.confidentialClient;
    }

    public OIDCClientMetadata getClientMetadata() {
        return this.clientMetadata;
    }

    public JSONObject toJSONObject() {
        JSONObject clientJSONObject;
        JSONObject o = new JSONObject();
        o.put((Object)"username", (Object)this.grant.getUsername());
        o.put((Object)"password", (Object)this.grant.getPassword().getValue());
        if (this.scope != null) {
            o.put((Object)"scope", (Object)this.scope.toStringList());
        }
        if (!(clientJSONObject = this.clientMetadata.toJSONObject()).containsKey((Object)"require_auth_time")) {
            clientJSONObject.put((Object)"require_auth_time", (Object)false);
        }
        clientJSONObject.put((Object)"client_id", (Object)this.clientID.getValue());
        clientJSONObject.put((Object)"confidential", (Object)this.confidentialClient);
        o.put((Object)"client", (Object)clientJSONObject);
        return o;
    }

    public static HandlerRequest parse(JSONObject jsonObject) throws ParseException {
        String username = JSONObjectUtils.getString((JSONObject)jsonObject, (String)"username");
        Secret password = new Secret(JSONObjectUtils.getString((JSONObject)jsonObject, (String)"password"));
        ResourceOwnerPasswordCredentialsGrant grant = new ResourceOwnerPasswordCredentialsGrant(username, password);
        Scope scope = null;
        if (jsonObject.containsKey((Object)"scope")) {
            scope = new Scope(JSONObjectUtils.getStringArray((JSONObject)jsonObject, (String)"scope"));
        }
        JSONObject clientObject = JSONObjectUtils.getJSONObject((JSONObject)jsonObject, (String)"client");
        ClientID clientID = new ClientID(JSONObjectUtils.getString((JSONObject)clientObject, (String)"client_id"));
        boolean confidentialClient = JSONObjectUtils.getBoolean((JSONObject)clientObject, (String)"confidential");
        OIDCClientMetadata clientMetadata = OIDCClientMetadata.parse((JSONObject)clientObject);
        return new HandlerRequest(grant, scope, clientID, confidentialClient, clientMetadata);
    }
}

