/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.grants.password.webapi;

import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.common.config.LoggableConfiguration;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.net.URL;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Configuration
implements LoggableConfiguration {
    public static final String DEFAULT_PREFIX = "op.grantHandler.password.webAPI.";
    public final boolean enable;
    public final URL url;
    public final BearerAccessToken apiAccessToken;
    public final int connectTimeout;
    public final int readTimeout;

    public Configuration(Properties props) throws ConfigurationException {
        PropertyRetriever pr = new PropertyRetriever(props);
        try {
            this.enable = pr.getBoolean("op.grantHandler.password.webAPI.enable");
            this.url = pr.getURL("op.grantHandler.password.webAPI.url");
            this.apiAccessToken = new BearerAccessToken(pr.getString("op.grantHandler.password.webAPI.apiAccessToken"));
            this.connectTimeout = pr.getInt("op.grantHandler.password.webAPI.connectTimeout");
            this.readTimeout = pr.getInt("op.grantHandler.password.webAPI.readTimeout");
        }
        catch (PropertyParseException e) {
            throw new ConfigurationException(e.getMessage() + ": Property: " + e.getPropertyKey());
        }
    }

    public void log() {
        Logger log = LogManager.getLogger((String)"MAIN");
        log.info("Password grant handler web API enabled: {}", new Object[]{this.enable});
        log.info("Password grant handler web API URL: {}", new Object[]{this.url});
        log.info("Password grant handler web API HTTP connect timeout: {} ms", new Object[]{this.connectTimeout});
        log.info("Password grant handler web API HTTP read timeout: {} ms", new Object[]{this.readTimeout});
    }
}

