/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.grants.jwt.selfissued.handler;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.provider.spi.InitContext;
import com.nimbusds.openid.connect.provider.spi.grants.AccessTokenSpec;
import com.nimbusds.openid.connect.provider.spi.grants.ClaimsSpec;
import com.nimbusds.openid.connect.provider.spi.grants.IDTokenSpec;
import com.nimbusds.openid.connect.provider.spi.grants.SelfIssuedAssertionAuthorization;
import com.nimbusds.openid.connect.provider.spi.grants.SelfIssuedJWTGrantHandler;
import com.nimbusds.openid.connect.provider.spi.grants.jwt.selfissued.handler.Configuration;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleSelfIssuedJWTGrantHandler
implements SelfIssuedJWTGrantHandler {
    public static final String CONFIG_FILE_PATH = "/WEB-INF/selfIssuedJWTBearerHandler.properties";
    private Configuration config;
    private static final Logger MAIN_LOG = LogManager.getLogger((String)"MAIN");
    private static final Logger TOKEN_ENDPOINT_LOG = LogManager.getLogger((String)"TOKEN");

    private static Configuration loadConfiguration(InitContext initContext) throws Exception {
        InputStream inputStream = initContext.getResourceAsStream(CONFIG_FILE_PATH);
        if (inputStream == null) {
            throw new Exception("Couldn't find self-issued JWT bearer grant handler configuration file: /WEB-INF/selfIssuedJWTBearerHandler.properties");
        }
        Properties props = new Properties();
        props.load(inputStream);
        SimpleSelfIssuedJWTGrantHandler.logOverridingSystemProperties();
        props.putAll((Map<?, ?>)System.getProperties());
        return new Configuration(props);
    }

    public static void logOverridingSystemProperties() {
        Properties sysProps = System.getProperties();
        StringBuilder sb = new StringBuilder();
        for (String key : sysProps.stringPropertyNames()) {
            if (!key.startsWith("op.grantHandler.selfIssuedJWTBearer.")) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(key);
        }
        MAIN_LOG.info("[SJH 0001] Overriding system properties: {}", new Object[]{sb});
    }

    public void init(InitContext initContext) throws Exception {
        MAIN_LOG.info("[SJH 0000] Initializing self-issued JWT bearer grant handler...");
        this.config = SimpleSelfIssuedJWTGrantHandler.loadConfiguration(initContext);
        this.config.log();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public GrantType getGrantType() {
        return GrantType.JWT_BEARER;
    }

    public boolean isEnabled() {
        return this.config.enable;
    }

    public SelfIssuedAssertionAuthorization processSelfIssuedGrant(JWTClaimsSet jwtClaimsSet, Scope scope, ClientID clientID, OIDCClientMetadata clientMetadata) throws GeneralException {
        Scope authorizedScope;
        TOKEN_ENDPOINT_LOG.debug("[SJH 0002] Self-issued JWT bearer grant handler: Received request from client_id={} with scope={}", new Object[]{clientID, scope});
        Scope registeredScopeValues = clientMetadata.getScope();
        if (registeredScopeValues == null || registeredScopeValues.isEmpty()) {
            String msg = "No registered scopes for client";
            throw new GeneralException(msg, OAuth2Error.INVALID_SCOPE.setDescription(msg));
        }
        if (scope == null || scope.isEmpty()) {
            authorizedScope = registeredScopeValues;
        } else {
            authorizedScope = scope;
            authorizedScope.retainAll((Collection)registeredScopeValues);
            if (authorizedScope.isEmpty()) {
                String msg = "None of the requested scope values are permitted for this client";
                throw new GeneralException(msg, OAuth2Error.INVALID_SCOPE.setDescription(msg));
            }
        }
        Subject sub = new Subject(jwtClaimsSet.getSubject());
        AccessTokenSpec accessTokenSpec = new AccessTokenSpec(this.config.accessToken.lifetime, this.config.accessToken.audienceList, this.config.accessToken.encoding, this.config.accessToken.encrypt);
        return new SelfIssuedAssertionAuthorization(sub, authorizedScope, accessTokenSpec, IDTokenSpec.NONE, SimpleSelfIssuedJWTGrantHandler.resolveOpenIDClaims(authorizedScope), null);
    }

    public static ClaimsSpec resolveOpenIDClaims(Scope authorizedScope) {
        HashSet claimNames = new HashSet();
        if (authorizedScope.contains((Object)OIDCScopeValue.EMAIL)) {
            claimNames.addAll(OIDCScopeValue.EMAIL.getClaimNames());
        }
        if (authorizedScope.contains((Object)OIDCScopeValue.PHONE)) {
            claimNames.addAll(OIDCScopeValue.PHONE.getClaimNames());
        }
        if (authorizedScope.contains((Object)OIDCScopeValue.PROFILE)) {
            claimNames.addAll(OIDCScopeValue.PROFILE.getClaimNames());
        }
        if (authorizedScope.contains((Object)OIDCScopeValue.ADDRESS)) {
            claimNames.addAll(OIDCScopeValue.ADDRESS.getClaimNames());
        }
        if (!claimNames.isEmpty()) {
            return new ClaimsSpec(claimNames);
        }
        return ClaimsSpec.NONE;
    }

    public void shutdown() throws Exception {
        MAIN_LOG.info("[SJH 0003] Shut down self-issued JWT bearer grant handler");
    }
}

