/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.provider.spi.grants.jwt.selfissued.handler;

import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.common.config.LoggableConfiguration;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.token.TokenEncoding;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Configuration
implements LoggableConfiguration {
    public static final String PREFIX = "op.grantHandler.selfIssuedJWTBearer.";
    public final boolean enable;
    public final AccessToken accessToken;

    public Configuration(Properties props) throws ConfigurationException {
        PropertyRetriever pr = new PropertyRetriever(props);
        try {
            this.enable = pr.getBoolean("op.grantHandler.selfIssuedJWTBearer.enable");
            this.accessToken = new AccessToken("op.grantHandler.selfIssuedJWTBearer.accessToken.", props);
        }
        catch (PropertyParseException e) {
            throw new ConfigurationException(e.getMessage() + ": Property: " + e.getPropertyKey());
        }
    }

    public void log() {
        Logger log = LogManager.getLogger((String)"MAIN");
        log.info("[SJH0014] Self-issued JWT bearer grant handler enabled: {}", new Object[]{this.enable});
    }

    public static class AccessToken
    implements LoggableConfiguration {
        public final long lifetime;
        public final TokenEncoding encoding;
        public final boolean encrypt;
        public final List<Audience> audienceList;

        public AccessToken(String prefix, Properties props) throws PropertyParseException {
            PropertyRetriever pr = new PropertyRetriever(props);
            this.lifetime = pr.getLong(prefix + "lifetime");
            this.encoding = (TokenEncoding)pr.getEnum(prefix + "encoding", TokenEncoding.class);
            if (this.encoding.equals((Object)TokenEncoding.SELF_CONTAINED)) {
                this.encrypt = pr.getBoolean(prefix + "encrypt");
                String sList = pr.getOptString(prefix + "audienceList", null);
                if (sList != null && !sList.trim().isEmpty()) {
                    String[] sArray = sList.split("\\s+");
                    ArrayList<Audience> list = new ArrayList<Audience>(sArray.length);
                    for (String aud : sArray) {
                        list.add(new Audience(aud));
                    }
                    this.audienceList = Collections.unmodifiableList(list);
                } else {
                    this.audienceList = null;
                }
            } else {
                this.encrypt = false;
                this.audienceList = null;
            }
        }

        public void log() {
            Logger log = LogManager.getLogger((String)"MAIN");
            log.info("[SJH0010] Self-issued JWT bearer grant handler access token lifetime: {} s", new Object[]{this.lifetime});
            log.info("[SJH0011] Self-issued JWT bearer grant handler access token encoding: {}", new Object[]{this.encoding});
            if (this.encoding.equals((Object)TokenEncoding.SELF_CONTAINED)) {
                log.info("[SJH0012] Self-issued JWT bearer grant handler access token encrypt: {}", new Object[]{this.encrypt});
            }
            if (this.audienceList != null) {
                log.info("[SJH0013] Self-issued JWT bearer grant handler access token audience: {}", new Object[]{this.audienceList});
            }
        }
    }
}

