/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import com.amazonaws.services.dynamodbv2.document.utils.NameMap;
import com.amazonaws.services.dynamodbv2.document.utils.ValueMap;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.FILE_PING;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Responses;

public class DYNAMODB_PING
extends FILE_PING {
    protected static final short JGROUPS_PROTOCOL_MAGIC_NUMBER = 1050;
    @Property(description="The DynamoDB region to use.", exposeAsManagedAttribute=false)
    protected String region_name;
    @Property(description="The DynamoDB endpoint to use (optional, overrides region).", exposeAsManagedAttribute=false)
    protected String endpoint;
    @Property(description="The DynamoDB table to use (defaults to 'jgroups_ping').", exposeAsManagedAttribute=false)
    protected String table_name = "jgroups_ping";
    @Property(description="Checks if the DynamoDB table exists and creates a new one if missing.", exposeAsManagedAttribute=false)
    protected boolean check_if_table_exists = true;
    @Property(description="Optional prefix to be applied to the cluster name when stored in the DynamoDB ping table.", exposeAsManagedAttribute=false)
    protected String cluster_name_prefix = "";
    @Property(description="Causes additional debugging information to be stored for each DynamoDB ping item.", exposeAsManagedAttribute=false)
    protected boolean store_debug_info = false;
    protected Table table;

    private static void registerProtocolWithJGroups(short magicNumber) {
        if (ClassConfigurator.getProtocolId(DYNAMODB_PING.class) == 0) {
            ClassConfigurator.addProtocol((short)magicNumber, DYNAMODB_PING.class);
        }
    }

    public void init() throws Exception {
        super.init();
        AmazonDynamoDBClientBuilder builder = (AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
        if (this.endpoint != null) {
            builder = (AmazonDynamoDBClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpoint, null));
            this.log.info("set DynamoDB endpoint to %s", new Object[]{this.endpoint});
        } else {
            builder.withRegion(this.region_name);
        }
        AmazonDynamoDB client = (AmazonDynamoDB)builder.build();
        this.log.info("using DynamoDB in region %s with table %s", new Object[]{this.region_name, this.table_name});
        if (this.check_if_table_exists) {
            this.createTableIfMissing(client);
        }
        this.table = new DynamoDB(client).getTable(this.table_name);
        try {
            this.table.waitForActive();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void createTableIfMissing(AmazonDynamoDB client) {
        try {
            new DynamoDB(client).createTable(this.composeCreateTableRequest());
            this.log.info("created DynamoDB table %s", new Object[]{this.table_name});
        }
        catch (ResourceInUseException e) {
            this.log.info("found DynamoDB table %s", new Object[]{this.table_name});
        }
    }

    protected CreateTableRequest composeCreateTableRequest() {
        LinkedList<KeySchemaElement> keyAttributes = new LinkedList<KeySchemaElement>();
        keyAttributes.add(new KeySchemaElement("own_address", KeyType.HASH));
        keyAttributes.add(new KeySchemaElement("cluster", KeyType.RANGE));
        LinkedList<AttributeDefinition> attributeDefinitions = new LinkedList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition("own_address", ScalarAttributeType.S));
        attributeDefinitions.add(new AttributeDefinition("cluster", ScalarAttributeType.S));
        return new CreateTableRequest().withTableName(this.table_name).withKeySchema(keyAttributes).withAttributeDefinitions(attributeDefinitions).withProvisionedThroughput(new ProvisionedThroughput(Long.valueOf(1L), Long.valueOf(1L)));
    }

    public void stop() {
        super.stop();
        if (this.is_coord) {
            this.removeAll(this.cluster_name);
        }
    }

    protected void createRootDir() {
    }

    protected void readAll(List<Address> members, String clusterName, Responses responses) {
        ItemCollection outcome;
        if (clusterName == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("getting entries for cluster %s ...", new Object[]{clusterName});
        }
        try {
            outcome = this.table.scan(this.composeScanSpec(clusterName));
        }
        catch (Exception e) {
            this.log.error(String.format("failed to get member list for cluster %s", clusterName), (Throwable)e);
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("retrieved %d items for cluster %s", new Object[]{outcome.getAccumulatedItemCount(), clusterName});
        }
        for (Item item : outcome) {
            try {
                PingData pingData = this.toPingData(item);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("processing DynamoDB item [%s -> %s]", new Object[]{item.getString("own_address"), pingData});
                }
                if (pingData == null || members != null && !members.contains(pingData.getAddress())) continue;
                responses.addResponse(pingData, pingData.isCoord());
                if (this.log.isTraceEnabled()) {
                    this.log.trace("added member %s [members: %s]", new Object[]{pingData, members});
                }
                if (this.local_addr == null || this.local_addr.equals(pingData.getAddress())) continue;
                this.addDiscoveryResponseToCaches(pingData.getAddress(), pingData.getLogicalName(), pingData.getPhysicalAddr());
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("added possible member %s [local address: %s]", new Object[]{pingData, this.local_addr});
            }
            catch (Exception e) {
                this.log.error("error processing ping data for cluster %s [item: %s]", new Object[]{clusterName, item});
            }
        }
    }

    protected String composeStoredClusterName(String clusterName) {
        return this.cluster_name_prefix != null ? this.cluster_name_prefix + clusterName : clusterName;
    }

    protected PrimaryKey composePrimaryKey(String ownAddress, String clusterName) {
        return new PrimaryKey("own_address", (Object)ownAddress, "cluster", (Object)this.composeStoredClusterName(clusterName));
    }

    protected ScanSpec composeScanSpec(String clusterName) {
        return new ScanSpec().withFilterExpression("#k_cluster = :v_cluster").withNameMap((Map)new NameMap().with("#k_cluster", "cluster")).withValueMap((Map)new ValueMap().withString(":v_cluster", this.composeStoredClusterName(clusterName)));
    }

    static String formatISODate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    protected Item toItem(PingData data, String clusterName) {
        Item item = new Item().withPrimaryKey(this.composePrimaryKey(DYNAMODB_PING.addressAsString((Address)data.getAddress()), clusterName)).withBinary("ping_data", this.serializeWithoutView(data));
        if (this.store_debug_info) {
            item.withString("logical_name", data.getLogicalName()).withString("physical_address", DYNAMODB_PING.addressAsString((Address)data.getPhysicalAddr())).withBoolean("server", data.isServer()).withBoolean("coordinator", data.isCoord()).withString("timestamp", DYNAMODB_PING.formatISODate(new Date()));
        }
        return item;
    }

    protected PingData toPingData(Item item) throws Exception {
        return DYNAMODB_PING.deserialize((byte[])item.getBinary("ping_data"));
    }

    protected void write(List<PingData> list, String clusterName) {
        for (PingData data : list) {
            this.putIntoTable(data, clusterName);
        }
    }

    protected synchronized void putIntoTable(PingData data, String clusterName) {
        try {
            this.table.putItem(this.toItem(data, clusterName));
        }
        catch (Exception e) {
            this.log.error("put error: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void remove(String clusterName, Address address) {
        try {
            this.table.deleteItem(this.composePrimaryKey(DYNAMODB_PING.addressAsString((Address)address), clusterName));
        }
        catch (Exception e) {
            this.log.error("delete error: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void removeAll(String clusterName) {
        if (clusterName == null) {
            return;
        }
        ItemCollection outcome = this.table.scan(this.composeScanSpec(clusterName));
        for (Item item : outcome) {
            try {
                this.remove(clusterName, this.toPingData(item).getAddress());
            }
            catch (Exception e) {
                this.log.error("delete all error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        DYNAMODB_PING.registerProtocolWithJGroups((short)1050);
    }
}

