/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.dynamodb.config;

import com.amazonaws.regions.Regions;
import com.codahale.metrics.MetricRegistry;
import com.nimbusds.infinispan.persistence.dynamodb.config.DynamoDBStoreConfiguration;
import com.nimbusds.infinispan.persistence.dynamodb.config.DynamoDBStoreConfigurationChildBuilder;
import java.util.Base64;
import java.util.Properties;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;

public class DynamoDBStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<DynamoDBStoreConfiguration, DynamoDBStoreConfigurationBuilder>
implements DynamoDBStoreConfigurationChildBuilder<DynamoDBStoreConfigurationBuilder> {
    public DynamoDBStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, DynamoDBStoreConfiguration.attributeDefinitionSet());
    }

    public DynamoDBStoreConfiguration create() {
        return new DynamoDBStoreConfiguration(this.attributes.protect(), this.async.create());
    }

    public DynamoDBStoreConfigurationBuilder endpoint(String endpoint) {
        this.attributes.attribute(DynamoDBStoreConfiguration.ENDPOINT).set((Object)endpoint);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder region(Regions region) {
        this.attributes.attribute(DynamoDBStoreConfiguration.REGION).set((Object)region);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder itemTransformerClass(Class itemTransformerClass) {
        this.attributes.attribute(DynamoDBStoreConfiguration.ITEM_TRANSFORMER).set((Object)itemTransformerClass);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder queryExecutorClass(Class queryExecutorClass) {
        this.attributes.attribute(DynamoDBStoreConfiguration.QUERY_EXECUTOR).set((Object)queryExecutorClass);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder indexedAttributes(Set<String> indexAttributes) {
        this.attributes.attribute(DynamoDBStoreConfiguration.INDEXED_ATTRIBUTES).set(indexAttributes);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder consistentReads(boolean enable) {
        this.attributes.attribute(DynamoDBStoreConfiguration.CONSISTENT_READS).set((Object)enable);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder readCapacity(long readCapacity) {
        this.attributes.attribute(DynamoDBStoreConfiguration.READ_CAPACITY).set((Object)readCapacity);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder writeCapacity(long writeCapacity) {
        this.attributes.attribute(DynamoDBStoreConfiguration.WRITE_CAPACITY).set((Object)writeCapacity);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder tableWithEncryptionAtRest(boolean encryptionAtRest) {
        this.attributes.attribute(DynamoDBStoreConfiguration.ENCRYPTION_AT_REST).set((Object)encryptionAtRest);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder tablePrefix(String tablePrefix) {
        this.attributes.attribute(DynamoDBStoreConfiguration.TABLE_PREFIX).set((Object)tablePrefix);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder metricRegistry(MetricRegistry metricRegistry) {
        this.attributes.attribute(DynamoDBStoreConfiguration.METRIC_REGISTRY).set((Object)metricRegistry);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder applyRangeKey(String rangeKeyName) {
        this.attributes.attribute(DynamoDBStoreConfiguration.APPLY_RANGE_KEY).set((Object)rangeKeyName);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder rangeKeyValue(String rangeKeyValue) {
        this.attributes.attribute(DynamoDBStoreConfiguration.RANGE_KEY_VALUE).set((Object)rangeKeyValue);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder enableStream(boolean enable) {
        this.attributes.attribute(DynamoDBStoreConfiguration.ENABLE_STREAM).set((Object)enable);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder enableContinuousBackups(boolean enable) {
        this.attributes.attribute(DynamoDBStoreConfiguration.ENABLE_CONTINUOUS_BACKUPS).set((Object)enable);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder enableTTL(boolean enable) {
        this.attributes.attribute(DynamoDBStoreConfiguration.ENABLE_TTL).set((Object)enable);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder purgeLimit(int purgeLimit) {
        this.attributes.attribute(DynamoDBStoreConfiguration.PURGE_LIMIT).set((Object)purgeLimit);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder httpProxyHost(String host) {
        this.attributes.attribute(DynamoDBStoreConfiguration.HTTP_PROXY_HOST).set((Object)host);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder httpProxyPort(int port) {
        this.attributes.attribute(DynamoDBStoreConfiguration.HTTP_PROXY_PORT).set((Object)port);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder hmacSHA256Key(String key) {
        this.attributes.attribute(DynamoDBStoreConfiguration.HMAC_SHA_256_KEY).set((Object)key);
        return this;
    }

    public DynamoDBStoreConfigurationBuilder withProperties(Properties properties) {
        return (DynamoDBStoreConfigurationBuilder)this.properties(properties);
    }

    public void validate() {
        byte[] keyBytes;
        super.validate();
        if (this.attributes.attribute(DynamoDBStoreConfiguration.ITEM_TRANSFORMER).get() == null) {
            throw new CacheConfigurationException("A DynamoDB store item transformer class must be specified");
        }
        if (this.attributes.attribute(DynamoDBStoreConfiguration.QUERY_EXECUTOR) != null && this.attributes.attribute(DynamoDBStoreConfiguration.INDEXED_ATTRIBUTES) == null) {
            throw new CacheConfigurationException("The indexed attributes must be specified if a query executor is set");
        }
        if (this.attributes.attribute(DynamoDBStoreConfiguration.QUERY_EXECUTOR) == null && this.attributes.attribute(DynamoDBStoreConfiguration.INDEXED_ATTRIBUTES) != null) {
            throw new CacheConfigurationException("The query executor must be set if indexed attributes are specified");
        }
        String rangeKeyName = (String)this.attributes.attribute(DynamoDBStoreConfiguration.APPLY_RANGE_KEY).get();
        String rangeKeyValue = (String)this.attributes.attribute(DynamoDBStoreConfiguration.RANGE_KEY_VALUE).get();
        if (rangeKeyName != null && !rangeKeyName.trim().isEmpty() && (rangeKeyValue == null || rangeKeyValue.trim().isEmpty())) {
            throw new CacheConfigurationException("A range key value must be specified");
        }
        if (this.attributes.attribute(DynamoDBStoreConfiguration.HMAC_SHA_256_KEY).get() != null && (keyBytes = Base64.getDecoder().decode((String)this.attributes.attribute(DynamoDBStoreConfiguration.HMAC_SHA_256_KEY).get())).length < 32) {
            throw new CacheConfigurationException("The HMAC SHA-256 key must be at least 256 bits long");
        }
    }

    public DynamoDBStoreConfigurationBuilder self() {
        return this;
    }
}

