/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.dynamodb;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.RangeKeyCondition;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.spec.DeleteItemSpec;
import com.amazonaws.services.dynamodbv2.document.spec.GetItemSpec;
import com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.SSESpecification;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.model.StreamSpecification;
import com.amazonaws.services.dynamodbv2.model.StreamViewType;
import com.nimbusds.infinispan.persistence.common.InfinispanEntry;
import com.nimbusds.infinispan.persistence.dynamodb.DynamoDBItemTransformer;
import com.nimbusds.infinispan.persistence.dynamodb.ItemSanitization;
import com.nimbusds.infinispan.persistence.dynamodb.PrimaryKeyValue;
import java.util.LinkedList;
import java.util.Set;
import org.infinispan.persistence.spi.PersistenceException;

class RequestFactory<K, V> {
    private final String tableName;
    private final DynamoDBItemTransformer<K, V> itemTransformer;
    private final Set<String> indexAttributes;
    private final boolean consistentReads;
    private final ProvisionedThroughput rwCapacity;
    private final boolean tableEncryptionAtRest;
    private final String rangeKeyResolvedName;
    private final String rangeKeyConstValue;
    private final boolean enableStream;

    RequestFactory(DynamoDBItemTransformer<K, V> itemTransformer, Set<String> indexAttributes, boolean consistentReads, ProvisionedThroughput rwCapacity, boolean encryptionAtRest, String tablePrefix, String rangeKeyName, String rangeKeyConstValue, boolean enableStream) {
        assert (itemTransformer != null);
        this.itemTransformer = itemTransformer;
        this.indexAttributes = indexAttributes;
        this.consistentReads = consistentReads;
        assert (tablePrefix != null);
        this.tableName = tablePrefix + itemTransformer.getTableName();
        assert (rwCapacity != null);
        this.rwCapacity = rwCapacity;
        this.tableEncryptionAtRest = encryptionAtRest;
        if (itemTransformer.getRangeKeyAttributeName() != null) {
            this.rangeKeyResolvedName = itemTransformer.getRangeKeyAttributeName();
            this.rangeKeyConstValue = null;
        } else if (rangeKeyName != null && !rangeKeyName.trim().isEmpty()) {
            this.rangeKeyResolvedName = rangeKeyName;
            this.rangeKeyConstValue = rangeKeyConstValue;
        } else {
            this.rangeKeyResolvedName = null;
            this.rangeKeyConstValue = null;
        }
        this.enableStream = enableStream;
    }

    DynamoDBItemTransformer<K, V> getItemTransformer() {
        return this.itemTransformer;
    }

    String getTableName() {
        return this.tableName;
    }

    public String getRangeKeyResolvedName() {
        return this.rangeKeyResolvedName;
    }

    String getRangeKeyGSIName() {
        return this.rangeKeyResolvedName != null ? this.tableName + "-" + this.rangeKeyResolvedName + "-gsi" : null;
    }

    String getGSIName(String attr) {
        return this.tableName + "-" + attr + "-gsi";
    }

    CreateTableRequest resolveCreateTableRequest() {
        LinkedList<KeySchemaElement> keyAttrs = new LinkedList<KeySchemaElement>();
        keyAttrs.add(new KeySchemaElement(this.itemTransformer.getHashKeyAttributeName(), KeyType.HASH));
        LinkedList<AttributeDefinition> attrs = new LinkedList<AttributeDefinition>();
        attrs.add(new AttributeDefinition(this.itemTransformer.getHashKeyAttributeName(), ScalarAttributeType.S));
        LinkedList<GlobalSecondaryIndex> gsIndices = new LinkedList<GlobalSecondaryIndex>();
        if (this.rangeKeyResolvedName != null) {
            keyAttrs.add(new KeySchemaElement(this.rangeKeyResolvedName, KeyType.RANGE));
            attrs.add(new AttributeDefinition(this.rangeKeyResolvedName, ScalarAttributeType.S));
            gsIndices.add(new GlobalSecondaryIndex().withIndexName(this.getRangeKeyGSIName()).withKeySchema(new KeySchemaElement[]{new KeySchemaElement(this.rangeKeyResolvedName, KeyType.HASH)}).withProjection(new Projection().withProjectionType(ProjectionType.ALL)).withProvisionedThroughput(this.rwCapacity));
        }
        if (this.indexAttributes != null) {
            for (String a : this.indexAttributes) {
                attrs.add(new AttributeDefinition(a, ScalarAttributeType.S));
                gsIndices.add(new GlobalSecondaryIndex().withIndexName(this.getGSIName(a)).withKeySchema(new KeySchemaElement[]{new KeySchemaElement(a, KeyType.HASH)}).withProjection(new Projection().withProjectionType(ProjectionType.ALL)).withProvisionedThroughput(this.rwCapacity));
            }
        }
        CreateTableRequest createTableRequest = new CreateTableRequest().withTableName(this.tableName).withProvisionedThroughput(this.rwCapacity).withSSESpecification(new SSESpecification().withEnabled(Boolean.valueOf(this.tableEncryptionAtRest))).withKeySchema(keyAttrs).withAttributeDefinitions(attrs);
        if (this.enableStream) {
            createTableRequest = createTableRequest.withStreamSpecification(new StreamSpecification().withStreamEnabled(Boolean.valueOf(true)).withStreamViewType(StreamViewType.NEW_AND_OLD_IMAGES));
        }
        if (!gsIndices.isEmpty()) {
            createTableRequest.withGlobalSecondaryIndexes(gsIndices);
        }
        return createTableRequest;
    }

    private PrimaryKey resolvePrimaryKey(Object key) {
        if (key instanceof byte[]) {
            throw new PersistenceException("Cannot resolve " + this.itemTransformer.getTableName() + " key from byte[], enable compatibility mode");
        }
        PrimaryKeyValue pkValue = this.itemTransformer.resolvePrimaryKey(key);
        if (this.rangeKeyResolvedName != null) {
            if (this.itemTransformer.getRangeKeyAttributeName() != null) {
                return new PrimaryKey(this.itemTransformer.getHashKeyAttributeName(), (Object)pkValue.getHashKeyValue(), this.rangeKeyResolvedName, (Object)pkValue.getRangeKeyValue());
            }
            return new PrimaryKey(this.itemTransformer.getHashKeyAttributeName(), (Object)pkValue.getHashKeyValue(), this.rangeKeyResolvedName, (Object)this.rangeKeyConstValue);
        }
        return new PrimaryKey(this.itemTransformer.getHashKeyAttributeName(), (Object)pkValue.getHashKeyValue());
    }

    GetItemSpec resolveGetItemSpec(Object key) {
        return new GetItemSpec().withPrimaryKey(this.resolvePrimaryKey(key)).withConsistentRead(this.consistentReads);
    }

    Item resolveItem(InfinispanEntry<K, V> infinispanEntry) {
        Item item = this.itemTransformer.toItem(infinispanEntry);
        item = ItemSanitization.sanitize(item);
        item = this.applyOptionalRangeKeyConstValue(item);
        return item;
    }

    DeleteItemSpec resolveDeleteItemSpec(Object key) {
        return new DeleteItemSpec().withPrimaryKey(this.resolvePrimaryKey(key)).withReturnValues(ReturnValue.ALL_OLD);
    }

    ItemCollection<?> getAllItems(Table table) {
        if (this.rangeKeyConstValue != null) {
            RangeKeyCondition c = new RangeKeyCondition(this.rangeKeyResolvedName).eq((Object)this.rangeKeyConstValue);
            return table.getIndex(this.getRangeKeyGSIName()).query(new QuerySpec().withRangeKeyCondition(c));
        }
        return table.scan(new ScanSpec());
    }

    Item applyOptionalRangeKeyConstValue(Item item) {
        if (this.rangeKeyConstValue == null) {
            return item;
        }
        Object hashKeyValue = item.get(this.itemTransformer.getHashKeyAttributeName());
        if (hashKeyValue == null) {
            throw new PersistenceException("Missing hash key in transformed DynamoDB item: " + this.itemTransformer.getHashKeyAttributeName());
        }
        return item.withPrimaryKey(this.itemTransformer.getHashKeyAttributeName(), hashKeyValue, this.rangeKeyResolvedName, (Object)this.rangeKeyConstValue);
    }
}

