/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.infinispan.persistence.dynamodb;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.nimbusds.common.store.StoreException;
import com.nimbusds.infinispan.persistence.dynamodb.InvalidHMACException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.jcip.annotations.Immutable;
import org.erdtman.jcs.JsonCanonicalizer;

@Immutable
final class ItemHMAC {
    public static final String ATTRIBUTE_NAME = "_hmac#s256";
    private final SecretKey hmacKey;

    public ItemHMAC(String hmacKeyBase64Encoded) throws InvalidKeyException {
        this(hmacKeyBase64Encoded != null ? Base64.getDecoder().decode(hmacKeyBase64Encoded) : null);
    }

    public ItemHMAC(byte[] hmacKeyBytes) throws InvalidKeyException {
        this(hmacKeyBytes != null ? new SecretKeySpec(hmacKeyBytes, "HmacSHA256") : null);
    }

    public ItemHMAC(SecretKey hmacKey) throws InvalidKeyException {
        this.hmacKey = hmacKey;
        if (hmacKey == null) {
            return;
        }
        if (hmacKey.getEncoded().length < 32) {
            throw new InvalidKeyException("The HMAC SHA-256 key must be at least 256 bits long");
        }
    }

    public byte[] compute(Item item) throws NoSuchAlgorithmException, InvalidKeyException {
        JsonCanonicalizer jc;
        if (this.hmacKey == null) {
            return null;
        }
        try {
            jc = new JsonCanonicalizer(item.toJSON());
        }
        catch (IOException e) {
            throw new StoreException(e.getMessage(), (Throwable)e);
        }
        byte[] hmacInput = jc.getEncodedString().getBytes(StandardCharsets.UTF_8);
        Mac hmacSHA256 = Mac.getInstance("HmacSHA256");
        hmacSHA256.init(this.hmacKey);
        return hmacSHA256.doFinal(hmacInput);
    }

    public Item apply(Item item) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] hmac = this.compute(item);
        if (hmac == null) {
            return item;
        }
        return item.withBinary(ATTRIBUTE_NAME, hmac);
    }

    public Item verify(Item item) throws InvalidHMACException, InvalidKeyException, NoSuchAlgorithmException {
        Item baseItem;
        byte[] computedHMAC;
        if (this.hmacKey == null) {
            return item;
        }
        if (!item.hasAttribute(ATTRIBUTE_NAME)) {
            throw new InvalidHMACException("Missing item HMAC attribute: _hmac#s256");
        }
        byte[] storedHMAC = item.getBinary(ATTRIBUTE_NAME);
        if (!MessageDigest.isEqual(storedHMAC, computedHMAC = this.compute(baseItem = item.removeAttribute(ATTRIBUTE_NAME)))) {
            throw new InvalidHMACException("Invalid item HMAC: Stored: " + Base64.getEncoder().encodeToString(storedHMAC) + " Computed: " + Base64.getEncoder().encodeToString(computedHMAC) + " Item: " + item.toJSON());
        }
        return baseItem;
    }
}

