/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Handler;
import java.util.zip.ZipFile;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.ChannelSource;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.Result;
import org.xnio._private.Messages;
import org.xnio.channels.SuspendableReadChannel;

public final class IoUtils {
    private static final Executor NULL_EXECUTOR = new Executor(){
        private final String string = String.format("null executor <%s>", Integer.toHexString(this.hashCode()));

        @Override
        public void execute(Runnable command) {
        }

        public String toString() {
            return this.string;
        }
    };
    private static final Executor DIRECT_EXECUTOR = new Executor(){
        private final String string = String.format("direct executor <%s>", Integer.toHexString(this.hashCode()));

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        public String toString() {
            return this.string;
        }
    };
    private static final Closeable NULL_CLOSEABLE = new Closeable(){
        private final String string = String.format("null closeable <%s>", Integer.toHexString(this.hashCode()));

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return this.string;
        }
    };
    private static final Cancellable NULL_CANCELLABLE = new Cancellable(){

        @Override
        public Cancellable cancel() {
            return this;
        }
    };
    private static final ResultNotifier RESULT_NOTIFIER = new ResultNotifier();
    private static final IoFuture.Notifier<Object, Closeable> ATTACHMENT_CLOSING_NOTIFIER = new IoFuture.Notifier<Object, Closeable>(){

        @Override
        public void notify(IoFuture<?> future, Closeable attachment) {
            IoUtils.safeClose(attachment);
        }
    };
    private static final IoFuture.Notifier<Closeable, Void> CLOSING_NOTIFIER = new IoFuture.HandlingNotifier<Closeable, Void>(){

        @Override
        public void handleDone(Closeable result, Void attachment) {
            IoUtils.safeClose(result);
        }
    };
    private static final IoFuture.Notifier CHANNEL_LISTENER_NOTIFIER = new IoFuture.HandlingNotifier<Channel, ChannelListener<? super Channel>>(){

        @Override
        public void handleDone(Channel channel, ChannelListener channelListener) {
            channelListener.handleEvent(channel);
        }
    };
    private static final IoFuture.Notifier<Object, CountDownLatch> COUNT_DOWN_NOTIFIER = new IoFuture.Notifier<Object, CountDownLatch>(){

        @Override
        public void notify(IoFuture<?> future, CountDownLatch latch) {
            latch.countDown();
        }
    };
    private static final ManagerNotifier MANAGER_NOTIFIER = new ManagerNotifier();

    private IoUtils() {
    }

    public static Executor directExecutor() {
        return DIRECT_EXECUTOR;
    }

    public static Executor nullExecutor() {
        return NULL_EXECUTOR;
    }

    public static Closeable nullCloseable() {
        return NULL_CLOSEABLE;
    }

    public static void safeClose(AutoCloseable resource) {
        try {
            if (resource != null) {
                Messages.closeMsg.closingResource(resource);
                resource.close();
            }
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (Throwable t) {
            Messages.closeMsg.resourceCloseFailed(t, resource);
        }
    }

    public static void safeClose(Closeable resource) {
        try {
            if (resource != null) {
                Messages.closeMsg.closingResource(resource);
                resource.close();
            }
        }
        catch (ClosedChannelException ignored) {
            Messages.msg.tracef("safeClose, ignoring ClosedChannelException exception", new Object[0]);
        }
        catch (Throwable t) {
            Messages.closeMsg.resourceCloseFailed(t, resource);
        }
    }

    public static void safeClose(Closeable ... resources) {
        for (Closeable resource : resources) {
            IoUtils.safeClose(resource);
        }
    }

    public static void safeClose(Socket resource) {
        try {
            if (resource != null) {
                Messages.closeMsg.closingResource(resource);
                resource.close();
            }
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (Throwable t) {
            Messages.closeMsg.resourceCloseFailed(t, resource);
        }
    }

    public static void safeClose(DatagramSocket resource) {
        try {
            if (resource != null) {
                Messages.closeMsg.closingResource(resource);
                resource.close();
            }
        }
        catch (Throwable t) {
            Messages.closeMsg.resourceCloseFailed(t, resource);
        }
    }

    public static void safeClose(Selector resource) {
        try {
            if (resource != null) {
                Messages.closeMsg.closingResource(resource);
                resource.close();
            }
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (Throwable t) {
            Messages.closeMsg.resourceCloseFailed(t, resource);
        }
    }

    public static void safeClose(ServerSocket resource) {
        try {
            if (resource != null) {
                Messages.closeMsg.closingResource(resource);
                resource.close();
            }
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (Throwable t) {
            Messages.closeMsg.resourceCloseFailed(t, resource);
        }
    }

    public static void safeClose(ZipFile resource) {
        try {
            if (resource != null) {
                Messages.closeMsg.closingResource(resource);
                resource.close();
            }
        }
        catch (Throwable t) {
            Messages.closeMsg.resourceCloseFailed(t, resource);
        }
    }

    public static void safeClose(Handler resource) {
        try {
            if (resource != null) {
                Messages.closeMsg.closingResource(resource);
                resource.close();
            }
        }
        catch (Throwable t) {
            Messages.closeMsg.resourceCloseFailed(t, resource);
        }
    }

    public static void safeClose(IoFuture<? extends Closeable> futureResource) {
        if (futureResource != null) {
            futureResource.cancel().addNotifier(IoUtils.closingNotifier(), null);
        }
    }

    public static IoFuture.Notifier<Object, Closeable> attachmentClosingNotifier() {
        return ATTACHMENT_CLOSING_NOTIFIER;
    }

    public static IoFuture.Notifier<Closeable, Void> closingNotifier() {
        return CLOSING_NOTIFIER;
    }

    public static <T> IoFuture.Notifier<T, Void> runnableNotifier(final Runnable runnable2) {
        return new IoFuture.Notifier<T, Void>(){

            @Override
            public void notify(IoFuture<? extends T> future, Void attachment) {
                runnable2.run();
            }
        };
    }

    public static <T> IoFuture.Notifier<T, Result<T>> resultNotifier() {
        return RESULT_NOTIFIER;
    }

    public static <T extends Channel> IoFuture.Notifier<T, ChannelListener<? super T>> channelListenerNotifier() {
        return CHANNEL_LISTENER_NOTIFIER;
    }

    public static <T> Future<T> getFuture(final IoFuture<T> ioFuture) {
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                ioFuture.cancel();
                return ioFuture.await() == IoFuture.Status.CANCELLED;
            }

            @Override
            public boolean isCancelled() {
                return ioFuture.getStatus() == IoFuture.Status.CANCELLED;
            }

            @Override
            public boolean isDone() {
                return ioFuture.getStatus() == IoFuture.Status.DONE;
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                try {
                    return ioFuture.getInterruptibly();
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }

            @Override
            public T get(long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                try {
                    if (ioFuture.awaitInterruptibly(timeout2, unit) == IoFuture.Status.WAITING) {
                        throw Messages.msg.opTimedOut();
                    }
                    return ioFuture.getInterruptibly();
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }

            public String toString() {
                return String.format("java.util.concurrent.Future wrapper <%s> for %s", Integer.toHexString(this.hashCode()), ioFuture);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void awaitAll(IoFuture<?> ... futures) {
        int len = futures.length;
        CountDownLatch cdl = new CountDownLatch(len);
        for (IoFuture<?> future : futures) {
            future.addNotifier(COUNT_DOWN_NOTIFIER, cdl);
        }
        boolean intr = false;
        try {
            while (cdl.getCount() > 0L) {
                try {
                    cdl.await();
                }
                catch (InterruptedException e) {
                    intr = true;
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void awaitAllInterruptibly(IoFuture<?> ... futures) throws InterruptedException {
        int len = futures.length;
        CountDownLatch cdl = new CountDownLatch(len);
        for (IoFuture<?> future : futures) {
            future.addNotifier(COUNT_DOWN_NOTIFIER, cdl);
        }
        cdl.await();
    }

    public static <I, O> IoFuture<? extends O> cast(IoFuture<I> parent, Class<O> type) {
        return new CastingIoFuture(parent, type);
    }

    public static void safeShutdownReads(SuspendableReadChannel channel) {
        if (channel != null) {
            try {
                channel.shutdownReads();
            }
            catch (IOException e) {
                Messages.closeMsg.resourceReadShutdownFailed(null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(ReadableByteChannel source2, long count, ByteBuffer throughBuffer, WritableByteChannel sink2) throws IOException {
        long total;
        long res;
        throughBuffer.limit(0);
        for (total = 0L; total < count; total += res) {
            throughBuffer.compact();
            try {
                if (count - total < (long)throughBuffer.remaining()) {
                    throughBuffer.limit((int)(count - total));
                }
                if ((res = (long)source2.read(throughBuffer)) <= 0L) {
                    long l = total == 0L ? res : total;
                    return l;
                }
            }
            finally {
                throughBuffer.flip();
            }
            res = sink2.write(throughBuffer);
            if (res != 0L) continue;
            return total;
        }
        return total;
    }

    public static <T> IoFuture.Notifier<T, FutureResult<T>> getManagerNotifier() {
        return MANAGER_NOTIFIER;
    }

    public static <T extends Channel> ChannelSource<T> getRetryingChannelSource(ChannelSource<T> delegate, int maxTries) throws IllegalArgumentException {
        if (maxTries < 1) {
            throw Messages.msg.minRange("maxTries", 1);
        }
        return new RetryingChannelSource<T>(maxTries, delegate);
    }

    public static Cancellable closingCancellable(Closeable c) {
        return new ClosingCancellable(c);
    }

    public static Cancellable nullCancellable() {
        return NULL_CANCELLABLE;
    }

    public static Random getThreadLocalRandom() {
        return ThreadLocalRandom.current();
    }

    private static class ResultNotifier<T>
    extends IoFuture.HandlingNotifier<T, Result<T>> {
        private ResultNotifier() {
        }

        @Override
        public void handleCancelled(Result<T> result) {
            result.setCancelled();
        }

        @Override
        public void handleFailed(IOException exception, Result<T> result) {
            result.setException(exception);
        }

        @Override
        public void handleDone(T value, Result<T> result) {
            result.setResult(value);
        }
    }

    private static class ClosingCancellable
    implements Cancellable {
        private final Closeable c;

        ClosingCancellable(Closeable c) {
            this.c = c;
        }

        @Override
        public Cancellable cancel() {
            IoUtils.safeClose(this.c);
            return this;
        }
    }

    private static class RetryingChannelSource<T extends Channel>
    implements ChannelSource<T> {
        private final int maxTries;
        private final ChannelSource<T> delegate;

        RetryingChannelSource(int maxTries, ChannelSource<T> delegate) {
            this.maxTries = maxTries;
            this.delegate = delegate;
        }

        @Override
        public IoFuture<T> open(ChannelListener<? super T> openListener) {
            FutureResult result = new FutureResult();
            RetryingNotifier notifier = new RetryingNotifier(this.maxTries, result, this.delegate, openListener);
            notifier.tryOne(result);
            return result.getIoFuture();
        }
    }

    private static class RetryingNotifier<T extends Channel>
    extends IoFuture.HandlingNotifier<T, Result<T>> {
        private volatile int remaining;
        private final int maxTries;
        private final Result<T> result;
        private final ChannelSource<T> delegate;
        private final ChannelListener<? super T> openListener;

        RetryingNotifier(int maxTries, Result<T> result, ChannelSource<T> delegate, ChannelListener<? super T> openListener) {
            this.maxTries = maxTries;
            this.result = result;
            this.delegate = delegate;
            this.openListener = openListener;
            this.remaining = maxTries;
        }

        @Override
        public void handleFailed(IOException exception, Result<T> attachment) {
            if (this.remaining-- == 0) {
                this.result.setException(new IOException("Failed to create channel after " + this.maxTries + " tries", exception));
                return;
            }
            this.tryOne(attachment);
        }

        @Override
        public void handleCancelled(Result<T> attachment) {
            this.result.setCancelled();
        }

        @Override
        public void handleDone(T data, Result<T> attachment) {
            this.result.setResult(data);
        }

        void tryOne(Result<T> attachment) {
            IoFuture<T> ioFuture = this.delegate.open(this.openListener);
            ioFuture.addNotifier(this, attachment);
        }
    }

    private static class ManagerNotifier<T extends Channel>
    extends IoFuture.HandlingNotifier<T, FutureResult<T>> {
        private ManagerNotifier() {
        }

        @Override
        public void handleCancelled(FutureResult<T> manager) {
            manager.setCancelled();
        }

        @Override
        public void handleFailed(IOException exception, FutureResult<T> manager) {
            manager.setException(exception);
        }

        @Override
        public void handleDone(T result, FutureResult<T> manager) {
            manager.setResult(result);
        }
    }

    private static class CastingIoFuture<O, I>
    implements IoFuture<O> {
        private final IoFuture<I> parent;
        private final Class<O> type;

        private CastingIoFuture(IoFuture<I> parent, Class<O> type) {
            this.parent = parent;
            this.type = type;
        }

        @Override
        public IoFuture<O> cancel() {
            this.parent.cancel();
            return this;
        }

        @Override
        public IoFuture.Status getStatus() {
            return this.parent.getStatus();
        }

        @Override
        public IoFuture.Status await() {
            return this.parent.await();
        }

        @Override
        public IoFuture.Status await(long time, TimeUnit timeUnit) {
            return this.parent.await(time, timeUnit);
        }

        @Override
        public IoFuture.Status awaitInterruptibly() throws InterruptedException {
            return this.parent.awaitInterruptibly();
        }

        @Override
        public IoFuture.Status awaitInterruptibly(long time, TimeUnit timeUnit) throws InterruptedException {
            return this.parent.awaitInterruptibly(time, timeUnit);
        }

        @Override
        public O get() throws IOException, CancellationException {
            return this.type.cast(this.parent.get());
        }

        @Override
        public O getInterruptibly() throws IOException, InterruptedException, CancellationException {
            return this.type.cast(this.parent.getInterruptibly());
        }

        @Override
        public IOException getException() throws IllegalStateException {
            return this.parent.getException();
        }

        @Override
        public <A> IoFuture<O> addNotifier(final IoFuture.Notifier<? super O, A> notifier, A attachment) {
            this.parent.addNotifier(new IoFuture.Notifier<I, A>(){

                @Override
                public void notify(IoFuture<? extends I> future, A attachment) {
                    notifier.notify(this, attachment);
                }
            }, attachment);
            return this;
        }
    }
}

