/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.wildfly.common.ref.CleanerReference;
import org.wildfly.common.ref.Reaper;
import org.wildfly.common.ref.Reference;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferPool;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio._private.Messages;

public final class Buffers {
    private static final byte[] NO_BYTES = new byte[0];
    public static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    public static final Pooled<ByteBuffer> EMPTY_POOLED_BYTE_BUFFER = Buffers.emptyPooledByteBuffer();

    private Buffers() {
    }

    public static <T extends Buffer> T flip(T buffer) {
        buffer.flip();
        return buffer;
    }

    public static <T extends Buffer> T clear(T buffer) {
        buffer.clear();
        return buffer;
    }

    public static <T extends Buffer> T limit(T buffer, int limit) {
        buffer.limit(limit);
        return buffer;
    }

    public static <T extends Buffer> T mark(T buffer) {
        buffer.mark();
        return buffer;
    }

    public static <T extends Buffer> T position(T buffer, int position) {
        buffer.position(position);
        return buffer;
    }

    public static <T extends Buffer> T reset(T buffer) {
        buffer.reset();
        return buffer;
    }

    public static <T extends Buffer> T rewind(T buffer) {
        buffer.rewind();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer slice(ByteBuffer buffer, int sliceSize) {
        int oldRem = buffer.remaining();
        if (sliceSize > oldRem || sliceSize < -oldRem) {
            throw Messages.msg.bufferUnderflow();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                ByteBuffer byteBuffer = buffer.slice();
                return byteBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            ByteBuffer byteBuffer = buffer.slice();
            return byteBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer copy(ByteBuffer buffer, int count, BufferAllocator<ByteBuffer> allocator) {
        int oldRem = buffer.remaining();
        if (count > oldRem || count < -oldRem) {
            throw Messages.msg.bufferUnderflow();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (count < 0) {
            ByteBuffer target = allocator.allocate(-count);
            buffer.position(oldLim + count);
            try {
                target.put(buffer);
                ByteBuffer byteBuffer = target;
                return byteBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + count);
            }
        }
        ByteBuffer target = allocator.allocate(count);
        buffer.limit(oldPos + count);
        try {
            target.put(buffer);
            ByteBuffer byteBuffer = target;
            return byteBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + count);
        }
    }

    public static int copy(ByteBuffer destination, ByteBuffer source2) {
        int sr = source2.remaining();
        int dr = destination.remaining();
        if (dr >= sr) {
            destination.put(source2);
            return sr;
        }
        destination.put(Buffers.slice(source2, dr));
        return dr;
    }

    public static int copy(ByteBuffer[] destinations, int offset, int length, ByteBuffer source2) {
        int t = 0;
        for (int i = 0; i < length; ++i) {
            ByteBuffer buffer = destinations[i + offset];
            int rem = buffer.remaining();
            if (rem == 0) continue;
            if (rem < source2.remaining()) {
                buffer.put(Buffers.slice(source2, rem));
                t += rem;
                continue;
            }
            buffer.put(source2);
            return t += source2.remaining();
        }
        return t;
    }

    public static int copy(ByteBuffer destination, ByteBuffer[] sources, int offset, int length) {
        int t = 0;
        for (int i = 0; i < length; ++i) {
            ByteBuffer buffer = sources[i + offset];
            int rem = buffer.remaining();
            if (rem == 0) continue;
            if (rem > destination.remaining()) {
                destination.put(Buffers.slice(buffer, destination.remaining()));
                return t += destination.remaining();
            }
            destination.put(buffer);
            t += rem;
        }
        return t;
    }

    public static long copy(ByteBuffer[] destinations, int destOffset, int destLength, ByteBuffer[] sources, int srcOffset, int srcLength) {
        long t = 0L;
        int s2 = 0;
        int d = 0;
        if (destLength == 0 || srcLength == 0) {
            return 0L;
        }
        ByteBuffer source2 = sources[srcOffset];
        ByteBuffer dest = destinations[destOffset];
        while (s2 < srcLength && d < destLength) {
            int dr;
            source2 = sources[srcOffset + s2];
            dest = destinations[destOffset + d];
            int sr = source2.remaining();
            if (sr < (dr = dest.remaining())) {
                dest.put(source2);
                ++s2;
                t += (long)sr;
                continue;
            }
            if (sr > dr) {
                dest.put(Buffers.slice(source2, dr));
                ++d;
                t += (long)dr;
                continue;
            }
            dest.put(source2);
            ++s2;
            ++d;
            t += (long)sr;
        }
        return t;
    }

    public static int copy(int count, ByteBuffer destination, ByteBuffer source2) {
        int cnt = count >= 0 ? Math.min(Math.min(count, source2.remaining()), destination.remaining()) : Math.max(Math.max(count, -source2.remaining()), -destination.remaining());
        ByteBuffer copy = Buffers.slice(source2, cnt);
        destination.put(copy);
        return copy.position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(int count, ByteBuffer[] destinations, int offset, int length, ByteBuffer source2) {
        if (source2.remaining() > count) {
            int oldLimit = source2.limit();
            if (count < 0) {
                throw Messages.msg.copyNegative();
            }
            try {
                source2.limit(source2.position() + count);
                int n = Buffers.copy(destinations, offset, length, source2);
                return n;
            }
            finally {
                source2.limit(oldLimit);
            }
        }
        return Buffers.copy(destinations, offset, length, source2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(int count, ByteBuffer destination, ByteBuffer[] sources, int offset, int length) {
        if (destination.remaining() > count) {
            if (count < 0) {
                throw Messages.msg.copyNegative();
            }
            int oldLimit = destination.limit();
            try {
                destination.limit(destination.position() + Math.min(count, destination.remaining()));
                int n = Buffers.copy(destination, sources, offset, length);
                return n;
            }
            finally {
                destination.limit(oldLimit);
            }
        }
        return Buffers.copy(destination, sources, offset, length);
    }

    public static long copy(long count, ByteBuffer[] destinations, int destOffset, int destLength, ByteBuffer[] sources, int srcOffset, int srcLength) {
        long t = 0L;
        int s2 = 0;
        int d = 0;
        if (count < 0L) {
            throw Messages.msg.copyNegative();
        }
        if (destLength == 0 || srcLength == 0 || count == 0L) {
            return 0L;
        }
        while (s2 < srcLength && d < destLength) {
            int dr;
            ByteBuffer source2 = sources[srcOffset + s2];
            ByteBuffer dest = destinations[destOffset + d];
            int sr = source2.remaining();
            if (sr < (dr = (int)Math.min(count, (long)dest.remaining()))) {
                dest.put(source2);
                ++s2;
                t += (long)sr;
                count -= (long)sr;
                continue;
            }
            if (sr > dr) {
                dest.put(Buffers.slice(source2, dr));
                ++d;
                t += (long)dr;
                count -= (long)dr;
                continue;
            }
            dest.put(source2);
            ++s2;
            ++d;
            t += (long)sr;
            count -= (long)sr;
        }
        return t;
    }

    public static ByteBuffer fill(ByteBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw Messages.msg.bufferUnderflow();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), (byte)value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put((byte)value);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharBuffer slice(CharBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw Messages.msg.bufferUnderflow();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                CharBuffer charBuffer = buffer.slice();
                return charBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            CharBuffer charBuffer = buffer.slice();
            return charBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static CharBuffer fill(CharBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw Messages.msg.bufferUnderflow();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), (char)value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put((char)value);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShortBuffer slice(ShortBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw Messages.msg.bufferUnderflow();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                ShortBuffer shortBuffer = buffer.slice();
                return shortBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            ShortBuffer shortBuffer = buffer.slice();
            return shortBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static ShortBuffer fill(ShortBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw Messages.msg.bufferUnderflow();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), (short)value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put((short)value);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntBuffer slice(IntBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw Messages.msg.bufferUnderflow();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                IntBuffer intBuffer = buffer.slice();
                return intBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            IntBuffer intBuffer = buffer.slice();
            return intBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static IntBuffer fill(IntBuffer buffer, int value, int count) {
        if (count > buffer.remaining()) {
            throw Messages.msg.bufferUnderflow();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put(value);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LongBuffer slice(LongBuffer buffer, int sliceSize) {
        if (sliceSize > buffer.remaining() || sliceSize < -buffer.remaining()) {
            throw Messages.msg.bufferUnderflow();
        }
        int oldPos = buffer.position();
        int oldLim = buffer.limit();
        if (sliceSize < 0) {
            buffer.limit(oldLim + sliceSize);
            try {
                LongBuffer longBuffer = buffer.slice();
                return longBuffer;
            }
            finally {
                buffer.limit(oldLim);
                buffer.position(oldLim + sliceSize);
            }
        }
        buffer.limit(oldPos + sliceSize);
        try {
            LongBuffer longBuffer = buffer.slice();
            return longBuffer;
        }
        finally {
            buffer.limit(oldLim);
            buffer.position(oldPos + sliceSize);
        }
    }

    public static LongBuffer fill(LongBuffer buffer, long value, int count) {
        if (count > buffer.remaining()) {
            throw Messages.msg.bufferUnderflow();
        }
        if (buffer.hasArray()) {
            int offs = buffer.arrayOffset();
            Arrays.fill(buffer.array(), offs + buffer.position(), offs + buffer.limit(), value);
            Buffers.skip(buffer, count);
        } else {
            for (int i = count; i > 0; --i) {
                buffer.put(value);
            }
        }
        return buffer;
    }

    public static <T extends Buffer> T skip(T buffer, int cnt) throws BufferUnderflowException {
        if (cnt < 0) {
            throw Messages.msg.parameterOutOfRange("cnt");
        }
        if (cnt > buffer.remaining()) {
            throw Messages.msg.bufferUnderflow();
        }
        buffer.position(buffer.position() + cnt);
        return buffer;
    }

    public static int trySkip(Buffer buffer, int cnt) {
        if (cnt < 0) {
            throw Messages.msg.parameterOutOfRange("cnt");
        }
        int rem = buffer.remaining();
        if (cnt > rem) {
            cnt = rem;
        }
        buffer.position(buffer.position() + cnt);
        return cnt;
    }

    public static long trySkip(Buffer[] buffers, int offs, int len, long cnt) {
        if (cnt < 0L) {
            throw Messages.msg.parameterOutOfRange("cnt");
        }
        if (len < 0) {
            throw Messages.msg.parameterOutOfRange("len");
        }
        if (offs < 0) {
            throw Messages.msg.parameterOutOfRange("offs");
        }
        if (offs > buffers.length) {
            throw Messages.msg.parameterOutOfRange("offs");
        }
        if (offs + len > buffers.length) {
            throw Messages.msg.parameterOutOfRange("offs");
        }
        long c = 0L;
        for (int i = 0; i < len; ++i) {
            Buffer buffer = buffers[offs + i];
            int rem = buffer.remaining();
            if ((long)rem < cnt) {
                buffer.position(buffer.position() + rem);
                cnt -= (long)rem;
                c += (long)rem;
                continue;
            }
            buffer.position(buffer.position() + (int)cnt);
            return c + cnt;
        }
        return c;
    }

    public static <T extends Buffer> T unget(T buffer, int cnt) {
        if (cnt < 0) {
            throw Messages.msg.parameterOutOfRange("cnt");
        }
        if (cnt > buffer.position()) {
            throw Messages.msg.bufferUnderflow();
        }
        buffer.position(buffer.position() - cnt);
        return buffer;
    }

    public static byte[] take(ByteBuffer buffer, int cnt) {
        if (cnt < 0) {
            throw Messages.msg.parameterOutOfRange("cnt");
        }
        if (buffer.hasArray()) {
            int pos = buffer.position();
            int lim = buffer.limit();
            if (lim - pos < cnt) {
                throw new BufferUnderflowException();
            }
            byte[] array = buffer.array();
            int offset = buffer.arrayOffset();
            buffer.position(pos + cnt);
            int start = offset + pos;
            return Arrays.copyOfRange(array, start, start + cnt);
        }
        byte[] bytes = new byte[cnt];
        buffer.get(bytes);
        return bytes;
    }

    public static char[] take(CharBuffer buffer, int cnt) {
        if (cnt < 0) {
            throw Messages.msg.parameterOutOfRange("cnt");
        }
        if (buffer.hasArray()) {
            int pos = buffer.position();
            int lim = buffer.limit();
            if (lim - pos < cnt) {
                throw new BufferUnderflowException();
            }
            char[] array = buffer.array();
            int offset = buffer.arrayOffset();
            buffer.position(pos + cnt);
            int start = offset + pos;
            return Arrays.copyOfRange(array, start, start + cnt);
        }
        char[] chars = new char[cnt];
        buffer.get(chars);
        return chars;
    }

    public static short[] take(ShortBuffer buffer, int cnt) {
        if (cnt < 0) {
            throw Messages.msg.parameterOutOfRange("cnt");
        }
        if (buffer.hasArray()) {
            int pos = buffer.position();
            int lim = buffer.limit();
            if (lim - pos < cnt) {
                throw new BufferUnderflowException();
            }
            short[] array = buffer.array();
            int offset = buffer.arrayOffset();
            buffer.position(pos + cnt);
            int start = offset + pos;
            return Arrays.copyOfRange(array, start, start + cnt);
        }
        short[] shorts = new short[cnt];
        buffer.get(shorts);
        return shorts;
    }

    public static int[] take(IntBuffer buffer, int cnt) {
        if (cnt < 0) {
            throw Messages.msg.parameterOutOfRange("cnt");
        }
        if (buffer.hasArray()) {
            int pos = buffer.position();
            int lim = buffer.limit();
            if (lim - pos < cnt) {
                throw new BufferUnderflowException();
            }
            int[] array = buffer.array();
            int offset = buffer.arrayOffset();
            buffer.position(pos + cnt);
            int start = offset + pos;
            return Arrays.copyOfRange(array, start, start + cnt);
        }
        int[] ints = new int[cnt];
        buffer.get(ints);
        return ints;
    }

    public static long[] take(LongBuffer buffer, int cnt) {
        if (cnt < 0) {
            throw Messages.msg.parameterOutOfRange("cnt");
        }
        if (buffer.hasArray()) {
            int pos = buffer.position();
            int lim = buffer.limit();
            if (lim - pos < cnt) {
                throw new BufferUnderflowException();
            }
            long[] array = buffer.array();
            int offset = buffer.arrayOffset();
            buffer.position(pos + cnt);
            int start = offset + pos;
            return Arrays.copyOfRange(array, start, start + cnt);
        }
        long[] longs = new long[cnt];
        buffer.get(longs);
        return longs;
    }

    public static byte[] take(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (remaining == 0) {
            return NO_BYTES;
        }
        if (buffer.hasArray()) {
            int pos = buffer.position();
            int lim = buffer.limit();
            byte[] array = buffer.array();
            int offset = buffer.arrayOffset();
            buffer.position(lim);
            return Arrays.copyOfRange(array, offset + pos, offset + lim);
        }
        byte[] bytes = new byte[remaining];
        buffer.get(bytes);
        return bytes;
    }

    public static byte[] take(ByteBuffer[] buffers, int offs, int len) {
        if (len == 1) {
            return Buffers.take(buffers[offs]);
        }
        long remaining = Buffers.remaining(buffers, offs, len);
        if (remaining == 0L) {
            return NO_BYTES;
        }
        if (remaining > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("Array too large");
        }
        byte[] bytes = new byte[(int)remaining];
        int o = 0;
        for (int i = 0; i < len; ++i) {
            ByteBuffer buffer = buffers[i + offs];
            int rem = buffer.remaining();
            buffer.get(bytes, o, rem);
            o += rem;
        }
        return bytes;
    }

    public static char[] take(CharBuffer buffer) {
        char[] chars = new char[buffer.remaining()];
        buffer.get(chars);
        return chars;
    }

    public static short[] take(ShortBuffer buffer) {
        short[] shorts = new short[buffer.remaining()];
        buffer.get(shorts);
        return shorts;
    }

    public static int[] take(IntBuffer buffer) {
        int[] ints = new int[buffer.remaining()];
        buffer.get(ints);
        return ints;
    }

    public static long[] take(LongBuffer buffer) {
        long[] longs = new long[buffer.remaining()];
        buffer.get(longs);
        return longs;
    }

    public static Object createDumper(final ByteBuffer buffer, final int indent, final int columns) {
        if (columns <= 0) {
            throw Messages.msg.parameterOutOfRange("columns");
        }
        if (indent < 0) {
            throw Messages.msg.parameterOutOfRange("indent");
        }
        return new Object(){

            public String toString() {
                StringBuilder b = new StringBuilder();
                try {
                    Buffers.dump(buffer, (Appendable)b, indent, columns);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return b.toString();
            }
        };
    }

    public static void dump(ByteBuffer buffer, Appendable dest, int indent, int columns) throws IOException {
        if (columns <= 0) {
            throw Messages.msg.parameterOutOfRange("columns");
        }
        if (indent < 0) {
            throw Messages.msg.parameterOutOfRange("indent");
        }
        int pos = buffer.position();
        int remaining = buffer.remaining();
        int rowLength = 8 << columns - 1;
        int n = Math.max(Integer.toString(buffer.remaining(), 16).length(), 4);
        for (int idx = 0; idx < remaining; idx += rowLength) {
            for (int i = 0; i < indent; ++i) {
                dest.append(' ');
            }
            String s2 = Integer.toString(idx, 16);
            for (int i = n - s2.length(); i > 0; --i) {
                dest.append('0');
            }
            dest.append(s2);
            dest.append(" - ");
            Buffers.appendHexRow(buffer, dest, pos + idx, columns);
            Buffers.appendTextRow(buffer, dest, pos + idx, columns);
            dest.append('\n');
        }
    }

    private static void appendHexRow(ByteBuffer buffer, Appendable dest, int startPos, int columns) throws IOException {
        int limit = buffer.limit();
        int pos = startPos;
        for (int c = 0; c < columns; ++c) {
            for (int i = 0; i < 8; ++i) {
                if (pos >= limit) {
                    dest.append("  ");
                } else {
                    int v = buffer.get(pos++) & 0xFF;
                    String hexVal = Integer.toString(v, 16);
                    if (v < 16) {
                        dest.append('0');
                    }
                    dest.append(hexVal);
                }
                dest.append(' ');
            }
            dest.append(' ');
            dest.append(' ');
        }
    }

    private static void appendTextRow(ByteBuffer buffer, Appendable dest, int startPos, int columns) throws IOException {
        int limit = buffer.limit();
        int pos = startPos;
        dest.append('[');
        dest.append(' ');
        for (int c = 0; c < columns; ++c) {
            for (int i = 0; i < 8; ++i) {
                char v;
                if (pos >= limit) {
                    dest.append(' ');
                    continue;
                }
                if (Character.isISOControl(v = (char)(buffer.get(pos++) & 0xFF))) {
                    dest.append('.');
                    continue;
                }
                dest.append(v);
            }
            dest.append(' ');
        }
        dest.append(']');
    }

    public static Object createDumper(final CharBuffer buffer, final int indent, final int columns) {
        if (columns <= 0) {
            throw Messages.msg.parameterOutOfRange("columns");
        }
        if (indent < 0) {
            throw Messages.msg.parameterOutOfRange("indent");
        }
        return new Object(){

            public String toString() {
                StringBuilder b = new StringBuilder();
                try {
                    Buffers.dump(buffer, (Appendable)b, indent, columns);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return b.toString();
            }
        };
    }

    public static void dump(CharBuffer buffer, Appendable dest, int indent, int columns) throws IOException {
        if (columns <= 0) {
            throw Messages.msg.parameterOutOfRange("columns");
        }
        if (indent < 0) {
            throw Messages.msg.parameterOutOfRange("indent");
        }
        int pos = buffer.position();
        int remaining = buffer.remaining();
        int rowLength = 8 << columns - 1;
        int n = Math.max(Integer.toString(buffer.remaining(), 16).length(), 4);
        for (int idx = 0; idx < remaining; idx += rowLength) {
            for (int i = 0; i < indent; ++i) {
                dest.append(' ');
            }
            String s2 = Integer.toString(idx, 16);
            for (int i = n - s2.length(); i > 0; --i) {
                dest.append('0');
            }
            dest.append(s2);
            dest.append(" - ");
            Buffers.appendHexRow(buffer, dest, pos + idx, columns);
            Buffers.appendTextRow(buffer, dest, pos + idx, columns);
            dest.append('\n');
        }
    }

    private static void appendHexRow(CharBuffer buffer, Appendable dest, int startPos, int columns) throws IOException {
        int limit = buffer.limit();
        int pos = startPos;
        for (int c = 0; c < columns; ++c) {
            for (int i = 0; i < 8; ++i) {
                if (pos >= limit) {
                    dest.append("  ");
                } else {
                    char v = buffer.get(pos++);
                    String hexVal = Integer.toString(v, 16);
                    dest.append("0000".substring(hexVal.length()));
                    dest.append(hexVal);
                }
                dest.append(' ');
            }
            dest.append(' ');
            dest.append(' ');
        }
    }

    private static void appendTextRow(CharBuffer buffer, Appendable dest, int startPos, int columns) throws IOException {
        int limit = buffer.limit();
        int pos = startPos;
        dest.append('[');
        dest.append(' ');
        for (int c = 0; c < columns; ++c) {
            for (int i = 0; i < 8; ++i) {
                char v;
                if (pos >= limit) {
                    dest.append(' ');
                    continue;
                }
                if (Character.isISOControl(v = buffer.get(pos++)) || Character.isHighSurrogate(v) || Character.isLowSurrogate(v)) {
                    dest.append('.');
                    continue;
                }
                dest.append(v);
            }
            dest.append(' ');
        }
        dest.append(']');
    }

    public static boolean hasRemaining(Buffer[] buffers, int offs, int len) {
        for (int i = 0; i < len; ++i) {
            if (!buffers[i + offs].hasRemaining()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRemaining(Buffer[] buffers) {
        return Buffers.hasRemaining(buffers, 0, buffers.length);
    }

    public static long remaining(Buffer[] buffers, int offs, int len) {
        long t = 0L;
        for (int i = 0; i < len; ++i) {
            t += (long)buffers[i + offs].remaining();
        }
        return t;
    }

    public static long remaining(Buffer[] buffers) {
        return Buffers.remaining(buffers, 0, buffers.length);
    }

    public static ByteBuffer putModifiedUtf8(ByteBuffer dest, String orig) throws BufferOverflowException {
        char[] chars;
        for (char c : chars = orig.toCharArray()) {
            if (c > '\u0000' && c <= '\u007f') {
                dest.put((byte)c);
                continue;
            }
            if (c <= '\u07ff') {
                dest.put((byte)(0xC0 | 0x1F & c >> 6));
                dest.put((byte)(0x80 | 0x3F & c));
                continue;
            }
            dest.put((byte)(0xE0 | 0xF & c >> 12));
            dest.put((byte)(0x80 | 0x3F & c >> 6));
            dest.put((byte)(0x80 | 0x3F & c));
        }
        return dest;
    }

    public static String getModifiedUtf8Z(ByteBuffer src) throws BufferUnderflowException {
        StringBuilder builder = new StringBuilder();
        int ch;
        while ((ch = Buffers.readUTFChar(src)) != -1) {
            builder.append((char)ch);
        }
        return builder.toString();
    }

    public static String getModifiedUtf8(ByteBuffer src) throws BufferUnderflowException {
        StringBuilder builder = new StringBuilder();
        while (src.hasRemaining()) {
            int ch = Buffers.readUTFChar(src);
            if (ch == -1) {
                builder.append('\u0000');
                continue;
            }
            builder.append((char)ch);
        }
        return builder.toString();
    }

    private static int readUTFChar(ByteBuffer src) throws BufferUnderflowException {
        int a = src.get() & 0xFF;
        if (a == 0) {
            return -1;
        }
        if (a < 128) {
            return (char)a;
        }
        if (a < 192) {
            return 63;
        }
        if (a < 224) {
            int b = src.get() & 0xFF;
            if ((b & 0xC0) != 128) {
                return 63;
            }
            return (a & 0x1F) << 6 | b & 0x3F;
        }
        if (a < 240) {
            int b = src.get() & 0xFF;
            if ((b & 0xC0) != 128) {
                return 63;
            }
            int c = src.get() & 0xFF;
            if ((c & 0xC0) != 128) {
                return 63;
            }
            return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
        }
        return 63;
    }

    public static boolean readAsciiZ(ByteBuffer src, StringBuilder builder) {
        return Buffers.readAsciiZ(src, builder, '?');
    }

    public static boolean readAsciiZ(ByteBuffer src, StringBuilder builder, char replacement) {
        while (src.hasRemaining()) {
            byte b = src.get();
            if (b == 0) {
                return true;
            }
            builder.append(b < 0 ? replacement : (char)b);
        }
        return false;
    }

    public static boolean readAsciiLine(ByteBuffer src, StringBuilder builder) {
        return Buffers.readAsciiLine(src, builder, '?', '\n');
    }

    public static boolean readAsciiLine(ByteBuffer src, StringBuilder builder, char replacement) {
        return Buffers.readAsciiLine(src, builder, replacement, '\n');
    }

    public static boolean readAsciiLine(ByteBuffer src, StringBuilder builder, char replacement, char delimiter) {
        byte b;
        do {
            if (!src.hasRemaining()) {
                return false;
            }
            b = src.get();
            builder.append(b < 0 ? replacement : (char)b);
        } while (b != delimiter);
        return true;
    }

    public static void readAscii(ByteBuffer src, StringBuilder builder) {
        Buffers.readAscii(src, builder, '?');
    }

    public static void readAscii(ByteBuffer src, StringBuilder builder, char replacement) {
        while (src.hasRemaining()) {
            byte b = src.get();
            builder.append(b < 0 ? replacement : (char)b);
        }
        return;
    }

    public static void readAscii(ByteBuffer src, StringBuilder builder, int limit, char replacement) {
        while (limit > 0) {
            if (!src.hasRemaining()) {
                return;
            }
            byte b = src.get();
            builder.append(b < 0 ? replacement : (char)b);
            --limit;
        }
    }

    public static boolean readLatin1Z(ByteBuffer src, StringBuilder builder) {
        while (src.hasRemaining()) {
            byte b = src.get();
            if (b == 0) {
                return true;
            }
            builder.append((char)(b & 0xFF));
        }
        return false;
    }

    public static boolean readLatin1Line(ByteBuffer src, StringBuilder builder) {
        byte b;
        do {
            if (!src.hasRemaining()) {
                return false;
            }
            b = src.get();
            builder.append((char)(b & 0xFF));
        } while (b != 10);
        return true;
    }

    public static boolean readLatin1Line(ByteBuffer src, StringBuilder builder, char delimiter) {
        byte b;
        do {
            if (!src.hasRemaining()) {
                return false;
            }
            b = src.get();
            builder.append((char)(b & 0xFF));
        } while (b != delimiter);
        return true;
    }

    public static void readLatin1(ByteBuffer src, StringBuilder builder) {
        while (src.hasRemaining()) {
            byte b = src.get();
            builder.append((char)(b & 0xFF));
        }
        return;
    }

    public static boolean readModifiedUtf8Z(ByteBuffer src, StringBuilder builder) {
        return Buffers.readModifiedUtf8Z(src, builder, '?');
    }

    public static boolean readModifiedUtf8Z(ByteBuffer src, StringBuilder builder, char replacement) {
        while (src.hasRemaining()) {
            int b;
            int a = src.get() & 0xFF;
            if (a == 0) {
                return true;
            }
            if (a < 128) {
                builder.append((char)a);
                continue;
            }
            if (a < 192) {
                builder.append(replacement);
                continue;
            }
            if (a < 224) {
                if (src.hasRemaining()) {
                    b = src.get() & 0xFF;
                    if ((b & 0xC0) != 128) {
                        builder.append(replacement);
                        continue;
                    }
                    builder.append((char)((a & 0x1F) << 6 | b & 0x3F));
                    continue;
                }
                Buffers.unget(src, 1);
                return false;
            }
            if (a < 240) {
                if (src.hasRemaining()) {
                    b = src.get() & 0xFF;
                    if ((b & 0xC0) != 128) {
                        builder.append(replacement);
                        continue;
                    }
                    if (src.hasRemaining()) {
                        int c = src.get() & 0xFF;
                        if ((c & 0xC0) != 128) {
                            builder.append(replacement);
                            continue;
                        }
                        builder.append((char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F));
                        continue;
                    }
                    Buffers.unget(src, 2);
                    return false;
                }
                Buffers.unget(src, 1);
                return false;
            }
            builder.append(replacement);
        }
        return false;
    }

    public static boolean readModifiedUtf8Line(ByteBuffer src, StringBuilder builder) {
        return Buffers.readModifiedUtf8Line(src, builder, '?');
    }

    public static boolean readModifiedUtf8Line(ByteBuffer src, StringBuilder builder, char replacement) {
        return Buffers.readModifiedUtf8Line(src, builder, replacement, '\n');
    }

    public static boolean readModifiedUtf8Line(ByteBuffer src, StringBuilder builder, char replacement, char delimiter) {
        while (src.hasRemaining()) {
            int b;
            int a = src.get() & 0xFF;
            if (a < 128) {
                builder.append((char)a);
                if (a != delimiter) continue;
                return true;
            }
            if (a < 192) {
                builder.append(replacement);
                continue;
            }
            if (a < 224) {
                if (src.hasRemaining()) {
                    b = src.get() & 0xFF;
                    if ((b & 0xC0) != 128) {
                        builder.append(replacement);
                        continue;
                    }
                    char ch = (char)((a & 0x1F) << 6 | b & 0x3F);
                    builder.append(ch);
                    if (ch != delimiter) continue;
                    return true;
                }
                Buffers.unget(src, 1);
                return false;
            }
            if (a < 240) {
                if (src.hasRemaining()) {
                    b = src.get() & 0xFF;
                    if ((b & 0xC0) != 128) {
                        builder.append(replacement);
                        continue;
                    }
                    if (src.hasRemaining()) {
                        int c = src.get() & 0xFF;
                        if ((c & 0xC0) != 128) {
                            builder.append(replacement);
                            continue;
                        }
                        char ch = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                        builder.append(ch);
                        if (ch != delimiter) continue;
                        return true;
                    }
                    Buffers.unget(src, 2);
                    return false;
                }
                Buffers.unget(src, 1);
                return false;
            }
            builder.append(replacement);
        }
        return false;
    }

    public static boolean readLine(ByteBuffer src, StringBuilder builder, CharsetDecoder decoder) {
        return Buffers.readLine(src, builder, decoder, '\n');
    }

    public static boolean readLine(ByteBuffer src, StringBuilder builder, CharsetDecoder decoder, char delimiter) {
        CharBuffer oneChar = CharBuffer.allocate(1);
        while (true) {
            CoderResult coderResult;
            if ((coderResult = decoder.decode(src, oneChar, false)).isUnderflow()) {
                if (oneChar.hasRemaining()) {
                    return false;
                }
            } else if (oneChar.hasRemaining()) {
                throw new IllegalStateException();
            }
            char ch = oneChar.get(0);
            builder.append(ch);
            if (ch == delimiter) {
                return true;
            }
            oneChar.clear();
        }
    }

    public static <B extends Buffer> Pooled<B> pooledWrapper(final B buffer) {
        return new Pooled<B>(){
            private volatile B buf;
            {
                this.buf = buffer;
            }

            @Override
            public void discard() {
                this.buf = null;
            }

            @Override
            public void free() {
                this.buf = null;
            }

            @Override
            public B getResource() throws IllegalStateException {
                Object buffer2 = this.buf;
                if (buffer2 == null) {
                    throw new IllegalStateException();
                }
                return buffer2;
            }

            @Override
            public void close() {
                this.free();
            }

            public String toString() {
                return "Pooled wrapper around " + buffer;
            }
        };
    }

    public static Pooled<ByteBuffer> globalPooledWrapper(final ByteBuffer buffer) {
        return new Pooled<ByteBuffer>(){
            private volatile ByteBuffer buf;
            {
                this.buf = buffer;
            }

            @Override
            public void discard() {
                ByteBuffer oldBuf = this.buf;
                if (oldBuf == null) {
                    return;
                }
                final ByteBuffer buf = oldBuf.duplicate();
                new CleanerReference<ByteBuffer, Void>(this.buf, null, new Reaper<ByteBuffer, Void>(){

                    @Override
                    public void reap(Reference<ByteBuffer, Void> reference) {
                        ByteBufferPool.free(buf);
                    }
                });
                this.buf = null;
            }

            @Override
            public void free() {
                ByteBuffer oldBuf = this.buf;
                if (oldBuf == null) {
                    return;
                }
                ByteBufferPool.free(oldBuf);
                this.buf = null;
            }

            @Override
            public ByteBuffer getResource() throws IllegalStateException {
                ByteBuffer buffer2 = this.buf;
                if (buffer2 == null) {
                    throw new IllegalStateException();
                }
                return buffer2;
            }

            @Override
            public void close() {
                this.free();
            }

            public String toString() {
                return "Globally pooled wrapper around " + buffer;
            }
        };
    }

    public static Pooled<ByteBuffer> emptyPooledByteBuffer() {
        return new Pooled<ByteBuffer>(){

            @Override
            public void discard() {
            }

            @Override
            public void free() {
            }

            @Override
            public ByteBuffer getResource() throws IllegalStateException {
                return EMPTY_BYTE_BUFFER;
            }

            @Override
            public void close() {
            }
        };
    }

    public static BufferAllocator<ByteBuffer> sliceAllocator(final ByteBuffer buffer) {
        return new BufferAllocator<ByteBuffer>(){

            @Override
            public ByteBuffer allocate(int size) throws IllegalArgumentException {
                return Buffers.slice(buffer, size);
            }
        };
    }

    public static <B extends Buffer> Pool<B> allocatedBufferPool(final BufferAllocator<B> allocator, final int size) {
        return new Pool<B>(){

            @Override
            public Pooled<B> allocate() {
                return Buffers.pooledWrapper(allocator.allocate(size));
            }
        };
    }

    public static Pool<ByteBuffer> secureBufferPool(Pool<ByteBuffer> delegate) {
        return new SecureByteBufferPool(delegate);
    }

    public static boolean isSecureBufferPool(Pool<?> pool) {
        return pool instanceof SecureByteBufferPool;
    }

    public static void zero(ByteBuffer buffer) {
        buffer.clear();
        while (buffer.remaining() >= 8) {
            buffer.putLong(0L);
        }
        while (buffer.hasRemaining()) {
            buffer.put((byte)0);
        }
        buffer.clear();
    }

    public static void zero(CharBuffer buffer) {
        buffer.clear();
        while (buffer.remaining() >= 32) {
            buffer.put("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        }
        while (buffer.hasRemaining()) {
            buffer.put('\u0000');
        }
        buffer.clear();
    }

    public static boolean isDirect(Buffer ... buffers) throws IllegalArgumentException {
        return Buffers.isDirect(buffers, 0, buffers.length);
    }

    public static boolean isDirect(Buffer[] buffers, int offset, int length) {
        boolean foundDirect = false;
        boolean foundHeap = false;
        for (int i = 0; i < length; ++i) {
            Buffer buffer = buffers[i + offset];
            if (buffer == null) {
                throw Messages.msg.nullParameter("buffer");
            }
            if (buffer.isDirect()) {
                if (foundHeap) {
                    throw Messages.msg.mixedDirectAndHeap();
                }
                foundDirect = true;
                continue;
            }
            if (foundDirect) {
                throw Messages.msg.mixedDirectAndHeap();
            }
            foundHeap = true;
        }
        return foundDirect;
    }

    public static void assertWritable(Buffer[] buffers, int offs, int len) throws ReadOnlyBufferException {
        for (int i = 0; i < len; ++i) {
            if (!buffers[i + offs].isReadOnly()) continue;
            throw Messages.msg.readOnlyBuffer();
        }
    }

    public static void assertWritable(Buffer ... buffers) throws ReadOnlyBufferException {
        Buffers.assertWritable(buffers, 0, buffers.length);
    }

    public static void addRandom(ByteBuffer target, Random random, int count) {
        byte[] bytes = new byte[count];
        random.nextBytes(bytes);
        target.put(bytes);
    }

    public static void addRandom(ByteBuffer target, int count) {
        Buffers.addRandom(target, IoUtils.getThreadLocalRandom(), count);
    }

    public static void addRandom(ByteBuffer target, Random random) {
        if (target.remaining() == 0) {
            return;
        }
        Buffers.addRandom(target, random, random.nextInt(target.remaining()));
    }

    public static void addRandom(ByteBuffer target) {
        Buffers.addRandom(target, IoUtils.getThreadLocalRandom());
    }

    public static int fillFromStream(ByteBuffer target, InputStream source2) throws IOException {
        int res;
        int remaining = target.remaining();
        if (remaining == 0) {
            return 0;
        }
        int p = target.position();
        if (target.hasArray()) {
            int res2;
            try {
                res2 = source2.read(target.array(), p + target.arrayOffset(), remaining);
            }
            catch (InterruptedIOException e) {
                target.position(p + e.bytesTransferred);
                throw e;
            }
            if (res2 > 0) {
                target.position(p + res2);
            }
            return res2;
        }
        byte[] tmp = new byte[remaining];
        try {
            res = source2.read(tmp);
        }
        catch (InterruptedIOException e) {
            int n = e.bytesTransferred;
            target.put(tmp, 0, n);
            target.position(p + n);
            throw e;
        }
        if (res > 0) {
            target.put(tmp, 0, res);
        }
        return res;
    }

    public static String debugString(ByteBuffer buffer) {
        StringBuilder b = new StringBuilder();
        b.append("1 buffer of ").append(buffer.remaining()).append(" bytes");
        return b.toString();
    }

    public static String debugString(ByteBuffer[] buffers, int offs, int len) {
        StringBuilder b = new StringBuilder();
        b.append(len).append(" buffer(s)");
        if (len > 0) {
            b.append(" of ").append(Buffers.remaining(buffers, offs, len)).append(" bytes");
        }
        return b.toString();
    }

    public static void emptyToStream(OutputStream target, ByteBuffer source2) throws IOException {
        int remaining = source2.remaining();
        if (remaining == 0) {
            return;
        }
        int p = source2.position();
        if (source2.hasArray()) {
            try {
                target.write(source2.array(), p + source2.arrayOffset(), remaining);
            }
            catch (InterruptedIOException e) {
                source2.position(p + e.bytesTransferred);
                throw e;
            }
            source2.position(source2.limit());
            return;
        }
        byte[] tmp = Buffers.take(source2);
        try {
            target.write(tmp);
        }
        catch (InterruptedIOException e) {
            source2.position(p + e.bytesTransferred);
            throw e;
        }
        catch (IOException e) {
            source2.position(p);
            throw e;
        }
    }

    private static class SecurePooledByteBuffer
    implements Pooled<ByteBuffer> {
        private static final AtomicIntegerFieldUpdater<SecurePooledByteBuffer> freedUpdater = AtomicIntegerFieldUpdater.newUpdater(SecurePooledByteBuffer.class, "freed");
        private final Pooled<ByteBuffer> allocated;
        private volatile int freed;

        SecurePooledByteBuffer(Pooled<ByteBuffer> allocated) {
            this.allocated = allocated;
        }

        @Override
        public void discard() {
            if (freedUpdater.compareAndSet(this, 0, 1)) {
                Buffers.zero(this.allocated.getResource());
                this.allocated.discard();
            }
        }

        @Override
        public void free() {
            if (freedUpdater.compareAndSet(this, 0, 1)) {
                Buffers.zero(this.allocated.getResource());
                this.allocated.free();
            }
        }

        @Override
        public ByteBuffer getResource() throws IllegalStateException {
            return this.allocated.getResource();
        }

        @Override
        public void close() {
            this.free();
        }

        public String toString() {
            return "Secure wrapper around " + this.allocated;
        }
    }

    private static class SecureByteBufferPool
    implements Pool<ByteBuffer> {
        private final Pool<ByteBuffer> delegate;

        SecureByteBufferPool(Pool<ByteBuffer> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Pooled<ByteBuffer> allocate() {
            return new SecurePooledByteBuffer(this.delegate.allocate());
        }
    }
}

