/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.Encoder;
import org.owasp.encoder.Unicode;

class XMLEncoder
extends Encoder {
    private static final long BASE_VALID_MASK = 9728L;
    static final int MAX_ENCODED_CHAR_LENGTH = 5;
    static final int AMP_LENGTH = 5;
    static final int LT_LENGTH = 4;
    static final int GT_LENGTH = 4;
    static final int APOS_LENGTH = 5;
    static final int QUOT_LENGTH = 5;
    static final char INVALID_CHARACTER_REPLACEMENT = ' ';
    private final long _validMask;
    private final Mode _mode;

    XMLEncoder() {
        this(Mode.ALL);
    }

    XMLEncoder(Mode mode) {
        this._mode = mode;
        this._validMask = mode.validMask();
    }

    public int maxEncodedLength(int n) {
        return n * 5;
    }

    public int firstEncodedOffset(String input, int off, int len) {
        int n = off + len;
        for (int i = off; i < n; ++i) {
            char ch = input.charAt(i);
            if (ch < '\u007f') {
                if (ch > '>' || (this._validMask & 1L << ch) != 0L) continue;
                return i;
            }
            if (ch < '\ud800') {
                if (ch > '\u009f' || ch == '\u0085') continue;
                return i;
            }
            if (ch <= '\udbff') {
                if (i + 1 < n && Character.isLowSurrogate(input.charAt(i + 1))) {
                    int cp = Character.toCodePoint(ch, input.charAt(i + 1));
                    if (Unicode.isNonCharacter(cp)) {
                        return i;
                    }
                    ++i;
                    continue;
                }
                return i;
            }
            if (ch > '\udfff' && ch <= '\ufffd' && ('\ufdd0' > ch || ch > '\ufdef')) continue;
            return i;
        }
        return n;
    }

    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        int i;
        char[] in = input.array();
        char[] out = output.array();
        int n = input.arrayOffset() + input.limit();
        int j = output.arrayOffset() + output.position();
        int m3 = output.arrayOffset() + output.limit();
        for (i = input.arrayOffset() + input.position(); i < n; ++i) {
            char ch = in[i];
            if (ch < '\u007f') {
                if (ch > '>' || (this._validMask & 1L << ch) != 0L) {
                    if (j >= m3) {
                        return XMLEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = ch;
                    continue;
                }
                switch (ch) {
                    case '&': {
                        if (j + 5 > m3) {
                            return XMLEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 38;
                        out[j++] = 97;
                        out[j++] = 109;
                        out[j++] = 112;
                        out[j++] = 59;
                        break;
                    }
                    case '<': {
                        if (j + 4 > m3) {
                            return XMLEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 38;
                        out[j++] = 108;
                        out[j++] = 116;
                        out[j++] = 59;
                        break;
                    }
                    case '>': {
                        if (j + 4 > m3) {
                            return XMLEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 38;
                        out[j++] = 103;
                        out[j++] = 116;
                        out[j++] = 59;
                        break;
                    }
                    case '\'': {
                        if (j + 5 > m3) {
                            return XMLEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 38;
                        out[j++] = 35;
                        out[j++] = 51;
                        out[j++] = 57;
                        out[j++] = 59;
                        break;
                    }
                    case '\"': {
                        if (j + 5 > m3) {
                            return XMLEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 38;
                        out[j++] = 35;
                        out[j++] = 51;
                        out[j++] = 52;
                        out[j++] = 59;
                        break;
                    }
                    default: {
                        if (j >= m3) {
                            return XMLEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 32;
                        break;
                    }
                }
                continue;
            }
            if (ch < '\ud800') {
                if (j >= m3) {
                    return XMLEncoder.overflow(input, i, output, j);
                }
                if (ch > '\u009f' || ch == '\u0085') {
                    out[j++] = ch;
                    continue;
                }
                out[j++] = 32;
                continue;
            }
            if (ch <= '\udbff') {
                if (i + 1 < n) {
                    if (Character.isLowSurrogate(in[i + 1])) {
                        int cp = Character.toCodePoint(ch, in[i + 1]);
                        if (Unicode.isNonCharacter(cp)) {
                            if (j >= m3) {
                                return XMLEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = 32;
                            ++i;
                            continue;
                        }
                        if (j + 1 >= m3) {
                            return XMLEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = ch;
                        out[j++] = in[++i];
                        continue;
                    }
                    if (j >= m3) {
                        return XMLEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 32;
                    continue;
                }
                if (!endOfInput) break;
                if (j >= m3) {
                    return XMLEncoder.overflow(input, i, output, j);
                }
                out[j++] = 32;
                continue;
            }
            if (ch <= '\udfff' || ch > '\ufffd' || '\ufdd0' <= ch && ch <= '\ufdef') {
                if (j >= m3) {
                    return XMLEncoder.overflow(input, i, output, j);
                }
                out[j++] = 32;
                continue;
            }
            if (j >= m3) {
                return XMLEncoder.overflow(input, i, output, j);
            }
            out[j++] = ch;
        }
        return XMLEncoder.underflow(input, i, output, j);
    }

    public String toString() {
        return "XMLEncoder(" + (Object)((Object)this._mode) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        ALL("&<>'\""),
        CONTENT("&<>"),
        ATTRIBUTE("&<'\""),
        SINGLE_QUOTED_ATTRIBUTE("&<'"),
        DOUBLE_QUOTED_ATTRIBUTE("&<\"");

        private final long _validMask;

        private Mode(String encodedChars) {
            long encodeMask = 0L;
            int n2 = encodedChars.length();
            for (int i = 0; i < n2; ++i) {
                encodeMask |= 1L << encodedChars.charAt(i);
            }
            this._validMask = 0x2600L | 0xFFFFFFFF00000000L & (encodeMask ^ 0xFFFFFFFFFFFFFFFFL);
        }

        long validMask() {
            return this._validMask;
        }
    }
}

