/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mariadb.jdbc.CallParameter;
import org.mariadb.jdbc.CallableParameterMetaData;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLPreparedStatement;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;

public class MySQLCallableStatement
implements CallableStatement {
    MySQLConnection con;
    PreparedStatement preparedStatement;
    int batchCount;
    BitSet batchIgnoreResult;
    String callQuery;
    Statement callStatement;
    ResultSet rsOutputParameters;
    CallParameter[] params;
    CallableParameterMetaData parameterMetadata;
    int parametersCount;
    static Pattern CALLABLE_STATEMENT_PATTERN = Pattern.compile("^\\s*\\{?\\s*(\\?\\s*=)?\\s*call\\s*([\\w.]+)(\\(.*\\))?\\s*}?", 2);

    public MySQLCallableStatement(MySQLConnection connection, String query) throws SQLException {
        this.con = connection;
        query = Utils.nativeSQL(query, connection.noBackslashEscapes);
        this.batchIgnoreResult = new BitSet();
        Matcher m3 = CALLABLE_STATEMENT_PATTERN.matcher(query);
        if (!m3.matches()) {
            throw new SQLSyntaxErrorException("invalid callable syntax");
        }
        boolean isFunction = m3.group(1) != null;
        String procedureName = m3.group(2);
        String arguments = m3.group(3);
        this.callQuery = !isFunction ? "call " + procedureName + this.resolveArguments(arguments, 1) : "select " + procedureName + this.resolveArguments(arguments, 2) + " into " + this.getVariableName(1);
        this.callStatement = this.con.createStatement();
        if (this.parametersCount != 0) {
            int i;
            StringBuffer sb = new StringBuffer("set ");
            for (i = 1; i <= this.parametersCount; ++i) {
                if (i > 1) {
                    sb.append(",");
                }
                sb.append(this.getVariableName(i));
                sb.append("=?");
            }
            this.preparedStatement = this.con.prepareStatement(sb.toString());
            for (i = 1; i <= this.parametersCount; ++i) {
                this.preparedStatement.setNull(i, 0);
            }
        }
        this.params = new CallParameter[this.parametersCount + 1];
        for (int i = 1; i <= this.parametersCount; ++i) {
            this.params[i] = new CallParameter();
        }
        if (isFunction) {
            this.params[1].isOutput = true;
        }
        this.parameterMetadata = new CallableParameterMetaData(this.params, this.con, procedureName, isFunction);
    }

    boolean hasOutputParameters() {
        for (int i = 1; i < this.params.length; ++i) {
            if (!this.params[i].isOutput) continue;
            return true;
        }
        return false;
    }

    private String getVariableName(int index) {
        return "@_jdbc_var_" + index;
    }

    void readOutputParameters() throws SQLException {
        if (this.callStatement.getFetchSize() == Integer.MIN_VALUE) {
            while (this.callStatement.getMoreResults()) {
            }
        }
        StringBuffer sb = new StringBuffer("SELECT ");
        for (int i = 1; i <= this.parametersCount; ++i) {
            if (i != 1) {
                sb.append(",");
            }
            if (!this.params[i].isOutput) {
                sb.append("NULL");
                continue;
            }
            sb.append(this.getVariableName(i));
        }
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery(sb.toString());
        rs.next();
        this.rsOutputParameters = rs;
    }

    ResultSet outputParameters() throws SQLException {
        if (this.parametersCount == 0) {
            throw new SQLException("no output parameters");
        }
        if (this.rsOutputParameters == null) {
            this.readOutputParameters();
        }
        return this.rsOutputParameters;
    }

    PreparedStatement inputParameters() throws SQLException {
        if (this.parametersCount == 0) {
            throw new SQLException("no input parameters");
        }
        return this.preparedStatement;
    }

    private int nameToIndex(String parameterName) throws SQLException {
        if (this.callStatement != null) {
            while (this.callStatement.getMoreResults()) {
            }
        }
        for (int i = 1; i <= this.parameterMetadata.getParameterCount(); ++i) {
            String name = this.parameterMetadata.getName(i);
            if (name == null || !name.equalsIgnoreCase(parameterName)) continue;
            return i;
        }
        throw new SQLException("there is no parameter with the name " + parameterName);
    }

    String resolveArguments(String args2, int startingIndex) {
        if (args2 == null) {
            this.parametersCount = 0;
            return "()";
        }
        StringBuffer sb = new StringBuffer();
        int index = startingIndex;
        boolean inQuote = false;
        boolean inComment = false;
        char quoteChar = '\u0000';
        char prevChar = '\u0000';
        boolean slashStarComment = false;
        boolean inEscape = false;
        for (char c : args2.toCharArray()) {
            if (c == '\\' && !inComment && !inQuote) {
                boolean bl = inEscape = !inEscape;
            }
            if (inEscape) {
                sb.append(c);
                inEscape = false;
                continue;
            }
            switch (c) {
                case '?': {
                    if (!inQuote && !inComment) {
                        sb.append(this.getVariableName(index++));
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case '\"': 
                case '\'': {
                    if (!inComment) {
                        if (inQuote) {
                            if (quoteChar == c) {
                                inQuote = false;
                            }
                        } else {
                            inQuote = true;
                            quoteChar = c;
                        }
                    }
                    sb.append(c);
                    break;
                }
                case '*': {
                    if (prevChar == '/' && !inQuote) {
                        inComment = true;
                        slashStarComment = true;
                    }
                    sb.append(c);
                    break;
                }
                case '/': {
                    if (prevChar == '*' && inComment && slashStarComment) {
                        inComment = false;
                        slashStarComment = false;
                    } else if (prevChar == '/' && !inQuote) {
                        inComment = true;
                    }
                    sb.append(c);
                    break;
                }
                case '\n': {
                    if (inComment && !slashStarComment) {
                        inComment = false;
                    }
                    sb.append(c);
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            prevChar = c;
        }
        this.parametersCount = index - 1;
        return sb.toString();
    }

    CallParameter getParameter(int index) throws SQLException {
        if (index > this.params.length || index < 1) {
            throw new SQLException("No parameter with index " + index);
        }
        return this.params[index];
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, -1);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        CallParameter p = this.getParameter(parameterIndex);
        p.isOutput = true;
        p.outputSQLType = sqlType;
        p.scale = scale;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.outputParameters().wasNull();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        return this.outputParameters().getString(parameterIndex);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this.outputParameters().getBoolean(parameterIndex);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return this.outputParameters().getByte(parameterIndex);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return this.outputParameters().getShort(parameterIndex);
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return this.outputParameters().getInt(parameterIndex);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return this.outputParameters().getLong(parameterIndex);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return this.outputParameters().getFloat(parameterIndex);
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return this.outputParameters().getDouble(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.outputParameters().getBigDecimal(parameterIndex);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this.outputParameters().getBytes(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.outputParameters().getDate(parameterIndex);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.outputParameters().getTime(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.outputParameters().getTimestamp(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        if (!this.params[parameterIndex].isOutput) {
            throw new SQLException("Parameter " + parameterIndex + " is not an output parameter");
        }
        switch (this.params[parameterIndex].outputSQLType) {
            case 1111: {
                throw new SQLException("unexpected Type returned");
            }
            case 2003: {
                return this.getArray(parameterIndex);
            }
            case -5: {
                return this.getLong(parameterIndex);
            }
            case -2: {
                return this.getBytes(parameterIndex);
            }
            case -7: {
                return this.getInt(parameterIndex);
            }
            case 16: {
                return this.getBoolean(parameterIndex);
            }
            case 1: {
                return this.getString(parameterIndex);
            }
            case 2005: {
                return this.getClob(parameterIndex);
            }
            case 70: {
                return this.getString(parameterIndex);
            }
            case 91: {
                return this.getDate(parameterIndex);
            }
            case 3: {
                return this.getBigDecimal(parameterIndex);
            }
            case 2001: {
                return this.getString(parameterIndex);
            }
            case 8: {
                return this.getDouble(parameterIndex);
            }
            case 4: {
                return this.getInt(parameterIndex);
            }
            case 2000: {
                return this.getObject(parameterIndex);
            }
            case -16: {
                return this.getString(parameterIndex);
            }
            case -4: {
                return this.getBytes(parameterIndex);
            }
            case -1: {
                return this.getString(parameterIndex);
            }
            case -15: {
                return this.getString(parameterIndex);
            }
            case 2011: {
                return this.getNClob(parameterIndex);
            }
            case 0: {
                return null;
            }
            case 2: {
                return this.getBigDecimal(parameterIndex);
            }
            case -9: {
                return this.getString(parameterIndex);
            }
            case 7: {
                return this.getDouble(parameterIndex);
            }
            case 2006: {
                return this.getRef(parameterIndex);
            }
            case -8: {
                return this.getRowId(parameterIndex);
            }
            case 5: {
                return this.getShort(parameterIndex);
            }
            case 2009: {
                return this.getSQLXML(parameterIndex);
            }
            case 2002: {
                return this.getBytes(parameterIndex);
            }
            case 92: {
                return this.getTime(parameterIndex);
            }
            case 93: {
                return this.getTimestamp(parameterIndex);
            }
            case -6: {
                return this.getByte(parameterIndex);
            }
            case -3: {
                return this.getBytes(parameterIndex);
            }
            case 12: {
                return this.getString(parameterIndex);
            }
        }
        return this.outputParameters().getObject(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.outputParameters().getBigDecimal(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return this.outputParameters().getObject(parameterIndex, map);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        return this.outputParameters().getRef(parameterIndex);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        return this.outputParameters().getBlob(parameterIndex);
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        return this.outputParameters().getClob(parameterIndex);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        return this.outputParameters().getArray(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.outputParameters().getDate(parameterIndex, cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.outputParameters().getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.outputParameters().getTimestamp(parameterIndex, cal);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        CallParameter p = this.getParameter(parameterIndex);
        p.sqlType = sqlType;
        p.typeName = typeName;
        p.isOutput = true;
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType, typeName);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        return this.outputParameters().getURL(parameterIndex);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.setURL(this.nameToIndex(parameterName), val);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.nameToIndex(parameterName), sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.nameToIndex(parameterName), x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.nameToIndex(parameterName), x, length);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), x, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.nameToIndex(parameterName), x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.nameToIndex(parameterName), x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.nameToIndex(parameterName), x, cal);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.nameToIndex(parameterName), sqlType, typeName);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.getString(this.nameToIndex(parameterName));
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.getBoolean(this.nameToIndex(parameterName));
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.getByte(this.nameToIndex(parameterName));
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.getShort(this.nameToIndex(parameterName));
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.getInt(this.nameToIndex(parameterName));
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.getLong(this.nameToIndex(parameterName));
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.getFloat(this.nameToIndex(parameterName));
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.getDouble(this.nameToIndex(parameterName));
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.getBytes(this.nameToIndex(parameterName));
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.getDate(this.nameToIndex(parameterName));
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.getTime(this.nameToIndex(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getTimestamp(this.nameToIndex(parameterName));
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.getObject(this.nameToIndex(parameterName));
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getBigDecimal(this.nameToIndex(parameterName));
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.nameToIndex(parameterName), map);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.getRef(this.nameToIndex(parameterName));
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.getBlob(this.nameToIndex(parameterName));
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.getClob(this.nameToIndex(parameterName));
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.getArray(this.nameToIndex(parameterName));
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getDate(this.nameToIndex(parameterName), cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getTime(this.nameToIndex(parameterName), cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.nameToIndex(parameterName), cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.getURL(this.nameToIndex(parameterName));
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        return this.outputParameters().getRowId(parameterIndex);
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return this.getRowId(this.nameToIndex(parameterName));
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.setRowId(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.setNString(this.nameToIndex(parameterName), value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setNCharacterStream(this.nameToIndex(parameterName), value, length);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.setNClob(this.nameToIndex(parameterName), value);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream2, long length) throws SQLException {
        this.setBlob(this.nameToIndex(parameterName), inputStream2, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setNClob(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        return this.outputParameters().getNClob(parameterIndex);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.getNClob(this.nameToIndex(parameterName));
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.setSQLXML(this.nameToIndex(parameterName), xmlObject);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        return this.outputParameters().getSQLXML(parameterIndex);
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return this.getSQLXML(this.nameToIndex(parameterName));
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.outputParameters().getNString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getNString(this.nameToIndex(parameterName));
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.outputParameters().getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getNCharacterStream(this.nameToIndex(parameterName));
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return this.outputParameters().getCharacterStream(parameterIndex);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getCharacterStream(this.nameToIndex(parameterName));
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.inputParameters().setBlob(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.inputParameters().setClob(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.inputParameters().setAsciiStream(this.nameToIndex(parameterName), x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.inputParameters().setBinaryStream(this.nameToIndex(parameterName), x, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.inputParameters().setCharacterStream(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.inputParameters().setAsciiStream(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.inputParameters().setBinaryStream(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.inputParameters().setCharacterStream(this.nameToIndex(parameterName), reader);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.inputParameters().setNCharacterStream(this.nameToIndex(parameterName), value);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.inputParameters().setClob(this.nameToIndex(parameterName), reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream2) throws SQLException {
        this.inputParameters().setBlob(this.nameToIndex(parameterName), inputStream2);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.inputParameters().setNClob(this.nameToIndex(parameterName), reader);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.execute()) {
            return this.getResultSet();
        }
        throw new SQLException("CallableStatement.executeQuery() did not return a restult set", "HY000");
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (!this.execute()) {
            return this.getUpdateCount();
        }
        throw new SQLException("CallableStatement.executeUpdate() returned a restult set", "HY000");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.inputParameters().setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.inputParameters().setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.inputParameters().setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.inputParameters().setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.inputParameters().setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.inputParameters().setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.inputParameters().setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.inputParameters().setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.inputParameters().setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.inputParameters().setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.inputParameters().setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.inputParameters().setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.inputParameters().setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.inputParameters().setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.inputParameters().setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.inputParameters().setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.inputParameters().setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        if (this.parametersCount > 0) {
            MySQLPreparedStatement ps = (MySQLPreparedStatement)this.inputParameters();
            if (!ps.parametersCleared) {
                ps.clearParameters();
                for (int i = 1; i <= this.parametersCount; ++i) {
                    ps.setNull(i, 0);
                }
                this.inputParameters().execute();
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.inputParameters().setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.inputParameters().setObject(parameterIndex, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        MySQLProtocol mySQLProtocol = this.con.getProtocol();
        synchronized (mySQLProtocol) {
            if (this.rsOutputParameters != null) {
                this.rsOutputParameters.close();
                this.rsOutputParameters = null;
            }
            if (this.parametersCount > 0) {
                this.preparedStatement.execute();
            }
            boolean ret = this.callStatement.execute(this.callQuery);
            if (this.hasOutputParameters() && this.callStatement.getFetchSize() != Integer.MIN_VALUE) {
                this.readOutputParameters();
            }
            return ret;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.preparedStatement == null) {
            this.preparedStatement = this.con.prepareStatement(this.callQuery);
            this.preparedStatement.addBatch();
        } else if (this.parametersCount == 0) {
            this.preparedStatement.addBatch();
        } else {
            this.preparedStatement.addBatch();
            this.batchIgnoreResult.set(this.batchCount);
            ++this.batchCount;
            this.preparedStatement.addBatch(this.callQuery);
            ++this.batchCount;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.inputParameters().setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.inputParameters().setRef(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.inputParameters().setBlob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.inputParameters().setClob(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.inputParameters().setArray(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet rs = this.callStatement.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.inputParameters().setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.inputParameters().setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.inputParameters().setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.inputParameters().setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.inputParameters().setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.parameterMetadata.readMetadataFromDBIfRequired();
        return this.parameterMetadata;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.inputParameters().setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.inputParameters().setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.inputParameters().setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.inputParameters().setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.inputParameters().setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream2, long length) throws SQLException {
        this.inputParameters().setBlob(parameterIndex, inputStream2, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.inputParameters().setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.inputParameters().setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream2) throws SQLException {
        this.setBlob(parameterIndex, inputStream2);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setNClob(parameterIndex, reader);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.callStatement.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.callStatement.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
            this.preparedStatement = null;
        }
        if (this.rsOutputParameters != null) {
            this.rsOutputParameters.close();
            this.rsOutputParameters = null;
        }
        if (this.callStatement != null) {
            this.callStatement.close();
            this.callStatement = null;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.callStatement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.callStatement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.callStatement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.callStatement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.callStatement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.callStatement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.callStatement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.callStatement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.callStatement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.callStatement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.callStatement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("CallableStatement does not support execute(String sql)");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.callStatement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.callStatement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.callStatement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.callStatement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.callStatement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.callStatement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.callStatement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.callStatement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.callStatement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.parametersCount == 0) {
            if (this.preparedStatement == null) {
                this.preparedStatement = this.con.prepareStatement(sql);
                this.preparedStatement.addBatch();
            }
        } else {
            this.preparedStatement.addBatch(sql);
            ++this.batchCount;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.clearBatch();
            if (this.parametersCount == 0) {
                this.preparedStatement.close();
                this.preparedStatement = null;
            }
        }
        this.batchCount = 0;
        this.batchIgnoreResult.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.preparedStatement != null) {
            int[] unfilteredResult = this.preparedStatement.executeBatch();
            if (this.batchIgnoreResult.cardinality() == 0) {
                return unfilteredResult;
            }
            int[] filteredResult = new int[unfilteredResult.length - this.batchIgnoreResult.cardinality()];
            int index = 0;
            for (int i = 0; i < unfilteredResult.length; ++i) {
                if (this.batchIgnoreResult.get(i)) continue;
                filteredResult[index++] = unfilteredResult[i];
            }
            return filteredResult;
        }
        return new int[0];
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.con;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.callStatement.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.callStatement.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.callStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.callStatement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.callStatement.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.callStatement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.callStatement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.callStatement.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.callStatement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.callStatement.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public <T> T getObject(int arg0, Class<T> arg1) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String arg0, Class<T> arg1) throws SQLException {
        return null;
    }
}

