/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import java.nio.ByteBuffer;
import org.xnio.Pool;
import org.xnio.Pooled;

public class XnioBufferPoolAdaptor
implements Pool<ByteBuffer> {
    private final ByteBufferPool byteBufferPool;

    public XnioBufferPoolAdaptor(ByteBufferPool byteBufferPool) {
        this.byteBufferPool = byteBufferPool;
    }

    @Override
    public Pooled<ByteBuffer> allocate() {
        final PooledByteBuffer buf = this.byteBufferPool.allocate();
        return new Pooled<ByteBuffer>(){

            @Override
            public void discard() {
                buf.close();
            }

            @Override
            public void free() {
                buf.close();
            }

            @Override
            public ByteBuffer getResource() throws IllegalStateException {
                return buf.getBuffer();
            }

            @Override
            public void close() {
                buf.close();
            }
        };
    }
}

