/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.tracerresolver;

import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.PriorityComparator;
import io.opentracing.contrib.tracerresolver.TracerConverter;
import io.opentracing.contrib.tracerresolver.TracerFactory;
import io.opentracing.util.GlobalTracer;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TracerResolver {
    private static final Logger LOGGER = Logger.getLogger(TracerResolver.class.getName());

    @Deprecated
    protected abstract Tracer resolve();

    public static Tracer resolveTracer() {
        return TracerResolver.resolveTracer(null);
    }

    public static Tracer resolveTracer(ClassLoader classloader) {
        try {
            if (GlobalTracer.isRegistered()) {
                return TracerResolver.logResolved(GlobalTracer.get());
            }
        }
        catch (NoClassDefFoundError globalTracerNotInClasspath) {
            LOGGER.finest("GlobalTracer is not found on the classpath.");
        }
        Tracer tracer = null;
        if (!TracerResolver.isDisabled()) {
            if (classloader == null) {
                classloader = Thread.currentThread().getContextClassLoader();
            }
            if (null == (tracer = TracerResolver.getFromFactory(classloader))) {
                tracer = TracerResolver.getFromResolver(classloader);
            }
            if (null == tracer) {
                tracer = TracerResolver.getFromServiceLoader(classloader);
            }
        }
        return tracer;
    }

    @Deprecated
    public static void reload() {
        LOGGER.log(Level.FINER, "No-op for this implementation.");
    }

    private static boolean isDisabled() {
        String prop = System.getProperty("tracerresolver.disabled", System.getenv("TRACERRESOLVER_DISABLED"));
        return prop != null && (prop.equals("1") || prop.equalsIgnoreCase("true"));
    }

    private static Tracer convert(Tracer resolved) {
        if (resolved != null) {
            for (TracerConverter converter : PriorityComparator.prioritize(ServiceLoader.load(TracerConverter.class))) {
                try {
                    Tracer converted = converter.convert(resolved);
                    LOGGER.log(Level.FINEST, "Converted {0} using {1}: {2}.", new Object[]{resolved, converter, converted});
                    resolved = converted;
                }
                catch (RuntimeException rte) {
                    LOGGER.log(Level.WARNING, "Error converting " + resolved + " with " + converter + ": " + rte.getMessage(), rte);
                }
                if (resolved != null) continue;
                break;
            }
        }
        return resolved;
    }

    private static Tracer logResolved(Tracer resolvedTracer) {
        LOGGER.log(Level.FINER, "Resolved tracer: {0}.", resolvedTracer);
        return resolvedTracer;
    }

    private static Tracer getFromFactory(ClassLoader classloader) {
        for (TracerFactory factory2 : PriorityComparator.prioritize(ServiceLoader.load(TracerFactory.class, classloader))) {
            try {
                Tracer tracer = TracerResolver.convert(factory2.getTracer());
                if (tracer == null) continue;
                return TracerResolver.logResolved(tracer);
            }
            catch (RuntimeException rte) {
                LOGGER.log(Level.WARNING, "Error getting tracer using " + factory2 + ": " + rte.getMessage(), rte);
            }
        }
        return null;
    }

    private static Tracer getFromResolver(ClassLoader classloader) {
        for (TracerResolver resolver : PriorityComparator.prioritize(ServiceLoader.load(TracerResolver.class, classloader))) {
            try {
                Tracer tracer = TracerResolver.convert(resolver.resolve());
                if (tracer == null) continue;
                return TracerResolver.logResolved(tracer);
            }
            catch (RuntimeException rte) {
                LOGGER.log(Level.WARNING, "Error resolving tracer using " + resolver + ": " + rte.getMessage(), rte);
            }
        }
        return null;
    }

    private static Tracer getFromServiceLoader(ClassLoader classloader) {
        for (Tracer tracer : PriorityComparator.prioritize(ServiceLoader.load(Tracer.class, classloader))) {
            if ((tracer = TracerResolver.convert(tracer)) == null) continue;
            return TracerResolver.logResolved(tracer);
        }
        return null;
    }
}

