/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.SignKeyRequest;
import com.networknt.client.oauth.TokenKeyRequest;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.JsonMapper;
import com.networknt.exception.ClientException;
import com.networknt.exception.ExpiredTokenException;
import com.networknt.security.SecurityConfig;
import com.networknt.status.Status;
import com.networknt.utility.FingerPrintUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.keys.resolvers.X509VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtVerifier {
    static final Logger logger = LoggerFactory.getLogger(JwtVerifier.class);
    static final String GET_KEY_ERROR = "ERR10066";
    public static final String KID = "kid";
    public static final String SECURITY_CONFIG = "security";
    private static final int CACHE_EXPIRED_IN_MINUTES = 15;
    public static final String JWT_KEY_RESOLVER_X509CERT = "X509Certificate";
    public static final String JWT_KEY_RESOLVER_JWKS = "JsonWebKeySet";
    SecurityConfig config;
    int secondsOfAllowedClockSkew;
    Boolean enableJwtCache;
    Boolean enableRelaxedKeyValidation;
    Boolean bootstrapFromKeyService;
    static Cache<String, JwtClaims> cache;
    static Map<String, X509Certificate> certMap;
    static Map<String, List<JsonWebKey>> jwksMap;
    static List<String> fingerPrints;

    public JwtVerifier(SecurityConfig config) {
        this.config = config;
        this.secondsOfAllowedClockSkew = config.getClockSkewInSeconds();
        this.bootstrapFromKeyService = config.isBootstrapFromKeyService();
        this.enableRelaxedKeyValidation = config.isEnableRelaxedKeyValidation();
        this.enableJwtCache = config.isEnableJwtCache();
        if (Boolean.TRUE.equals(this.enableJwtCache)) {
            cache = Caffeine.newBuilder().maximumSize(config.getJwtCacheFullSize()).expireAfterWrite(15L, TimeUnit.MINUTES).build();
        }
        String keyResolver = config.getKeyResolver();
        this.cacheCertificates();
        jwksMap = JWT_KEY_RESOLVER_JWKS.equals(keyResolver) && this.bootstrapFromKeyService != false ? this.getJsonWebKeyMap() : new HashMap<String, List<JsonWebKey>>();
    }

    private void cacheCertificates() {
        certMap = new HashMap<String, X509Certificate>();
        fingerPrints = new ArrayList<String>();
        if (this.config.getCertificate() != null) {
            Map<String, Object> keyMap = this.config.getCertificate();
            for (String kid : keyMap.keySet()) {
                X509Certificate cert = null;
                try {
                    cert = this.readCertificate((String)keyMap.get(kid));
                }
                catch (Exception e) {
                    logger.error("Exception:", e);
                }
                certMap.put(kid, cert);
                fingerPrints.add(FingerPrintUtil.getCertFingerPrint(cert));
            }
        }
        logger.debug("Successfully cached Certificate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate readCertificate(String filename) throws Exception {
        InputStream inStream = null;
        X509Certificate cert = null;
        try {
            inStream = Config.getInstance().getInputStreamFromFile(filename);
            if (inStream != null) {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                cert = (X509Certificate)cf.generateCertificate(inStream);
            } else {
                logger.info("Certificate " + Encode.forJava(filename) + " not found.");
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException ioe) {
                    logger.error("Exception: ", ioe);
                }
            }
        }
        return cert;
    }

    public static String getJwtFromAuthorization(String authorization) {
        String[] parts;
        String jwt = null;
        if (authorization != null && (parts = authorization.split(" ")).length == 2) {
            String scheme = parts[0];
            String credentials = parts[1];
            Pattern pattern = Pattern.compile("^Bearer$", 2);
            if (pattern.matcher(scheme).matches()) {
                jwt = credentials;
            }
        }
        return jwt;
    }

    public JwtClaims verifyJwt(String jwt, boolean ignoreExpiry, boolean isToken, String pathPrefix, String requestPath, List<String> jwkServiceIds) throws InvalidJwtException, ExpiredTokenException {
        return this.verifyJwt(jwt, ignoreExpiry, isToken, pathPrefix, requestPath, jwkServiceIds, this::getKeyResolver);
    }

    public JwtClaims verifyJwt(String jwt, boolean ignoreExpiry, boolean isToken) throws InvalidJwtException, ExpiredTokenException {
        return this.verifyJwt(jwt, ignoreExpiry, isToken, null, null, null, this::getKeyResolver);
    }

    public JwtClaims verifyJwt(String jwt, boolean ignoreExpiry, boolean isToken, String pathPrefix, String requestPath, List<String> jwkServiceIds, BiFunction<String, Object, VerificationKeyResolver> getKeyResolver) throws InvalidJwtException, ExpiredTokenException {
        JwtClaims claims;
        if (Boolean.TRUE.equals(this.enableJwtCache) && (claims = pathPrefix != null ? cache.getIfPresent(pathPrefix + ":" + jwt) : cache.getIfPresent(jwt)) != null) {
            JwtVerifier.checkExpiry(ignoreExpiry, claims, this.secondsOfAllowedClockSkew, null);
            return claims;
        }
        JwtConsumerBuilder pKeyBuilder = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification();
        if (this.enableRelaxedKeyValidation.booleanValue()) {
            pKeyBuilder.setRelaxVerificationKeyValidation();
        }
        JwtConsumer consumer = pKeyBuilder.build();
        JwtContext jwtContext = consumer.process(jwt);
        claims = jwtContext.getJwtClaims();
        JsonWebStructure structure = jwtContext.getJoseObjects().get(0);
        String kid = structure.getKeyIdHeaderValue();
        JwtVerifier.checkExpiry(ignoreExpiry, claims, this.secondsOfAllowedClockSkew, jwtContext);
        JwtConsumerBuilder jwtBuilder = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(315360000).setSkipDefaultAudienceValidation().setVerificationKeyResolver(getKeyResolver.apply(kid, jwkServiceIds != null ? jwkServiceIds : requestPath));
        if (this.enableRelaxedKeyValidation.booleanValue()) {
            jwtBuilder.setRelaxVerificationKeyValidation();
        }
        consumer = jwtBuilder.build();
        jwtContext = consumer.process(jwt);
        claims = jwtContext.getJwtClaims();
        if (Boolean.TRUE.equals(this.enableJwtCache)) {
            if (pathPrefix != null) {
                cache.put(pathPrefix + ":" + jwt, claims);
            } else {
                cache.put(jwt, claims);
            }
            if (cache.estimatedSize() > (long)this.config.getJwtCacheFullSize()) {
                logger.error("JWT cache exceeds the size limit " + this.config.getJwtCacheFullSize());
            }
        }
        return claims;
    }

    private static void checkExpiry(boolean ignoreExpiry, JwtClaims claim, int allowedClockSkew, JwtContext context) throws ExpiredTokenException, InvalidJwtException {
        if (!ignoreExpiry) {
            try {
                if (NumericDate.now().getValue() - (long)allowedClockSkew >= claim.getExpirationTime().getValue()) {
                    logger.info("Cached jwt token is expired!");
                    throw new ExpiredTokenException("Token is expired");
                }
            }
            catch (MalformedClaimException e) {
                logger.error("MalformedClaimException:", e);
                throw new InvalidJwtException("MalformedClaimException", new ErrorCodeValidator.Error(18, "Invalid ExpirationTime Format"), e, context);
            }
        }
    }

    private VerificationKeyResolver getKeyResolver(String kid, Object requestPathOrJwkServiceIds) {
        X509Certificate certificate;
        String keyResolver = this.config.getKeyResolver();
        X509Certificate x509Certificate = certificate = certMap == null ? null : certMap.get(kid);
        if (certificate != null) {
            X509VerificationKeyResolver x509VerificationKeyResolver = new X509VerificationKeyResolver(certificate);
            x509VerificationKeyResolver.setTryAllOnNoThumbHeader(true);
            return x509VerificationKeyResolver;
        }
        if (JWT_KEY_RESOLVER_JWKS.equals(keyResolver)) {
            List serviceIds;
            Object serviceId4;
            ClientConfig clientConfig = ClientConfig.get();
            List<JsonWebKey> jwkList = null;
            if (requestPathOrJwkServiceIds == null) {
                jwkList = jwksMap.get(kid);
            } else if (requestPathOrJwkServiceIds instanceof String) {
                String requestPath = (String)requestPathOrJwkServiceIds;
                serviceId4 = this.getServiceIdByRequestPath(clientConfig, requestPath);
                jwkList = serviceId4 == null ? jwksMap.get(kid) : jwksMap.get((String)serviceId4 + ":" + kid);
            } else if (requestPathOrJwkServiceIds instanceof List && (serviceIds = (List)requestPathOrJwkServiceIds) != null && serviceIds.size() > 0) {
                String serviceId2;
                serviceId4 = serviceIds.iterator();
                while (serviceId4.hasNext() && ((jwkList = jwksMap.get((serviceId2 = (String)serviceId4.next()) + ":" + kid)) == null || jwkList.size() <= 0)) {
                }
            }
            if (jwkList == null) {
                jwkList = this.getJsonWebKeySetForToken(kid, requestPathOrJwkServiceIds);
                if (jwkList == null || jwkList.isEmpty()) {
                    throw new RuntimeException("no JWK for kid: " + kid);
                }
                if (requestPathOrJwkServiceIds == null) {
                    this.cacheJwkList(jwkList, null);
                } else if (requestPathOrJwkServiceIds instanceof String) {
                    String serviceId3 = this.getServiceIdByRequestPath(clientConfig, (String)requestPathOrJwkServiceIds);
                    this.cacheJwkList(jwkList, serviceId3);
                } else if (requestPathOrJwkServiceIds instanceof List) {
                    for (Object serviceId4 : (List)requestPathOrJwkServiceIds) {
                        this.cacheJwkList(jwkList, (String)serviceId4);
                    }
                }
            }
            logger.debug("Got Json web key set from local cache");
            return new JwksVerificationKeyResolver(jwkList);
        }
        logger.error("Both X509Certificate and JWK are not configured.");
        return null;
    }

    private void cacheJwkList(List<JsonWebKey> jwkList, String serviceId) {
        for (JsonWebKey jwk : jwkList) {
            if (serviceId != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("cache the jwkList with serviceId {} kid {} and key {}", serviceId, jwk.getKeyId(), serviceId + ":" + jwk.getKeyId());
                }
                jwksMap.put(serviceId + ":" + jwk.getKeyId(), jwkList);
                continue;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("cache the jwkList with kid and only kid as key", (Object)jwk.getKeyId());
            }
            jwksMap.put(jwk.getKeyId(), jwkList);
        }
    }

    private String getServiceIdByRequestPath(ClientConfig clientConfig, String requestPath) {
        Map<String, String> pathPrefixServices = clientConfig.getPathPrefixServices();
        if (clientConfig.isMultipleAuthServers()) {
            if (pathPrefixServices == null || pathPrefixServices.size() == 0) {
                throw new ConfigException("pathPrefixServices property is missing or has an empty value in client.yml");
            }
            String serviceId = null;
            for (Map.Entry<String, String> entry : pathPrefixServices.entrySet()) {
                if (!requestPath.startsWith(entry.getKey())) continue;
                serviceId = entry.getValue();
            }
            if (serviceId == null) {
                throw new ConfigException("serviceId cannot be identified in client.yml with the requestPath = " + requestPath);
            }
            return serviceId;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, List<JsonWebKey>> getJsonWebKeyMap() {
        jwksMap = new HashMap<String, List<JsonWebKey>>();
        ClientConfig clientConfig = ClientConfig.get();
        if (clientConfig.isMultipleAuthServers()) {
            Map<String, Object> tokenConfig = clientConfig.getTokenConfig();
            Map keyConfig = (Map)tokenConfig.get("key");
            Map serviceIdAuthServers = (Map)keyConfig.get("serviceIdAuthServers");
            Map<String, String> pathPrefixServices = clientConfig.getPathPrefixServices();
            if (serviceIdAuthServers == null) {
                throw new RuntimeException("serviceIdAuthServers property is missing in the token key configuration");
            }
            for (Map.Entry entry : serviceIdAuthServers.entrySet()) {
                String serviceId = (String)entry.getKey();
                Map authServerConfig = (Map)entry.getValue();
                TokenKeyRequest keyRequest = new TokenKeyRequest(null, true, authServerConfig);
                try {
                    List<JsonWebKey> jwkList;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Getting Json Web Key list from {} for serviceId {}", (Object)keyRequest.getServerUrl(), entry.getKey());
                    }
                    String key = OauthHelper.getKey(keyRequest);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Got Json Web Key = " + key);
                    }
                    if ((jwkList = new JsonWebKeySet(key).getJsonWebKeys()) == null || jwkList.isEmpty()) {
                        if (!logger.isErrorEnabled()) continue;
                        logger.error("Cannot get JWK from OAuth server.");
                        continue;
                    }
                    for (JsonWebKey jwk : jwkList) {
                        jwksMap.put(serviceId + ":" + jwk.getKeyId(), jwkList);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Successfully cached JWK for serviceId {} kid {} with key {}", serviceId, jwk.getKeyId(), serviceId + ":" + jwk.getKeyId());
                    }
                }
                catch (JoseException ce) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("Failed to get JWK set. - {} - {}", new Status(GET_KEY_ERROR, new Object[0]), ce.getMessage(), ce);
                }
                catch (ClientException ce) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("Failed to get key. - {} - {} ", new Status(GET_KEY_ERROR, new Object[0]), ce.getMessage(), ce);
                }
            }
            return jwksMap;
        } else {
            TokenKeyRequest keyRequest = new TokenKeyRequest(null, true, null);
            try {
                List<JsonWebKey> jwkList;
                if (logger.isDebugEnabled()) {
                    logger.debug("Getting Json Web Key list from {}", (Object)keyRequest.getServerUrl());
                }
                String key = OauthHelper.getKey(keyRequest);
                if (logger.isDebugEnabled()) {
                    logger.debug("Got Json Web Key = " + key);
                }
                if ((jwkList = new JsonWebKeySet(key).getJsonWebKeys()) == null || jwkList.isEmpty()) {
                    throw new RuntimeException("cannot get JWK from OAuth server");
                }
                for (JsonWebKey jwk : jwkList) {
                    jwksMap.put(jwk.getKeyId(), jwkList);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Successfully cached JWK for kid {}", (Object)jwk.getKeyId());
                }
                return jwksMap;
            }
            catch (JoseException ce) {
                if (!logger.isErrorEnabled()) return jwksMap;
                logger.error("Failed to get JWK. - {} - {}", new Status(GET_KEY_ERROR, new Object[0]), ce.getMessage(), ce);
                return jwksMap;
            }
            catch (ClientException ce) {
                if (!logger.isErrorEnabled()) return jwksMap;
                logger.error("Failed to get Key. - {} - {}", new Status(GET_KEY_ERROR, new Object[0]), ce.getMessage(), ce);
            }
        }
        return jwksMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<JsonWebKey> getJsonWebKeySetForToken(String kid, Object requestPathOrJwkServiceIds) {
        if (logger.isTraceEnabled()) {
            logger.trace("kid = " + kid + requestPathOrJwkServiceIds instanceof String ? " requestPath = " + requestPathOrJwkServiceIds : " jwkServiceIds = " + requestPathOrJwkServiceIds);
        }
        ClientConfig clientConfig = ClientConfig.get();
        List<JsonWebKey> jwks = null;
        Map<String, Object> config = null;
        if (requestPathOrJwkServiceIds == null) return this.retrieveJwk(kid, null);
        if (!clientConfig.isMultipleAuthServers()) return this.retrieveJwk(kid, null);
        if (requestPathOrJwkServiceIds instanceof String) {
            String requestPath = (String)requestPathOrJwkServiceIds;
            Map<String, String> pathPrefixServices = clientConfig.getPathPrefixServices();
            if (pathPrefixServices == null) throw new ConfigException("pathPrefixServices property is missing or has an empty value in client.yml");
            if (pathPrefixServices.size() == 0) {
                throw new ConfigException("pathPrefixServices property is missing or has an empty value in client.yml");
            }
            String serviceId = null;
            for (Map.Entry<String, String> entry : pathPrefixServices.entrySet()) {
                if (!requestPath.startsWith(entry.getKey())) continue;
                serviceId = entry.getValue();
            }
            if (serviceId == null) {
                throw new ConfigException("serviceId cannot be identified in client.yml with the requestPath = " + requestPath);
            }
            config = this.getJwkConfig(clientConfig, serviceId);
            return this.retrieveJwk(kid, config);
        }
        if (!(requestPathOrJwkServiceIds instanceof List)) throw new ConfigException("requestPathOrJwkServiceIds must be a string or a list of strings");
        List jwkServiceIds = (List)requestPathOrJwkServiceIds;
        jwks = new ArrayList<JsonWebKey>();
        Iterator iterator2 = jwkServiceIds.iterator();
        while (iterator2.hasNext()) {
            String serviceId = (String)iterator2.next();
            config = this.getJwkConfig(clientConfig, serviceId);
            jwks.addAll(this.retrieveJwk(kid, config));
        }
        return jwks;
    }

    private Map<String, Object> getJwkConfig(ClientConfig clientConfig, String serviceId) {
        Map<String, Object> tokenConfig;
        Map keyConfig;
        Map serviceIdAuthServers;
        if (logger.isTraceEnabled()) {
            logger.trace("serviceId = " + serviceId);
        }
        if ((serviceIdAuthServers = (Map)(keyConfig = (Map)(tokenConfig = clientConfig.getTokenConfig()).get("key")).get("serviceIdAuthServers")) == null) {
            throw new ConfigException("serviceIdAuthServers property is missing in the token key configuration in client.yml");
        }
        return (Map)serviceIdAuthServers.get(serviceId);
    }

    private List<JsonWebKey> retrieveJwk(String kid, Map<String, Object> config) {
        block7: {
            if (logger.isTraceEnabled() && config != null) {
                logger.trace("multiple oauth config based on path = " + JsonMapper.toJson(config));
            }
            TokenKeyRequest keyRequest = new TokenKeyRequest(kid, true, config);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Getting Json Web Key list from {}", (Object)keyRequest.getServerUrl());
                }
                String key = OauthHelper.getKey(keyRequest);
                if (logger.isDebugEnabled()) {
                    logger.debug("Got Json Web Key list from {}", (Object)keyRequest.getServerUrl());
                }
                return new JsonWebKeySet(key).getJsonWebKeys();
            }
            catch (JoseException ce) {
                if (logger.isErrorEnabled()) {
                    logger.error("Failed to get JWK. - {} - {}", new Status(GET_KEY_ERROR, new Object[0]), ce.getMessage(), ce);
                }
            }
            catch (ClientException ce) {
                if (!logger.isErrorEnabled()) break block7;
                logger.error("Failed to get key - {} - {}", new Status(GET_KEY_ERROR, new Object[0]), ce.getMessage(), ce);
            }
        }
        return null;
    }

    public X509Certificate getCertForToken(String kid) {
        X509Certificate certificate;
        block6: {
            certificate = null;
            TokenKeyRequest keyRequest = new TokenKeyRequest(kid);
            try {
                if (logger.isWarnEnabled()) {
                    logger.warn("<Deprecated: use JsonWebKeySet instead> Getting raw certificate for kid: {} from {}", (Object)kid, (Object)keyRequest.getServerUrl());
                }
                String key = OauthHelper.getKey(keyRequest);
                if (logger.isWarnEnabled()) {
                    logger.warn("<Deprecated: use JsonWebKeySet instead> Got raw certificate {} for kid: {}", (Object)key, (Object)kid);
                }
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(key.getBytes(StandardCharsets.UTF_8)));
            }
            catch (CertificateException ce) {
                if (logger.isErrorEnabled()) {
                    logger.error("Failed to generate certificate: {}", (Object)ce.getMessage(), (Object)ce);
                }
            }
            catch (ClientException ce) {
                if (!logger.isErrorEnabled()) break block6;
                logger.error("Failed to get key: {}", (Object)ce.getMessage(), (Object)ce);
            }
        }
        return certificate;
    }

    public X509Certificate getCertForSign(String kid) {
        X509Certificate certificate;
        block4: {
            certificate = null;
            SignKeyRequest keyRequest = new SignKeyRequest(kid);
            try {
                String key = OauthHelper.getKey(keyRequest);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(key.getBytes(StandardCharsets.UTF_8)));
            }
            catch (CertificateException ce) {
                if (logger.isErrorEnabled()) {
                    logger.error("Failed to generate certificate: {}", (Object)ce.getMessage(), (Object)ce);
                }
            }
            catch (ClientException ce) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error("Failed to get key: {}", (Object)ce.getMessage(), (Object)ce);
            }
        }
        return certificate;
    }

    public List<String> getFingerPrints() {
        return fingerPrints;
    }
}

