/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.registry.support;

import com.networknt.config.Config;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectRegistryConfig {
    private static final Logger logger = LoggerFactory.getLogger(DirectRegistryConfig.class);
    public static final String CONFIG_NAME = "direct-registry";
    private static final String DIRECT_URLS = "directUrls";
    Map<String, List<URL>> directUrls;
    private Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    public DirectRegistryConfig() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setMap();
    }

    public DirectRegistryConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setMap();
    }

    static DirectRegistryConfig load() {
        return new DirectRegistryConfig();
    }

    static DirectRegistryConfig load(String configName) {
        return new DirectRegistryConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setMap();
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    Config getConfig() {
        return this.config;
    }

    public Map<String, List<URL>> getDirectUrls() {
        return this.directUrls;
    }

    public void setDirectUrls(Map<String, List<URL>> directUrls) {
        this.directUrls = directUrls;
    }

    private void setMap() {
        Map<String, String> map = new LinkedHashMap();
        if (this.getMappedConfig() != null) {
            if (this.getMappedConfig().get(DIRECT_URLS) instanceof String) {
                String s2 = (String)this.getMappedConfig().get(DIRECT_URLS);
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s2);
                }
                if (s2.startsWith("{")) {
                    try {
                        map = Config.getInstance().getMapper().readValue(s2, Map.class);
                    }
                    catch (IOException e) {
                        logger.error("IOException:", e);
                    }
                } else {
                    for (String keyValue : s2.split(" *& *")) {
                        String[] pairs = keyValue.split(" *= *", 2);
                        map.put(pairs[0], pairs.length == 1 ? "" : pairs[1]);
                    }
                }
            } else if (this.getMappedConfig().get(DIRECT_URLS) instanceof Map) {
                map = (Map)this.getMappedConfig().get(DIRECT_URLS);
            } else {
                logger.error("mapping is missing or wrong type.");
            }
            this.directUrls = new HashMap<String, List<URL>>();
            map.entrySet().stream().forEach(x -> {
                List<String> urls2 = Arrays.asList(((String)x.getValue()).split(","));
                this.directUrls.put((String)x.getKey(), urls2.stream().map(URLImpl::valueOf).collect(Collectors.toUnmodifiableList()));
            });
        }
    }
}

