/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.portal.registry;

import com.networknt.portal.registry.PortalRegistryConstants;
import com.networknt.portal.registry.PortalRegistryService;
import com.networknt.portal.registry.client.PortalRegistryClient;
import com.networknt.utility.ConcurrentHashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalRegistryHeartbeatManager {
    private static final Logger logger = LoggerFactory.getLogger(PortalRegistryHeartbeatManager.class);
    private PortalRegistryClient client;
    private String token;
    private ConcurrentHashSet<PortalRegistryService> services = new ConcurrentHashSet();
    private ThreadPoolExecutor jobExecutor;
    private ScheduledExecutorService heartbeatExecutor;
    private boolean lastHeartBeatSwitcherStatus = false;
    private volatile boolean currentHeartBeatSwitcherStatus = false;
    private int switcherCheckTimes = 0;

    public PortalRegistryHeartbeatManager(PortalRegistryClient client, String token) {
        this.client = client;
        this.token = token;
        this.heartbeatExecutor = Executors.newSingleThreadScheduledExecutor();
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(10000);
        this.jobExecutor = new ThreadPoolExecutor(5, 30, 30000L, TimeUnit.MILLISECONDS, workQueue);
    }

    public void start() {
        this.heartbeatExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean switcherStatus = PortalRegistryHeartbeatManager.this.isHeartbeatOpen();
                    if (PortalRegistryHeartbeatManager.this.isSwitcherChange(switcherStatus)) {
                        PortalRegistryHeartbeatManager.this.processHeartbeat(switcherStatus);
                    } else if (switcherStatus) {
                        ++PortalRegistryHeartbeatManager.this.switcherCheckTimes;
                        if (PortalRegistryHeartbeatManager.this.switcherCheckTimes >= PortalRegistryConstants.MAX_SWITCHER_CHECK_TIMES) {
                            PortalRegistryHeartbeatManager.this.processHeartbeat(true);
                            PortalRegistryHeartbeatManager.this.switcherCheckTimes = 0;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("consul heartbeat executor err:", e);
                }
            }
        }, PortalRegistryConstants.SWITCHER_CHECK_CIRCLE, PortalRegistryConstants.SWITCHER_CHECK_CIRCLE, TimeUnit.MILLISECONDS);
    }

    private boolean isSwitcherChange(boolean switcherStatus) {
        boolean ret = false;
        if (switcherStatus != this.lastHeartBeatSwitcherStatus) {
            ret = true;
            this.lastHeartBeatSwitcherStatus = switcherStatus;
            logger.info("heartbeat switcher change to " + switcherStatus);
        }
        return ret;
    }

    protected void processHeartbeat(boolean isPass) {
        for (PortalRegistryService service : this.services) {
            try {
                this.jobExecutor.execute(new HeartbeatJob(service, isPass));
            }
            catch (RejectedExecutionException ree) {
                logger.error("execute heartbeat job fail! serviceId:" + service.getServiceId() + " is rejected");
            }
        }
    }

    public void close() {
        this.heartbeatExecutor.shutdown();
        this.jobExecutor.shutdown();
        logger.info("Consul heartbeatManager closed.");
    }

    public void addHeartbeatService(PortalRegistryService service) {
        this.services.add(service);
    }

    public void removeHeartbeatService(PortalRegistryService service) {
        this.services.remove(service);
    }

    private boolean isHeartbeatOpen() {
        return this.currentHeartBeatSwitcherStatus;
    }

    public void setHeartbeatOpen(boolean open) {
        this.currentHeartBeatSwitcherStatus = open;
    }

    public void setClient(PortalRegistryClient client) {
        this.client = client;
    }

    class HeartbeatJob
    implements Runnable {
        private PortalRegistryService service;
        private boolean isPass;

        public HeartbeatJob(PortalRegistryService service, boolean isPass) {
            this.service = service;
            this.isPass = isPass;
        }

        @Override
        public void run() {
            try {
                if (this.isPass) {
                    PortalRegistryHeartbeatManager.this.client.checkPass(this.service, PortalRegistryHeartbeatManager.this.token);
                } else {
                    PortalRegistryHeartbeatManager.this.client.checkFail(this.service, PortalRegistryHeartbeatManager.this.token);
                }
            }
            catch (Exception e) {
                logger.error("portal controller heartbeat-set check pass error!serviceId:" + this.service.getServiceId(), e);
            }
        }
    }
}

