/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.token.handler;

import com.networknt.body.BodyHandler;
import com.networknt.config.Config;
import com.networknt.oauth.cache.AuditInfoHandler;
import com.networknt.oauth.cache.model.AuditInfo;
import com.networknt.oauth.cache.model.Oauth2Service;
import com.networknt.oauth.token.handler.OauthRefeshTokenConfig;
import io.undertow.server.HttpServerExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTokenAuditHandler
extends AuditInfoHandler {
    static final Logger logger = LoggerFactory.getLogger(RefreshTokenAuditHandler.class);
    private static final String CONFIG = "oauth_refreshtoken";
    private static final OauthRefeshTokenConfig oauth_config = (OauthRefeshTokenConfig)Config.getInstance().getJsonObjectConfig("oauth_refreshtoken", OauthRefeshTokenConfig.class);

    protected void processAudit(HttpServerExchange exchange) throws Exception {
        if (oauth_config.isEnableAudit()) {
            AuditInfo auditInfo = new AuditInfo();
            auditInfo.setServiceId(Oauth2Service.REFRESHTOKEN);
            auditInfo.setEndpoint(exchange.getHostName() + exchange.getRelativePath());
            auditInfo.setRequestHeader(exchange.getRequestHeaders().toString());
            auditInfo.setRequestBody(Config.getInstance().getMapper().writeValueAsString(exchange.getAttachment(BodyHandler.REQUEST_BODY)));
            auditInfo.setResponseCode(exchange.getStatusCode());
            auditInfo.setResponseHeader(exchange.getResponseHeaders().toString());
            auditInfo.setResponseBody(Config.getInstance().getMapper().writeValueAsString(exchange.getResponseCookies()));
            this.saveAudit(auditInfo);
        }
    }
}

