/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.monad;

import com.networknt.monad.Failure;
import com.networknt.monad.Success;
import com.networknt.status.Status;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Result<T> {
    public boolean isSuccess();

    default public boolean isFailure() {
        return !this.isSuccess();
    }

    public Status getError();

    public T getResult();

    default public <R> Result<R> map(Function<? super T, ? extends R> mapper) {
        return this.isSuccess() ? Success.of(mapper.apply(this.getResult())) : (Failure)this;
    }

    default public <R> Result<R> flatMap(Function<? super T, Result<R>> mapper) {
        return this.isSuccess() ? mapper.apply(this.getResult()) : (Failure)this;
    }

    default public <R> R fold(Function<? super T, ? extends R> successFunction, Function<Failure<R>, ? extends R> failureFunction) {
        return this.isSuccess() ? successFunction.apply(this.getResult()) : failureFunction.apply((Failure)this);
    }

    default public <R, Z> Result<Z> lift(Result<R> other, BiFunction<? super T, ? super R, ? extends Z> function) {
        return this.flatMap(first -> other.map(second -> function.apply((Object)first, (Object)second)));
    }

    default public Result<T> ifSuccess(Consumer<? super T> successConsumer) {
        if (this.isSuccess()) {
            successConsumer.accept(this.getResult());
        }
        return this;
    }

    default public Result<T> ifFailure(Consumer<Failure<T>> failureConsumer) {
        if (this.isFailure()) {
            failureConsumer.accept((Failure)this);
        }
        return this;
    }
}

