/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.jsonoverlay.MinSharingJsonNodeFactory;
import com.networknt.jsonoverlay.Pair;
import com.networknt.jsonoverlay.PositionInfo;
import com.networknt.jsonoverlay.parser.LocationRecorderYamlFactory;
import com.networknt.jsonoverlay.parser.LocationRecorderYamlParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonLoader {
    private static LocationRecorderYamlFactory yamlFactory = new LocationRecorderYamlFactory();
    private static ObjectMapper yamlMapper = new ObjectMapper(yamlFactory);
    private Map<String, JsonNode> cache = new HashMap<String, JsonNode>();
    private Map<String, Map<JsonPointer, PositionInfo>> positions = new HashMap<String, Map<JsonPointer, PositionInfo>>();

    public JsonNode load(URL url) throws IOException {
        String urlString = url.toString();
        if (this.cache.containsKey(urlString)) {
            return this.cache.get(urlString);
        }
        try (InputStream in = url.openStream();){
            Scanner scanner = new Scanner(in, "UTF-8");
            try {
                String json = scanner.useDelimiter("\\Z").next();
                JsonNode jsonNode = this.loadString(url, json);
                scanner.close();
                return jsonNode;
            }
            catch (Throwable throwable) {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public JsonNode loadString(URL url, String json) throws IOException, JsonProcessingException {
        Pair<JsonNode, Map<JsonPointer, PositionInfo>> result = this.loadWithLocations(json);
        if (url != null) {
            this.cache.put(url.toString(), result.getLeft());
            this.positions.put(url.toString(), result.getRight());
        }
        return result.getLeft();
    }

    public Optional<PositionInfo> getPositionInfo(String url, JsonPointer pointer) {
        if (this.positions.containsKey(url)) {
            return Optional.ofNullable(this.positions.get(url).get(pointer));
        }
        return Optional.empty();
    }

    public Pair<JsonNode, Map<JsonPointer, PositionInfo>> loadWithLocations(String json) throws IOException {
        LocationRecorderYamlParser parser = (LocationRecorderYamlParser)yamlFactory.createParser(this.fixTabs(json));
        JsonNode tree = (JsonNode)yamlMapper.readTree(parser);
        Map<JsonPointer, PositionInfo> regions = parser.getLocations();
        return Pair.of(tree, regions);
    }

    private String fixTabs(String json) {
        Pattern initialTabs = Pattern.compile("^(\\t+)", 8);
        Matcher m3 = initialTabs.matcher(json);
        StringBuffer sb = new StringBuffer();
        while (m3.find()) {
            m3.appendReplacement(sb, m3.group(1).replaceAll("\\t", " "));
        }
        m3.appendTail(sb);
        return sb.toString();
    }

    static {
        yamlMapper.setNodeFactory(MinSharingJsonNodeFactory.instance);
    }
}

