/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.OverlayFactory;
import com.networknt.jsonoverlay.ReferenceManager;
import com.networknt.jsonoverlay.ScalarOverlay;
import com.networknt.jsonoverlay.SerializationOptions;

public abstract class EnumOverlay<V extends Enum<V>>
extends ScalarOverlay<V> {
    private Class<V> enumClass = null;

    protected EnumOverlay(JsonNode json, JsonOverlay<?> parent, OverlayFactory<V> factory2, ReferenceManager refMgr) {
        super(json, parent, factory2, refMgr);
    }

    protected EnumOverlay(V value, JsonOverlay<?> parent, OverlayFactory<V> factory2, ReferenceManager refMgr) {
        super(value, parent, factory2, refMgr);
        this.enumClass = this.getEnumClass();
    }

    @Override
    protected V _fromJson(JsonNode json) {
        if (!json.isTextual()) {
            return null;
        }
        if (this.enumClass == null) {
            this.enumClass = this.getEnumClass();
        }
        try {
            return Enum.valueOf(this.enumClass, json.asText());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    protected JsonNode _toJsonInternal(SerializationOptions options) {
        return this.value != null ? EnumOverlay._jsonScalar(((Enum)this.value).name()) : EnumOverlay._jsonMissing();
    }

    protected abstract Class<V> getEnumClass();
}

