/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler.conduit;

import com.networknt.handler.BuffersUtils;
import com.networknt.handler.ProxyHandler;
import com.networknt.handler.ResponseInterceptor;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.service.SingletonServiceFactory;
import io.undertow.client.ClientConnection;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.protocol.http.ServerFixedLengthStreamSinkConduit;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkChannelWrappingConduit;
import org.xnio.conduits.StreamSinkConduit;

public class ModifiableContentSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    public static int MAX_BUFFERS = 1024;
    static final Logger logger = LoggerFactory.getLogger(ModifiableContentSinkConduit.class);
    private final HttpServerExchange exchange;
    private final ResponseInterceptor[] interceptors;

    public ModifiableContentSinkConduit(StreamSinkConduit next, HttpServerExchange exchange) {
        super(next);
        this.exchange = exchange;
        this.interceptors = SingletonServiceFactory.getBeans(ResponseInterceptor.class);
        this.resetBufferPool(exchange);
    }

    private void resetBufferPool(HttpServerExchange exchange) {
        PooledByteBuffer[] oldBuffers = exchange.getAttachment(AttachmentConstants.BUFFERED_RESPONSE_DATA_KEY);
        if (oldBuffers != null) {
            for (PooledByteBuffer oldBuffer : oldBuffers) {
                if (oldBuffer == null) continue;
                oldBuffer.close();
            }
        }
        exchange.putAttachment(AttachmentConstants.BUFFERED_RESPONSE_DATA_KEY, new PooledByteBuffer[MAX_BUFFERS]);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return BuffersUtils.append(src, this.exchange.getAttachment(AttachmentConstants.BUFFERED_RESPONSE_DATA_KEY), this.exchange);
    }

    @Override
    public long write(ByteBuffer[] dsts, int offs, int len) throws IOException {
        for (int i = offs; i < len; ++i) {
            ByteBuffer srcBuffer = dsts[offs + i];
            if (!srcBuffer.hasRemaining()) continue;
            return this.write(srcBuffer);
        }
        return 0L;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source2, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source2, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public void terminateWrites() throws IOException {
        if (this.interceptors == null || this.interceptors.length == 0) {
            ((StreamSinkConduit)this.next).terminateWrites();
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("terminating writes with interceptors length = " + this.interceptors.length);
        }
        try {
            for (ResponseInterceptor interceptor : this.interceptors) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing interceptor " + interceptor.getClass());
                }
                interceptor.handleRequest(this.exchange);
            }
        }
        catch (Exception e) {
            logger.error("Error executing interceptors: " + e.getMessage(), e);
            throw new RuntimeException(e);
        }
        PooledByteBuffer[] dests = this.exchange.getAttachment(AttachmentConstants.BUFFERED_RESPONSE_DATA_KEY);
        if (logger.isTraceEnabled()) {
            logger.trace("Next conduit is: {}", (Object)((StreamSinkConduit)this.next).getClass().getName());
        }
        if (this.exchange.getResponseHeaders().get(Headers.CONTENT_LENGTH) != null) {
            this.updateContentLength(this.exchange, dests);
        }
        this.writeToNextConduit(dests);
    }

    private void writeToNextConduit(PooledByteBuffer[] responseDataPooledBuffers) throws IOException {
        if (!(this.next instanceof StreamSinkChannelWrappingConduit)) {
            this.standardHttp11Write(responseDataPooledBuffers);
        } else {
            this.standardHttp2Write(responseDataPooledBuffers);
        }
    }

    private void standardHttp11Write(PooledByteBuffer[] buffers) throws IOException {
        for (PooledByteBuffer buffer : buffers) {
            if (buffer == null) break;
            if (logger.isTraceEnabled()) {
                logger.trace("buffer position {} and buffer limit {}", (Object)buffer.getBuffer().position(), (Object)buffer.getBuffer().limit());
            }
            while (buffer.getBuffer().position() < buffer.getBuffer().limit()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Before write buffer position: {}", (Object)buffer.getBuffer().position());
                }
                ((StreamSinkConduit)this.next).write(buffer.getBuffer());
                if (!logger.isTraceEnabled()) continue;
                logger.trace("After write buffer position: {}", (Object)buffer.getBuffer().position());
            }
        }
        ((StreamSinkConduit)this.next).terminateWrites();
    }

    private void standardHttp2Write(PooledByteBuffer[] buffers) throws IOException {
        XnioIoThread ioThread = ((StreamSinkConduit)this.next).getWriteThread();
        XnioWorker workerThread = ((StreamSinkConduit)this.next).getWriteThread().getWorker();
        if (ioThread == Thread.currentThread()) {
            workerThread.execute(() -> {
                try {
                    int index = 0;
                    long totalWritten = 0L;
                    for (PooledByteBuffer buffer : buffers) {
                        if (buffer == null || buffer.getBuffer() == null) break;
                        boolean lastWrite = false;
                        long written = 0L;
                        if (logger.isTraceEnabled()) {
                            logger.trace("---BEFORE-WRITE---");
                            logger.trace("Bytes written in pass: '{}' bytes", (Object)written);
                            logger.trace("Bytes written in total: '{}' bytes", (Object)totalWritten);
                            logger.trace("Current Buffer Size: {} bytes", (Object)buffer.getBuffer().limit());
                            logger.trace("------------------");
                        }
                        while (buffer.getBuffer().position() < buffer.getBuffer().limit()) {
                            long res;
                            if (buffers[index + 1] == null || buffers[index + 1].getBuffer() == null) {
                                res = ((StreamSinkConduit)this.next).writeFinal(buffer.getBuffer());
                                lastWrite = true;
                            } else {
                                res = ((StreamSinkConduit)this.next).write(buffer.getBuffer());
                            }
                            written += res;
                            if (res != 0L && buffer.getBuffer().position() >= buffer.getBuffer().limit()) break;
                            ((StreamSinkConduit)this.next).awaitWritable();
                        }
                        totalWritten += written;
                        if (logger.isTraceEnabled()) {
                            logger.trace("----AFTER-WRITE----");
                            logger.trace("Bytes written in pass: '{}' bytes", (Object)written);
                            logger.trace("Bytes written in total: '{}' bytes", (Object)totalWritten);
                            logger.trace("Current Buffer Index: '{}'", (Object)(index + 1));
                            logger.trace("------------------");
                        }
                        ++index;
                        if (!lastWrite) continue;
                        if (!logger.isTraceEnabled()) break;
                        logger.trace("Final write occurred. Terminating writes.");
                        break;
                    }
                    ((StreamSinkConduit)this.next).terminateWrites();
                    this.cancelProxyConnectionCallback();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            for (PooledByteBuffer buffer : buffers) {
                if (buffer == null || buffer.getBuffer() == null) continue;
                while ((long)((StreamSinkConduit)this.next).write(buffer.getBuffer()) == 0L) {
                    ((StreamSinkConduit)this.next).awaitWritable();
                }
            }
            ((StreamSinkConduit)this.next).terminateWrites();
            this.cancelProxyConnectionCallback();
        }
    }

    private void cancelProxyConnectionCallback() {
        ProxyConnection connectionAttachment = this.exchange.getAttachment(ProxyHandler.CONNECTION);
        if (connectionAttachment != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Proxy connection found. Removing cancel callback.");
            }
            ClientConnection clientConnection = connectionAttachment.getConnection();
            IoUtils.safeClose((Closeable)clientConnection);
            XnioExecutor.Key timeout2 = this.exchange.getAttachment(ProxyHandler.TIMEOUT_KEY);
            timeout2.remove();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateContentLength(HttpServerExchange exchange, PooledByteBuffer[] dests) {
        long length = 0L;
        for (PooledByteBuffer dest : dests) {
            if (dest == null) continue;
            length += (long)dest.getBuffer().limit();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("PooledByteBuffer array added up length = " + length);
        }
        exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, length);
        if (this.next instanceof ServerFixedLengthStreamSinkConduit) {
            Method m3;
            if (logger.isTraceEnabled()) {
                logger.trace("The next conduit is ServerFixedLengthStreamSinkConduit and reset the length.");
            }
            try {
                m3 = ServerFixedLengthStreamSinkConduit.class.getDeclaredMethod("reset", Long.TYPE, HttpServerExchange.class);
                m3.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                logger.error("could not find ServerFixedLengthStreamSinkConduit.reset method", ex);
                throw new RuntimeException("could not find ServerFixedLengthStreamSinkConduit.reset method", ex);
            }
            try {
                m3.invoke((Object)this.next, length, exchange);
                if (!logger.isTraceEnabled()) return;
                logger.trace("reset ServerFixedLengthStreamSinkConduit length = " + length);
                return;
            }
            catch (Throwable ex) {
                logger.error("could not access BUFFERED_REQUEST_DATA field", ex);
                throw new RuntimeException("could not access BUFFERED_REQUEST_DATA field", ex);
            }
        }
        logger.warn("updateContentLength() next is {}", (Object)((StreamSinkConduit)this.next).getClass().getSimpleName());
    }
}

