/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.ResponseInjectionConfig;
import com.networknt.handler.ResponseInterceptor;
import com.networknt.handler.conduit.ContentStreamSinkConduit;
import com.networknt.handler.conduit.ModifiableContentSinkConduit;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.conduits.StreamSinkConduit;

public class ResponseInterceptorInjectionHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(ResponseInterceptorInjectionHandler.class);
    public static final AttachmentKey<ModifiableContentSinkConduit> MCSC_KEY = AttachmentKey.create(ModifiableContentSinkConduit.class);
    public static final AttachmentKey<HeaderMap> ORIGINAL_ACCEPT_ENCODINGS_KEY = AttachmentKey.create(HeaderMap.class);
    private ResponseInterceptor[] interceptors = null;
    private volatile HttpHandler next;
    private static ResponseInjectionConfig config;

    public ResponseInterceptorInjectionHandler() throws Exception {
        config = ResponseInjectionConfig.load();
        this.interceptors = SingletonServiceFactory.getBeans(ResponseInterceptor.class);
        logger.info("SinkConduitInjectorHandler is loaded!");
    }

    @Deprecated
    public ResponseInterceptorInjectionHandler(ResponseInjectionConfig cfg) throws Exception {
        config = cfg;
        logger.info("SinkConduitInjectorHandler is loaded!");
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(ResponseInjectionConfig.class.getName(), config.getMappedConfig(), null);
    }

    @Override
    public void reload() {
        config.reload();
        if (logger.isTraceEnabled()) {
            logger.trace("response-injection.yml is reloaded");
        }
        ModuleRegistry.registerModule(ResponseInjectionConfig.class.getName(), config.getMappedConfig(), null);
    }

    private void forceIdentityEncodingForInterceptors(HttpServerExchange exchange) {
        if (this.interceptors != null && Arrays.stream(this.interceptors).anyMatch(ri -> ri.isRequiredContent())) {
            HeaderMap before = new HeaderMap();
            if (exchange.getRequestHeaders().contains(Headers.ACCEPT_ENCODING)) {
                exchange.getRequestHeaders().get(Headers.ACCEPT_ENCODING).forEach(value -> before.add(Headers.ACCEPT_ENCODING, (String)value));
            }
            exchange.putAttachment(ORIGINAL_ACCEPT_ENCODINGS_KEY, before);
            logger.debug("{} setting encoding to identity because request involves response interceptors.", (Object)before);
            exchange.getRequestHeaders().put(Headers.ACCEPT_ENCODING, "identity");
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addResponseWrapper((factory2, cexchange) -> {
            if (this.interceptors != null && this.isAppliedBodyInjectionPathPrefix(exchange.getRequestPath()) && !this.isCompressed(exchange) && Arrays.stream(this.interceptors).anyMatch(ri -> ri.isRequiredContent())) {
                ModifiableContentSinkConduit mcsc = new ModifiableContentSinkConduit((StreamSinkConduit)factory2.create(), cexchange);
                if (logger.isTraceEnabled()) {
                    logger.trace("created a ModifiableContentSinkConduit instance " + mcsc);
                }
                return mcsc;
            }
            return new ContentStreamSinkConduit((StreamSinkConduit)factory2.create(), cexchange);
        });
        if (!exchange.isResponseStarted()) {
            if (logger.isTraceEnabled()) {
                logger.trace("response is not started, calling next handler.");
            }
            Handler.next(exchange, this.next);
        } else if (logger.isTraceEnabled()) {
            logger.trace("response is started already, do not call next handler in the chain.");
        }
    }

    private boolean isCompressed(HttpServerExchange exchange) {
        boolean compressed = false;
        HeaderValues contentEncodings = exchange.getResponseHeaders().get("Content-Encoding");
        if (contentEncodings != null) {
            for (String values2 : contentEncodings) {
                if (!Arrays.stream(values2.split(",")).anyMatch(v -> Headers.GZIP.toString().equals(v) || Headers.COMPRESS.toString().equals(v) || Headers.DEFLATE.toString().equals(v))) continue;
                compressed = true;
            }
        }
        return compressed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAppliedBodyInjectionPathPrefix(String requestPath) {
        if (config.getAppliedBodyInjectionPathPrefixes() == null) return false;
        if (!config.getAppliedBodyInjectionPathPrefixes().stream().anyMatch(requestPath::startsWith)) return false;
        return true;
    }
}

