/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.RequestInjectionConfig;
import com.networknt.handler.RequestInterceptor;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.UndertowLogger;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpContinue;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;

public class RequestInterceptorInjectionHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(RequestInterceptorInjectionHandler.class);
    public static final int MAX_BUFFERS = 1024;
    private volatile HttpHandler next;
    private static RequestInjectionConfig config;
    private RequestInterceptor[] interceptors = null;

    public RequestInterceptorInjectionHandler() {
        config = RequestInjectionConfig.load();
        logger.info("RequestInterceptorInjectionHandler is loaded!");
        this.interceptors = SingletonServiceFactory.getBeans(RequestInterceptor.class);
    }

    public RequestInterceptorInjectionHandler(RequestInjectionConfig cfg) {
        config = cfg;
        logger.info("RequestInterceptorInjectionHandler is loaded!");
        this.interceptors = SingletonServiceFactory.getBeans(RequestInterceptor.class);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void reload() {
        config.reload();
        if (logger.isTraceEnabled()) {
            logger.trace("request-injection.yml is reloaded");
        }
        ModuleRegistry.registerModule(RequestInjectionConfig.class.getName(), config.getMappedConfig(), null);
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(RequestInjectionConfig.class.getName(), config.getMappedConfig(), null);
    }

    @Override
    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        String method = httpServerExchange.getRequestMethod().toString();
        this.next = Handler.getNext(httpServerExchange);
        if (this.injectorContentRequired() && this.isAppliedBodyInjectionPathPrefix(httpServerExchange.getRequestPath()) && (method.equalsIgnoreCase("post") || method.equalsIgnoreCase("put") || method.equalsIgnoreCase("patch")) && !httpServerExchange.isRequestComplete() && !HttpContinue.requiresContinueResponse(httpServerExchange.getRequestHeaders())) {
            StreamSourceChannel channel = httpServerExchange.getRequestChannel();
            int readBuffers = 0;
            PooledByteBuffer[] bufferedData = new PooledByteBuffer[1024];
            PooledByteBuffer buffer = httpServerExchange.getConnection().getByteBufferPool().allocate();
            try {
                while (true) {
                    ByteBuffer b;
                    int r;
                    if ((r = channel.read(b = buffer.getBuffer())) == -1) {
                        if (b.position() == 0) {
                            buffer.close();
                            break;
                        }
                        b.flip();
                        bufferedData[readBuffers] = buffer;
                        break;
                    }
                    if (r == 0) {
                        this.setChannelRead(channel, buffer, readBuffers, bufferedData, httpServerExchange);
                        channel.resumeReads();
                        return;
                    }
                    if (b.hasRemaining()) continue;
                    b.flip();
                    bufferedData[readBuffers++] = buffer;
                    if (readBuffers == 1024) break;
                    buffer = httpServerExchange.getConnection().getByteBufferPool().allocate();
                }
                this.saveBufferAndResetUndertowConnector(httpServerExchange, bufferedData);
            }
            catch (Error | Exception e) {
                RequestInterceptorInjectionHandler.safeCloseBuffers(bufferedData, buffer);
                throw e;
            }
        } else {
            this.invokeInterceptors(httpServerExchange);
        }
        Handler.next(httpServerExchange, this.next);
    }

    private boolean injectorContentRequired() {
        return this.interceptors != null && this.interceptors.length > 0 && Arrays.stream(this.interceptors).anyMatch(RequestInterceptor::isRequiredContent);
    }

    private void setChannelRead(StreamSourceChannel channel, final PooledByteBuffer channelPoolBuffer, final int channelReadBuffer, final PooledByteBuffer[] bufferedData, final HttpServerExchange httpServerExchange) {
        channel.getReadSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){
            PooledByteBuffer buffer;
            int readBuffers;
            {
                this.buffer = channelPoolBuffer;
                this.readBuffers = channelReadBuffer;
            }

            @Override
            public void handleEvent(StreamSourceChannel channel) {
                try {
                    while (true) {
                        ByteBuffer b;
                        int r;
                        if ((r = channel.read(b = this.buffer.getBuffer())) == -1) {
                            if (b.position() == 0) {
                                this.buffer.close();
                            } else {
                                b.flip();
                                bufferedData[this.readBuffers] = this.buffer;
                            }
                            RequestInterceptorInjectionHandler.this.suspendReads(httpServerExchange, bufferedData, channel, RequestInterceptorInjectionHandler.this.next);
                            return;
                        }
                        if (r == 0) {
                            return;
                        }
                        if (b.hasRemaining()) continue;
                        b.flip();
                        bufferedData[this.readBuffers++] = this.buffer;
                        if (this.readBuffers == 1024) {
                            RequestInterceptorInjectionHandler.this.suspendReads(httpServerExchange, bufferedData, channel, RequestInterceptorInjectionHandler.this.next);
                            return;
                        }
                        this.buffer = httpServerExchange.getConnection().getByteBufferPool().allocate();
                    }
                }
                catch (Throwable e) {
                    if (e instanceof IOException) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException((IOException)e);
                    } else {
                        UndertowLogger.REQUEST_IO_LOGGER.handleUnexpectedFailure(e);
                    }
                    RequestInterceptorInjectionHandler.safeCloseBuffers(bufferedData, this.buffer);
                    httpServerExchange.endExchange();
                    return;
                }
            }
        });
    }

    private static void safeCloseBuffers(PooledByteBuffer[] allDataBuffer, PooledByteBuffer dataBuffer) {
        for (PooledByteBuffer bufferedDatum : allDataBuffer) {
            IoUtils.safeClose((Closeable)bufferedDatum);
        }
        if (dataBuffer != null && dataBuffer.isOpen()) {
            IoUtils.safeClose((Closeable)dataBuffer);
        }
    }

    private void suspendReads(HttpServerExchange httpServerExchange, PooledByteBuffer[] bufferedData, StreamSourceChannel channel, HttpHandler next) {
        this.saveBufferAndResetUndertowConnector(httpServerExchange, bufferedData);
        channel.getReadSetter().set(null);
        channel.suspendReads();
        if (logger.isTraceEnabled()) {
            logger.info("Next is: {}", (Object)next.getClass());
        }
        Connectors.executeRootHandler(next, httpServerExchange);
    }

    private void saveBufferAndResetUndertowConnector(HttpServerExchange httpServerExchange, PooledByteBuffer[] bufferedData) {
        httpServerExchange.putAttachment(AttachmentConstants.BUFFERED_REQUEST_DATA_KEY, bufferedData);
        if (httpServerExchange.getRequestHeaders().getFirst("content-length") != null) {
            long length = 0L;
            for (PooledByteBuffer dest : bufferedData) {
                if (dest == null) continue;
                length += (long)dest.getBuffer().limit();
            }
            httpServerExchange.getRequestHeaders().put(Headers.CONTENT_LENGTH, length);
        }
        Connectors.ungetRequestBytes(httpServerExchange, bufferedData);
        Connectors.resetRequestChannel(httpServerExchange);
        this.invokeInterceptors(httpServerExchange);
    }

    private void invokeInterceptors(HttpServerExchange httpServerExchange) {
        if (this.interceptors != null && this.interceptors.length > 0) {
            for (RequestInterceptor ri : this.interceptors) {
                try {
                    ri.handleRequest(httpServerExchange);
                    if (!httpServerExchange.isResponseStarted()) continue;
                    return;
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    return;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAppliedBodyInjectionPathPrefix(String requestPath) {
        if (config.getAppliedBodyInjectionPathPrefixes() == null) return false;
        if (!config.getAppliedBodyInjectionPathPrefixes().stream().anyMatch(requestPath::startsWith)) return false;
        return true;
    }
}

