/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.networknt.handler.config.MethodRewriteRule;
import com.networknt.handler.config.QueryHeaderRewriteRule;
import com.networknt.handler.config.UrlRewriteRule;
import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.ProxiedRequestAttachments;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.predicate.IdempotentPredicate;
import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RenegotiationRequiredException;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.server.protocol.http.HttpContinue;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Certificates;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.NetworkUtils;
import io.undertow.util.QueryParameterUtils;
import io.undertow.util.SameThreadExecutor;
import io.undertow.util.Transfer;
import io.undertow.util.WorkerUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Channel;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;

public class ProxyHandler
implements HttpHandler {
    private static final int DEFAULT_MAX_RETRY_ATTEMPTS = Integer.getInteger("maxRetries", 1);
    private static final Logger logger = LoggerFactory.getLogger(ProxyHandler.class);
    public static final String UTF_8 = StandardCharsets.UTF_8.name();
    public static final AttachmentKey<ProxyConnection> CONNECTION = AttachmentKey.create(ProxyConnection.class);
    private static final AttachmentKey<HttpServerExchange> EXCHANGE = AttachmentKey.create(HttpServerExchange.class);
    public static final AttachmentKey<XnioExecutor.Key> TIMEOUT_KEY = AttachmentKey.create(XnioExecutor.Key.class);
    private final ProxyClient proxyClient;
    private final int maxRequestTime;
    private final Map<HttpString, ExchangeAttribute> requestHeaders = new CopyOnWriteMap<HttpString, ExchangeAttribute>();
    private final HttpHandler next;
    private volatile boolean rewriteHostHeader;
    private volatile boolean reuseXForwarded;
    private volatile int maxConnectionRetries;
    private volatile List<UrlRewriteRule> urlRewriteRules;
    private volatile List<MethodRewriteRule> methodRewriteRules;
    private volatile Map<String, List<QueryHeaderRewriteRule>> queryParamRewriteRules;
    private volatile Map<String, List<QueryHeaderRewriteRule>> headerRewriteRules;
    private final Predicate idempotentRequestPredicate;

    private ProxyHandler(Builder builder) {
        this.proxyClient = builder.proxyClient;
        this.maxRequestTime = builder.maxRequestTime;
        this.next = builder.next;
        this.rewriteHostHeader = builder.rewriteHostHeader;
        this.reuseXForwarded = builder.reuseXForwarded;
        this.maxConnectionRetries = builder.maxConnectionRetries;
        this.urlRewriteRules = builder.urlRewriteRules;
        this.methodRewriteRules = builder.methodRewriteRules;
        this.queryParamRewriteRules = builder.queryParamRewriteRules;
        this.headerRewriteRules = builder.headerRewriteRules;
        this.idempotentRequestPredicate = builder.idempotentRequestPredicate;
        for (Map.Entry<HttpString, ExchangeAttribute> e : builder.requestHeaders.entrySet()) {
            this.requestHeaders.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ProxyClient.ProxyTarget target = this.proxyClient.findTarget(exchange);
        if (target == null) {
            logger.debug("No proxy target for request to {}", (Object)exchange.getRequestURL());
            this.next.handleRequest(exchange);
            return;
        }
        if (exchange.isResponseStarted()) {
            logger.error("Cannot proxy a request that has already started.");
            UndertowLogger.REQUEST_LOGGER.cannotProxyStartedRequest(exchange);
            exchange.setStatusCode(500);
            exchange.endExchange();
            return;
        }
        long timeout2 = this.maxRequestTime > 0 ? System.currentTimeMillis() + (long)this.maxRequestTime : 0L;
        int maxRetries = this.maxConnectionRetries;
        if (target instanceof ProxyClient.MaxRetriesProxyTarget) {
            maxRetries = Math.max(maxRetries, ((ProxyClient.MaxRetriesProxyTarget)target).getMaxRetries());
        }
        ProxyClientHandler clientHandler = new ProxyClientHandler(exchange, target, timeout2, maxRetries, this.idempotentRequestPredicate);
        if (timeout2 > 0L) {
            XnioExecutor.Key key = WorkerUtils.executeAfter(exchange.getIoThread(), () -> clientHandler.cancel(exchange), this.maxRequestTime, TimeUnit.MILLISECONDS);
            exchange.putAttachment(TIMEOUT_KEY, key);
            exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
                key.remove();
                nextListener.proceed();
            });
        }
        exchange.dispatch(exchange.isInIoThread() ? SameThreadExecutor.INSTANCE : exchange.getIoThread(), clientHandler);
    }

    static void copyHeaders(HeaderMap to, HeaderMap from, List<QueryHeaderRewriteRule> rules) {
        long f = from.fastIterateNonEmpty();
        while (f != -1L) {
            HeaderValues values2 = from.fiCurrent(f);
            if (!to.contains(values2.getHeaderName())) {
                if (rules != null && rules.size() > 0) {
                    for (QueryHeaderRewriteRule rule : rules) {
                        if (!rule.getOldK().equals(values2.getHeaderName().toString())) continue;
                        HttpString key = values2.getHeaderName();
                        if (rule.getNewK() != null) {
                            key = new HttpString(rule.getNewK());
                        }
                        if (rule.getOldV() != null && rule.getNewV() != null) {
                            boolean add = false;
                            Iterator<String> it = values2.iterator();
                            while (it.hasNext()) {
                                String value = it.next();
                                if (!rule.getOldV().equals(value)) continue;
                                it.remove();
                                add = true;
                            }
                            if (add) {
                                values2.addFirst(rule.getNewV());
                            }
                        }
                        to.putAll(key, values2);
                    }
                } else {
                    to.putAll(values2.getHeaderName(), values2);
                }
            }
            f = from.fiNextNonEmpty(f);
        }
    }

    public ProxyClient getProxyClient() {
        return this.proxyClient;
    }

    public String toString() {
        List<ProxyClient.ProxyTarget> proxyTargets = this.proxyClient.getAllTargets();
        if (proxyTargets.isEmpty()) {
            return "ProxyHandler - " + this.proxyClient.getClass().getSimpleName();
        }
        if (proxyTargets.size() == 1 && !this.rewriteHostHeader) {
            return "reverse-proxy( '" + proxyTargets.get(0).toString() + "' )";
        }
        String outputResult = "reverse-proxy( { '" + proxyTargets.stream().map(s2 -> s2.toString()).collect(Collectors.joining("', '")) + "' }";
        if (this.rewriteHostHeader) {
            outputResult = outputResult + ", rewrite-host-header=true";
        }
        return outputResult + " )";
    }

    static void handleFailure(HttpServerExchange exchange, ProxyClientHandler proxyClientHandler, Predicate idempotentRequestPredicate, IOException e) {
        UndertowLogger.PROXY_REQUEST_LOGGER.proxyRequestFailed(exchange.getRequestURI(), e);
        if (exchange.isResponseStarted()) {
            IoUtils.safeClose((Closeable)exchange.getConnection());
        } else if (idempotentRequestPredicate.resolve(exchange) && proxyClientHandler != null) {
            proxyClientHandler.failed(exchange);
        } else {
            exchange.setStatusCode(503);
            exchange.endExchange();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ProxyClient proxyClient;
        private int maxRequestTime = -1;
        private final Map<HttpString, ExchangeAttribute> requestHeaders = new CopyOnWriteMap<HttpString, ExchangeAttribute>();
        private HttpHandler next = ResponseCodeHandler.HANDLE_404;
        private boolean rewriteHostHeader;
        private boolean reuseXForwarded;
        private int maxConnectionRetries = DEFAULT_MAX_RETRY_ATTEMPTS;
        private Predicate idempotentRequestPredicate = IdempotentPredicate.INSTANCE;
        private List<UrlRewriteRule> urlRewriteRules;
        private List<MethodRewriteRule> methodRewriteRules;
        private Map<String, List<QueryHeaderRewriteRule>> queryParamRewriteRules;
        private Map<String, List<QueryHeaderRewriteRule>> headerRewriteRules;

        Builder() {
        }

        public Builder setProxyClient(ProxyClient proxyClient) {
            if (proxyClient == null) {
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("proxyClient");
            }
            this.proxyClient = proxyClient;
            return this;
        }

        public Builder setMaxRequestTime(int maxRequestTime) {
            this.maxRequestTime = maxRequestTime;
            return this;
        }

        public Map<HttpString, ExchangeAttribute> getRequestHeaders() {
            return Collections.unmodifiableMap(this.requestHeaders);
        }

        public Builder addRequestHeader(HttpString header, ExchangeAttribute value) {
            this.requestHeaders.put(header, value);
            return this;
        }

        public HttpHandler getNext() {
            return this.next;
        }

        public Builder setNext(HttpHandler next) {
            this.next = next;
            return this;
        }

        public Builder setRewriteHostHeader(boolean rewriteHostHeader) {
            this.rewriteHostHeader = rewriteHostHeader;
            return this;
        }

        public Builder setReuseXForwarded(boolean reuseXForwarded) {
            this.reuseXForwarded = reuseXForwarded;
            return this;
        }

        public List<UrlRewriteRule> getUrlRewriteRules() {
            return this.urlRewriteRules;
        }

        public Builder setUrlRewriteRules(List<UrlRewriteRule> urlRewriteRules) {
            this.urlRewriteRules = urlRewriteRules;
            return this;
        }

        public Builder setMethodRewriteRules(List<MethodRewriteRule> methodRewriteRules) {
            this.methodRewriteRules = methodRewriteRules;
            return this;
        }

        public Builder setQueryParamRewriteRules(Map<String, List<QueryHeaderRewriteRule>> queryParamRewriteRules) {
            this.queryParamRewriteRules = queryParamRewriteRules;
            return this;
        }

        public Builder setHeaderRewriteRules(Map<String, List<QueryHeaderRewriteRule>> headerRewriteRules) {
            this.headerRewriteRules = headerRewriteRules;
            return this;
        }

        public Builder setMaxConnectionRetries(int maxConnectionRetries) {
            this.maxConnectionRetries = maxConnectionRetries;
            return this;
        }

        public Builder setIdempotentRequestPredicate(Predicate idempotentRequestPredicate) {
            if (idempotentRequestPredicate == null) {
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("idempotentRequestPredicate");
            }
            this.idempotentRequestPredicate = idempotentRequestPredicate;
            return this;
        }

        public ProxyHandler build() {
            return new ProxyHandler(this);
        }
    }

    private static final class ClosingExceptionHandler
    implements ChannelExceptionHandler<Channel> {
        private final Closeable[] toClose;

        private ClosingExceptionHandler(Closeable ... toClose) {
            this.toClose = toClose;
        }

        @Override
        public void handleException(Channel channel, IOException exception) {
            IoUtils.safeClose((Closeable)channel);
            IoUtils.safeClose(this.toClose);
        }
    }

    private static final class IoExceptionHandler
    implements ChannelExceptionHandler<Channel> {
        private final HttpServerExchange exchange;
        private final ClientConnection clientConnection;

        private IoExceptionHandler(HttpServerExchange exchange, ClientConnection clientConnection) {
            this.exchange = exchange;
            this.clientConnection = clientConnection;
        }

        @Override
        public void handleException(Channel channel, IOException exception) {
            IoUtils.safeClose((Closeable)channel);
            IoUtils.safeClose((Closeable)this.clientConnection);
            if (this.exchange.isResponseStarted()) {
                UndertowLogger.REQUEST_IO_LOGGER.debug("Exception reading from target server", exception);
                if (!this.exchange.isResponseStarted()) {
                    this.exchange.setStatusCode(500);
                    this.exchange.endExchange();
                } else {
                    IoUtils.safeClose((Closeable)this.exchange.getConnection());
                }
            } else {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                this.exchange.setStatusCode(500);
                this.exchange.endExchange();
            }
        }
    }

    private static final class HTTPTrailerChannelListener
    implements ChannelListener<StreamSinkChannel> {
        private final Attachable source;
        private final Attachable target;
        private final HttpServerExchange exchange;
        private final ProxyClientHandler proxyClientHandler;
        private final Predicate idempotentPredicate;

        private HTTPTrailerChannelListener(Attachable source2, Attachable target, HttpServerExchange exchange, ProxyClientHandler proxyClientHandler, Predicate idempotentPredicate) {
            this.source = source2;
            this.target = target;
            this.exchange = exchange;
            this.proxyClientHandler = proxyClientHandler;
            this.idempotentPredicate = idempotentPredicate;
        }

        @Override
        public void handleEvent(StreamSinkChannel channel) {
            HeaderMap trailers = this.source.getAttachment(HttpAttachments.REQUEST_TRAILERS);
            if (trailers != null) {
                this.target.putAttachment(HttpAttachments.RESPONSE_TRAILERS, trailers);
            }
            try {
                channel.shutdownWrites();
                if (!channel.flush()) {
                    channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(flushedChannel -> {
                        flushedChannel.suspendWrites();
                        flushedChannel.getWriteSetter().set(null);
                    }, ChannelListeners.closingChannelExceptionHandler()));
                    channel.resumeWrites();
                } else {
                    channel.getWriteSetter().set(null);
                }
            }
            catch (IOException e) {
                logger.error("IOException: ", e);
                ProxyHandler.handleFailure(this.exchange, this.proxyClientHandler, this.idempotentPredicate, e);
            }
            catch (Exception e) {
                logger.error("Exception: ", e);
                ProxyHandler.handleFailure(this.exchange, this.proxyClientHandler, this.idempotentPredicate, new IOException(e));
            }
        }
    }

    private static final class ResponseCallback
    implements ClientCallback<ClientExchange> {
        private final HttpServerExchange exchange;
        private final ProxyClientHandler proxyClientHandler;
        private final Predicate idempotentPredicate;
        private final Map<String, List<QueryHeaderRewriteRule>> headerRewriteRules;

        private ResponseCallback(HttpServerExchange exchange, ProxyClientHandler proxyClientHandler, Predicate idempotentPredicate, Map<String, List<QueryHeaderRewriteRule>> headerRewriteRules) {
            this.exchange = exchange;
            this.proxyClientHandler = proxyClientHandler;
            this.idempotentPredicate = idempotentPredicate;
            this.headerRewriteRules = headerRewriteRules;
        }

        @Override
        public void completed(ClientExchange result) {
            ClientResponse response = result.getResponse();
            if (logger.isDebugEnabled()) {
                logger.debug("Received response {} for request {} for exchange {}", response, result.getRequest(), this.exchange);
            }
            HeaderMap inboundResponseHeaders = response.getResponseHeaders();
            HeaderMap outboundResponseHeaders = this.exchange.getResponseHeaders();
            this.exchange.setStatusCode(response.getResponseCode());
            ProxyHandler.copyHeaders(outboundResponseHeaders, inboundResponseHeaders, this.headerRewriteRules == null ? null : this.headerRewriteRules.get(this.exchange.getRequestPath()));
            if (this.exchange.isUpgrade()) {
                this.exchange.upgradeChannel((streamConnection, exchange) -> {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Upgraded request {} to for exchange {}", (Object)result.getRequest(), (Object)exchange);
                    }
                    StreamConnection clientChannel = null;
                    try {
                        clientChannel = result.getConnection().performUpgrade();
                        ClosingExceptionHandler handler = new ClosingExceptionHandler(streamConnection, clientChannel);
                        Transfer.initiateTransfer(clientChannel.getSourceChannel(), streamConnection.getSinkChannel(), ChannelListeners.closingChannelListener(), ChannelListeners.writeShutdownChannelListener(ChannelListeners.flushingChannelListener(ChannelListeners.closingChannelListener(), ChannelListeners.closingChannelExceptionHandler()), ChannelListeners.closingChannelExceptionHandler()), handler, handler, result.getConnection().getBufferPool());
                        Transfer.initiateTransfer(streamConnection.getSourceChannel(), clientChannel.getSinkChannel(), ChannelListeners.closingChannelListener(), ChannelListeners.writeShutdownChannelListener(ChannelListeners.flushingChannelListener(ChannelListeners.closingChannelListener(), ChannelListeners.closingChannelExceptionHandler()), ChannelListeners.closingChannelExceptionHandler()), handler, handler, result.getConnection().getBufferPool());
                    }
                    catch (IOException e) {
                        IoUtils.safeClose(streamConnection, clientChannel);
                    }
                });
            }
            IoExceptionHandler handler = new IoExceptionHandler(this.exchange, result.getConnection());
            Transfer.initiateTransfer(result.getResponseChannel(), this.exchange.getResponseChannel(), ChannelListeners.closingChannelListener(), new HTTPTrailerChannelListener(result, this.exchange, this.exchange, this.proxyClientHandler, this.idempotentPredicate), handler, handler, this.exchange.getConnection().getByteBufferPool());
        }

        @Override
        public void failed(IOException e) {
            ProxyHandler.handleFailure(this.exchange, this.proxyClientHandler, this.idempotentPredicate, e);
        }
    }

    private static class ProxyAction
    implements Runnable {
        private final ProxyConnection clientConnection;
        private final HttpServerExchange exchange;
        private final Map<HttpString, ExchangeAttribute> requestHeaders;
        private final boolean rewriteHostHeader;
        private final boolean reuseXForwarded;
        private final ProxyClientHandler proxyClientHandler;
        private final Predicate idempotentPredicate;
        private final List<UrlRewriteRule> urlRewriteRules;
        private final List<MethodRewriteRule> methodRewriteRules;
        private final Map<String, List<QueryHeaderRewriteRule>> queryParamRewriteRules;
        private final Map<String, List<QueryHeaderRewriteRule>> headerRewriteRules;

        ProxyAction(ProxyConnection clientConnection, HttpServerExchange exchange, Map<HttpString, ExchangeAttribute> requestHeaders, boolean rewriteHostHeader, boolean reuseXForwarded, ProxyClientHandler proxyClientHandler, Predicate idempotentPredicate, List<UrlRewriteRule> urlRewriteRules, List<MethodRewriteRule> methodRewriteRules, Map<String, List<QueryHeaderRewriteRule>> queryParamRewriteRules, Map<String, List<QueryHeaderRewriteRule>> headerRewriteRules) {
            this.clientConnection = clientConnection;
            this.exchange = exchange;
            this.requestHeaders = requestHeaders;
            this.rewriteHostHeader = rewriteHostHeader;
            this.reuseXForwarded = reuseXForwarded;
            this.proxyClientHandler = proxyClientHandler;
            this.idempotentPredicate = idempotentPredicate;
            this.urlRewriteRules = urlRewriteRules;
            this.methodRewriteRules = methodRewriteRules;
            this.queryParamRewriteRules = queryParamRewriteRules;
            this.headerRewriteRules = headerRewriteRules;
        }

        @Override
        public void run() {
            ClientRequest request = new ClientRequest();
            String targetURI = this.createProxyRequestTargetURI();
            String path = this.createProxyRequestURI(targetURI);
            request.setPath(path);
            HttpString method = this.createProxyRequestMethod(targetURI);
            request.setMethod(method);
            String remoteHost = this.createProxyRequestRemoteHost(request);
            request.putAttachment(ProxiedRequestAttachments.REMOTE_HOST, remoteHost);
            if (logger.isTraceEnabled()) {
                logger.trace("targetURI = " + targetURI + " requestURI = " + path + " method = " + method);
            }
            this.rewriteHeaders(request, targetURI, remoteHost);
            this.attachProtocol(request);
            this.attachRemoteHost(request);
            this.attachPort(request);
            this.attachSslInfo(request);
            if (logger.isDebugEnabled()) {
                logger.debug("Sending request {} to target {} for exchange {}", request, this.clientConnection.getConnection().getPeerAddress(), this.exchange);
            }
            this.sendWithCallback(request, remoteHost);
        }

        private String createProxyRequestRemoteHost(ClientRequest r) {
            String remoteHost;
            InetSocketAddress address = this.exchange.getSourceAddress();
            if (address != null) {
                remoteHost = address.getHostString();
                if (!address.isUnresolved()) {
                    r.putAttachment(ProxiedRequestAttachments.REMOTE_ADDRESS, address.getAddress().getHostAddress());
                }
            } else {
                remoteHost = "localhost";
            }
            return remoteHost;
        }

        private String createProxyRequestURI(String target) {
            StringBuilder uriBuilder = new StringBuilder();
            if (!(this.clientConnection.getTargetPath().isEmpty() || this.clientConnection.getTargetPath().equals("/") && !target.isEmpty())) {
                uriBuilder.append(this.clientConnection.getTargetPath());
            }
            this.rewriteUrl(uriBuilder, target);
            this.rewriteQueryParams(uriBuilder, target);
            return uriBuilder.toString();
        }

        private String createProxyRequestTargetURI() {
            int uriPart;
            String targetURI = this.exchange.getRequestURI();
            if (this.exchange.isHostIncludedInRequestURI() && (uriPart = targetURI.indexOf("//")) != -1 && (uriPart = targetURI.indexOf("/", uriPart + 2)) != -1) {
                targetURI = targetURI.substring(uriPart);
            }
            if (!this.exchange.getResolvedPath().isEmpty() && targetURI.startsWith(this.exchange.getResolvedPath())) {
                targetURI = targetURI.substring(this.exchange.getResolvedPath().length());
            }
            return targetURI;
        }

        private void rewriteHeaders(ClientRequest r, String target, String remoteHost) {
            HeaderMap inboundRequestHeaders = this.exchange.getRequestHeaders();
            HeaderMap outboundRequestHeaders = r.getRequestHeaders();
            ProxyHandler.copyHeaders(outboundRequestHeaders, inboundRequestHeaders, this.headerRewriteRules == null ? null : this.headerRewriteRules.get(target));
            if (!this.exchange.isPersistent()) {
                outboundRequestHeaders.put(Headers.CONNECTION, "keep-alive");
            }
            if ("h2c".equals(this.exchange.getRequestHeaders().getFirst(Headers.UPGRADE))) {
                this.exchange.getRequestHeaders().remove(Headers.UPGRADE);
                outboundRequestHeaders.put(Headers.CONNECTION, "keep-alive");
            }
            for (Map.Entry<HttpString, ExchangeAttribute> entry : this.requestHeaders.entrySet()) {
                String headerValue = entry.getValue().readAttribute(this.exchange);
                if (headerValue == null || headerValue.isEmpty()) {
                    outboundRequestHeaders.remove(entry.getKey());
                    continue;
                }
                outboundRequestHeaders.put(entry.getKey(), headerValue.replace('\n', ' '));
            }
            if (this.reuseXForwarded && r.getRequestHeaders().contains(Headers.X_FORWARDED_FOR)) {
                String current = r.getRequestHeaders().getFirst(Headers.X_FORWARDED_FOR);
                if (current == null || current.isEmpty()) {
                    r.getRequestHeaders().put(Headers.X_FORWARDED_FOR, remoteHost);
                } else {
                    r.getRequestHeaders().put(Headers.X_FORWARDED_FOR, current + "," + remoteHost);
                }
            } else {
                r.getRequestHeaders().put(Headers.X_FORWARDED_FOR, remoteHost);
            }
            if (!this.exchange.getConnection().isPushSupported() && this.clientConnection.getConnection().isPushSupported()) {
                r.getRequestHeaders().put(Headers.X_DISABLE_PUSH, "true");
            }
            if (this.rewriteHostHeader) {
                InetSocketAddress targetAddress = this.clientConnection.getConnection().getPeerAddress(InetSocketAddress.class);
                r.getRequestHeaders().put(Headers.HOST, targetAddress.getHostString() + ":" + targetAddress.getPort());
                r.getRequestHeaders().put(Headers.X_FORWARDED_HOST, this.exchange.getRequestHeaders().getFirst(Headers.HOST));
            }
            if (!(r.getRequestHeaders().contains(Headers.TRANSFER_ENCODING) || r.getRequestHeaders().contains(Headers.CONTENT_LENGTH) || this.exchange.isRequestComplete())) {
                r.getRequestHeaders().put(Headers.TRANSFER_ENCODING, Headers.CHUNKED.toString());
            }
        }

        private HttpString createProxyRequestMethod(String target) {
            HttpString m3 = this.exchange.getRequestMethod();
            if (this.methodRewriteRules != null && this.methodRewriteRules.size() > 0) {
                for (MethodRewriteRule rule : this.methodRewriteRules) {
                    if (!target.equals(rule.getRequestPath()) || !m3.toString().equals(rule.getSourceMethod())) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Rewrite HTTP method from {} to {}", (Object)rule.getSourceMethod(), (Object)rule.getTargetMethod());
                    }
                    m3 = new HttpString(rule.getTargetMethod());
                }
            }
            return m3;
        }

        private void rewriteUrl(StringBuilder uriBuilder, String target) {
            if (this.urlRewriteRules != null && this.urlRewriteRules.size() > 0) {
                boolean matched = false;
                for (UrlRewriteRule rule : this.urlRewriteRules) {
                    Matcher matcher = rule.getPattern().matcher(target);
                    if (!matcher.matches()) continue;
                    matched = true;
                    uriBuilder.append(matcher.replaceAll(rule.getReplace()));
                    break;
                }
                if (!matched) {
                    uriBuilder.append(target);
                }
            } else {
                uriBuilder.append(target);
            }
        }

        private void rewriteQueryParams(StringBuilder urlBuilder, String target) {
            if (this.queryParamRewriteRules != null && this.queryParamRewriteRules.get(target) != null) {
                List<QueryHeaderRewriteRule> rules = this.queryParamRewriteRules.get(target);
                Map<String, Deque<String>> params = this.exchange.getQueryParameters();
                for (QueryHeaderRewriteRule rule : rules) {
                    if (params.get(rule.getOldK()) == null) continue;
                    Deque<String> values2 = params.get(rule.getOldK());
                    if (rule.getOldV() != null && rule.getNewV() != null) {
                        Iterator<String> it = values2.iterator();
                        boolean add = false;
                        while (it.hasNext()) {
                            if (!it.next().equals(rule.getOldV())) continue;
                            it.remove();
                            add = true;
                        }
                        if (add) {
                            values2.addFirst(rule.getNewV());
                        }
                    }
                    if (rule.getNewK() != null) {
                        params.remove(rule.getOldK());
                        params.put(rule.getNewK(), values2);
                        continue;
                    }
                    params.put(rule.getOldK(), values2);
                }
                String qs = QueryParameterUtils.buildQueryString(params);
                if (qs != null && !qs.isEmpty()) {
                    urlBuilder.append('?');
                    urlBuilder.append(qs);
                }
            } else {
                String qs = this.exchange.getQueryString();
                if (qs != null && !qs.isEmpty()) {
                    urlBuilder.append('?');
                    urlBuilder.append(qs);
                }
            }
        }

        private void attachProtocol(ClientRequest r) {
            String p;
            if (this.reuseXForwarded && this.exchange.getRequestHeaders().contains(Headers.X_FORWARDED_PROTO)) {
                p = this.exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_PROTO);
            } else {
                p = this.exchange.getRequestScheme().equals("https") ? "https" : "http";
                r.getRequestHeaders().put(Headers.X_FORWARDED_PROTO, p);
            }
            r.putAttachment(ProxiedRequestAttachments.IS_SSL, p.equals("https"));
        }

        private void attachPort(ClientRequest r) {
            if (this.reuseXForwarded && this.exchange.getRequestHeaders().contains(Headers.X_FORWARDED_PORT)) {
                try {
                    int port = Integer.parseInt(this.exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_PORT));
                    r.putAttachment(ProxiedRequestAttachments.SERVER_PORT, port);
                }
                catch (NumberFormatException e) {
                    int port = this.exchange.getConnection().getLocalAddress(InetSocketAddress.class).getPort();
                    r.getRequestHeaders().put(Headers.X_FORWARDED_PORT, port);
                    r.putAttachment(ProxiedRequestAttachments.SERVER_PORT, port);
                }
            } else {
                int port = this.exchange.getHostPort();
                r.getRequestHeaders().put(Headers.X_FORWARDED_PORT, port);
                r.putAttachment(ProxiedRequestAttachments.SERVER_PORT, port);
            }
        }

        private void attachRemoteHost(ClientRequest r) {
            String host;
            if (this.reuseXForwarded && this.exchange.getRequestHeaders().contains(Headers.X_FORWARDED_SERVER)) {
                host = this.exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_SERVER);
            } else {
                host = this.exchange.getHostName();
                r.getRequestHeaders().put(Headers.X_FORWARDED_SERVER, host);
            }
            r.putAttachment(ProxiedRequestAttachments.SERVER_NAME, host);
            if (!this.exchange.getRequestHeaders().contains(Headers.X_FORWARDED_HOST) && (host = this.exchange.getHostName()) != null) {
                r.getRequestHeaders().put(Headers.X_FORWARDED_HOST, NetworkUtils.formatPossibleIpv6Address(host));
            }
        }

        private void sendWithCallback(final ClientRequest r, final String host) {
            this.clientConnection.getConnection().sendRequest(r, new ClientCallback<ClientExchange>(){

                @Override
                public void completed(ClientExchange result) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Sent request {} to target {} for exchange {}", r, host, exchange);
                    }
                    result.putAttachment(EXCHANGE, exchange);
                    boolean requiresContinueResponse = HttpContinue.requiresContinueResponse(exchange);
                    if (requiresContinueResponse) {
                        result.setContinueHandler(clientExchange -> {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Received continue response to request {} to target {} for exchange {}", r, clientConnection.getConnection().getPeerAddress(), exchange);
                            }
                            HttpContinue.sendContinueResponse(exchange, new IoCallback(){

                                @Override
                                public void onComplete(HttpServerExchange exchange, Sender sender) {
                                }

                                @Override
                                public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                                    IoUtils.safeClose((Closeable)clientConnection.getConnection());
                                    exchange.endExchange();
                                    UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                                }
                            });
                        });
                    }
                    if (exchange.getConnection().isPushSupported() && result.getConnection().isPushSupported()) {
                        this.handleServerPush(result);
                    }
                    result.setResponseListener(new ResponseCallback(exchange, proxyClientHandler, idempotentPredicate, headerRewriteRules));
                    IoExceptionHandler handler = new IoExceptionHandler(exchange, clientConnection.getConnection());
                    if (requiresContinueResponse) {
                        this.prepRequestChannelForContinue(result, handler);
                        return;
                    }
                    HTTPTrailerChannelListener trailerListener = new HTTPTrailerChannelListener(exchange, result, exchange, proxyClientHandler, idempotentPredicate);
                    if (!exchange.isRequestComplete()) {
                        Transfer.initiateTransfer(exchange.getRequestChannel(), result.getRequestChannel(), ChannelListeners.closingChannelListener(), trailerListener, handler, handler, exchange.getConnection().getByteBufferPool());
                    } else {
                        trailerListener.handleEvent(result.getRequestChannel());
                    }
                }

                @Override
                public void failed(IOException e) {
                    ProxyHandler.handleFailure(exchange, proxyClientHandler, idempotentPredicate, e);
                }

                private void prepRequestChannelForContinue(ClientExchange ce, IoExceptionHandler ioExceptionHandler) {
                    try {
                        if (!ce.getRequestChannel().flush()) {
                            ce.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(flushedChannel -> Transfer.initiateTransfer(exchange.getRequestChannel(), ce.getRequestChannel(), ChannelListeners.closingChannelListener(), new HTTPTrailerChannelListener(exchange, ce, exchange, proxyClientHandler, idempotentPredicate), ioExceptionHandler, ioExceptionHandler, exchange.getConnection().getByteBufferPool()), ioExceptionHandler));
                            ce.getRequestChannel().resumeWrites();
                        }
                    }
                    catch (IOException e) {
                        ioExceptionHandler.handleException(ce.getRequestChannel(), e);
                    }
                }

                private void handleServerPush(ClientExchange ce) {
                    ce.setPushHandler((originalRequest, pushedRequest) -> {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Sending push request {} received from {} to target {} for exchange {}", pushedRequest.getRequest(), r, host, exchange);
                        }
                        ClientRequest req = pushedRequest.getRequest();
                        exchange.getConnection().pushResource(req.getPath(), req.getMethod(), req.getRequestHeaders(), exchange -> {
                            String path = req.getPath();
                            int i = path.indexOf("?");
                            if (i > 0) {
                                path = path.substring(0, i);
                            }
                            exchange.dispatch(SameThreadExecutor.INSTANCE, new ProxyAction(new ProxyConnection(pushedRequest.getConnection(), path), exchange, requestHeaders, rewriteHostHeader, reuseXForwarded, null, idempotentPredicate, urlRewriteRules, methodRewriteRules, queryParamRewriteRules, headerRewriteRules));
                        });
                        return true;
                    });
                }
            });
        }

        private void attachSslInfo(ClientRequest r) {
            SSLSessionInfo sslSessionInfo = this.exchange.getConnection().getSslSessionInfo();
            if (sslSessionInfo != null) {
                try {
                    Certificate[] peerCertificates2 = sslSessionInfo.getPeerCertificates();
                    if (peerCertificates2.length > 0) {
                        r.putAttachment(ProxiedRequestAttachments.SSL_CERT, Certificates.toPem(peerCertificates2[0]));
                    }
                }
                catch (RenegotiationRequiredException | CertificateEncodingException | SSLPeerUnverifiedException exception) {
                    // empty catch block
                }
                r.putAttachment(ProxiedRequestAttachments.SSL_CYPHER, sslSessionInfo.getCipherSuite());
                r.putAttachment(ProxiedRequestAttachments.SSL_SESSION_ID, sslSessionInfo.getSessionId());
                r.putAttachment(ProxiedRequestAttachments.SSL_KEY_SIZE, sslSessionInfo.getKeySize());
            }
        }
    }

    private final class ProxyClientHandler
    implements ProxyCallback<ProxyConnection>,
    Runnable {
        private int tries;
        private final long timeout;
        private final int maxRetryAttempts;
        private final HttpServerExchange exchange;
        private final Predicate idempotentPredicate;
        private ProxyClient.ProxyTarget target;

        ProxyClientHandler(HttpServerExchange exchange, ProxyClient.ProxyTarget target, long timeout2, int maxRetryAttempts, Predicate idempotentPredicate) {
            this.exchange = exchange;
            this.timeout = timeout2;
            this.maxRetryAttempts = maxRetryAttempts;
            this.target = target;
            this.idempotentPredicate = idempotentPredicate;
        }

        @Override
        public void run() {
            ProxyHandler.this.proxyClient.getConnection(this.target, this.exchange, this, -1L, TimeUnit.MILLISECONDS);
        }

        @Override
        public void completed(HttpServerExchange exchange, ProxyConnection connection) {
            exchange.putAttachment(CONNECTION, connection);
            exchange.dispatch(SameThreadExecutor.INSTANCE, new ProxyAction(connection, exchange, ProxyHandler.this.requestHeaders, ProxyHandler.this.rewriteHostHeader, ProxyHandler.this.reuseXForwarded, exchange.isRequestComplete() ? this : null, this.idempotentPredicate, ProxyHandler.this.urlRewriteRules, ProxyHandler.this.methodRewriteRules, ProxyHandler.this.queryParamRewriteRules, ProxyHandler.this.headerRewriteRules));
        }

        @Override
        public void failed(HttpServerExchange exchange) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed calling backend with tries = " + this.tries + " maxRetryAttempts = " + this.maxRetryAttempts);
            }
            long time = System.currentTimeMillis();
            if (this.tries++ < this.maxRetryAttempts) {
                if (this.timeout > 0L && time > this.timeout) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Current time = " + time + " passes timeout " + this.timeout);
                    }
                    this.cancel(exchange);
                } else {
                    this.target = ProxyHandler.this.proxyClient.findTarget(exchange);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Retry target = " + this.target);
                    }
                    if (this.target != null) {
                        long remaining;
                        long l = remaining = this.timeout > 0L ? this.timeout - time : -1L;
                        if (logger.isTraceEnabled()) {
                            logger.trace("Retry with remaining = " + remaining);
                        }
                        ProxyHandler.this.proxyClient.getConnection(this.target, exchange, this, remaining, TimeUnit.MILLISECONDS);
                    } else {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Target is null, cannot resolve the backend");
                        }
                        this.couldNotResolveBackend(exchange);
                    }
                }
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("Max number fo retry attempts reached.");
                }
                this.couldNotResolveBackend(exchange);
            }
        }

        @Override
        public void queuedRequestFailed(HttpServerExchange exchange) {
            this.failed(exchange);
        }

        @Override
        public void couldNotResolveBackend(HttpServerExchange exchange) {
            if (exchange.isResponseStarted()) {
                IoUtils.safeClose((Closeable)exchange.getConnection());
            } else {
                exchange.setStatusCode(503);
                exchange.endExchange();
            }
        }

        void cancel(HttpServerExchange exchange) {
            ProxyConnection connectionAttachment = exchange.getAttachment(CONNECTION);
            if (connectionAttachment != null) {
                ClientConnection clientConnection = connectionAttachment.getConnection();
                UndertowLogger.PROXY_REQUEST_LOGGER.timingOutRequest(clientConnection.getPeerAddress() + exchange.getRequestURI());
                IoUtils.safeClose((Closeable)clientConnection);
            } else {
                UndertowLogger.PROXY_REQUEST_LOGGER.timingOutRequest(exchange.getRequestURI());
            }
            if (exchange.isResponseStarted()) {
                IoUtils.safeClose((Closeable)exchange.getConnection());
            } else {
                exchange.setStatusCode(504);
                exchange.endExchange();
            }
        }
    }
}

