/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.exception;

import com.networknt.config.Config;
import com.networknt.exception.ApiException;
import com.networknt.exception.ClientException;
import com.networknt.exception.ExceptionConfig;
import com.networknt.exception.FrameworkException;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ExceptionHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(ExceptionHandler.class);
    public static final String CONFIG_NAME = "exception";
    static ExceptionConfig config = (ExceptionConfig)Config.getInstance().getJsonObjectConfig("exception", ExceptionConfig.class);
    static final String STATUS_RUNTIME_EXCEPTION = "ERR10010";
    static final String STATUS_UNCAUGHT_EXCEPTION = "ERR10011";
    private volatile HttpHandler next;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("ExceptionHandler.handleRequest starts.");
        }
        if (exchange.isInIoThread()) {
            exchange.dispatch(this);
            return;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("ExceptionHandler.handleRequest ends.");
            }
            Handler.next(exchange, this.next);
        }
        catch (Throwable e) {
            logger.error("Exception:", e);
            if (exchange.isResponseChannelAvailable()) {
                if (e instanceof RuntimeException) {
                    if (e instanceof FrameworkException) {
                        FrameworkException fe = (FrameworkException)e;
                        exchange.setStatusCode(fe.getStatus().getStatusCode());
                        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
                        exchange.getResponseSender().send(fe.getStatus().toString());
                        logger.error(fe.getStatus().toString(), e);
                    } else {
                        this.setExchangeStatus(exchange, STATUS_RUNTIME_EXCEPTION, new Object[0]);
                    }
                } else if (e instanceof ApiException) {
                    ApiException ae = (ApiException)e;
                    exchange.setStatusCode(ae.getStatus().getStatusCode());
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
                    exchange.getResponseSender().send(ae.getStatus().toString());
                    logger.error(ae.getStatus().toString(), e);
                } else if (e instanceof ClientException) {
                    ClientException ce = (ClientException)e;
                    if (ce.getStatus().getStatusCode() == 0) {
                        this.setExchangeStatus(exchange, STATUS_UNCAUGHT_EXCEPTION, new Object[0]);
                    } else {
                        exchange.setStatusCode(ce.getStatus().getStatusCode());
                        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
                        exchange.getResponseSender().send(ce.getStatus().toString());
                    }
                } else {
                    this.setExchangeStatus(exchange, STATUS_UNCAUGHT_EXCEPTION, new Object[0]);
                }
            }
        }
        finally {
            MDC.clear();
        }
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(ExceptionHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }

    @Override
    public void reload() {
        config = (ExceptionConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, ExceptionConfig.class);
    }
}

