/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.dump;

import com.networknt.dump.AbstractDumper;
import com.networknt.dump.DumpConfig;
import com.networknt.dump.IResponseDumpable;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.util.Map;

public class StatusCodeDumper
extends AbstractDumper
implements IResponseDumpable {
    private String statusCodeResult = "";

    public StatusCodeDumper(DumpConfig config, HttpServerExchange exchange) {
        super(config, exchange);
    }

    @Override
    public void dumpResponse(Map<String, Object> result) {
        this.statusCodeResult = String.valueOf(this.exchange.getStatusCode());
        this.putDumpInfoTo(result);
    }

    @Override
    protected void putDumpInfoTo(Map<String, Object> result) {
        if (StringUtils.isNotBlank(this.statusCodeResult)) {
            result.put("statusCode", this.statusCodeResult);
        }
    }

    @Override
    public boolean isApplicableForResponse() {
        return this.config.isResponseStatusCodeEnabled();
    }
}

