/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config;

import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.yml.DecryptConstructor;
import com.networknt.decrypt.Decryptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigInjection {
    private static final String INJECTION_ORDER = "injection_order";
    private static final String INJECTION_ORDER_CODE = !System.getProperty("injection_order", "").equals("") ? System.getProperty("injection_order", "") : "2";
    private static final String CENTRALIZED_MANAGEMENT = "values";
    private static final String SCALABLE_CONFIG = "config";
    private static final String EXCLUSION_CONFIG_FILE_LIST = "exclusionConfigFileList";
    private static final String ALLOW_DEFAULT_EMPTY = "allowDefaultValueEmpty";
    private static final Map<String, Object> exclusionMap = Config.getInstance().getJsonMapConfig("config");
    private static Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
    private static String[] trueArray = new String[]{"y", "Y", "yes", "Yes", "YES", "true", "True", "TRUE", "on", "On", "ON"};
    private static String[] falseArray = new String[]{"n", "N", "no", "No", "NO", "false", "False", "FALSE", "off", "Off", "OFF"};
    private static Decryptor decryptor = ConfigInjection.getDecryptor();

    public static Object getInjectValue(String string) {
        Matcher m3 = pattern.matcher(string);
        StringBuffer sb = new StringBuffer();
        while (m3.find()) {
            Object value = ConfigInjection.getValue(m3.group(1));
            if (!(value instanceof String)) {
                return value;
            }
            String valueStr = (String)value;
            if (valueStr.contains("\\")) {
                m3.appendReplacement(sb, (String)value);
                continue;
            }
            m3.appendReplacement(sb, Matcher.quoteReplacement((String)value));
        }
        return m3.appendTail(sb).toString();
    }

    public static boolean isExclusionConfigFile(String configName) {
        List exclusionConfigFileList = exclusionMap == null ? new ArrayList() : (List)exclusionMap.get(EXCLUSION_CONFIG_FILE_LIST);
        return CENTRALIZED_MANAGEMENT.equals(configName) || SCALABLE_CONFIG.equals(configName) || exclusionConfigFileList.contains(configName);
    }

    public static Decryptor getDecryptor() {
        Config myConfig = Config.getInstance();
        if (myConfig == null) {
            throw new RuntimeException("Unable to retrieve the configuration.");
        }
        String decryptorClass = myConfig.getDecryptorClassPublic();
        DecryptConstructor myDecryptCon = new DecryptConstructor(decryptorClass);
        Decryptor myDecryptor = myDecryptCon.createDecryptorPublic(decryptorClass);
        return myDecryptor;
    }

    static String convertEnvVars(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("[^A-Za-z0-9]", "_").toUpperCase();
    }

    public static Object decryptEnvValue(Decryptor decryptor, String envVal) {
        Object decryptedEnvValue = envVal != null && envVal.trim().startsWith("CRYPT") ? ConfigInjection.typeCast(decryptor.decrypt(envVal)) : envVal;
        return decryptedEnvValue;
    }

    private static Object getValue(String content) {
        InjectionPattern injectionPattern = ConfigInjection.getInjectionPattern(content);
        Object value = null;
        if (injectionPattern != null) {
            Boolean containsField = false;
            String envValString = System.getenv(ConfigInjection.convertEnvVars(injectionPattern.getKey()));
            Object envValue = ConfigInjection.decryptEnvValue(decryptor, envValString);
            Map<String, Object> valueMap = Config.getInstance().getDefaultJsonMapConfigNoCache(CENTRALIZED_MANAGEMENT);
            Object fileValue = valueMap != null ? valueMap.get(injectionPattern.getKey()) : null;
            value = INJECTION_ORDER_CODE.equals("2") && envValue != null || INJECTION_ORDER_CODE.equals("1") && fileValue == null ? envValue : fileValue;
            if (valueMap != null && valueMap.containsKey(injectionPattern.getKey()) || System.getenv() != null && System.getenv().containsKey(injectionPattern.getKey())) {
                containsField = true;
            }
            if (value == null && !containsField.booleanValue() && ((value = ConfigInjection.typeCast(injectionPattern.getDefaultValue())) == null || value.equals(""))) {
                String error_text = injectionPattern.getErrorText();
                if (error_text != null && !error_text.equals("")) {
                    throw new ConfigException(error_text);
                }
                if (exclusionMap.get(ALLOW_DEFAULT_EMPTY) == null || !((Boolean)exclusionMap.get(ALLOW_DEFAULT_EMPTY)).booleanValue()) {
                    throw new ConfigException("\"${" + content + "}\" appears in config file cannot be expanded");
                }
            }
        }
        return value;
    }

    private static InjectionPattern getInjectionPattern(String contents) {
        if (contents == null || contents.trim().equals("")) {
            return null;
        }
        InjectionPattern injectionPattern = new InjectionPattern();
        contents = contents.trim();
        String[] array = contents.split(":", 2);
        array[0] = array[0].trim();
        if ("".equals(array[0])) {
            return null;
        }
        injectionPattern.setKey(array[0]);
        if (array.length == 2) {
            array[1] = array[1].trim();
            if (array[1].startsWith("?")) {
                injectionPattern.setErrorText(array[1].substring(1));
            } else if (array[1].startsWith("$")) {
                if (array[1].length() == 1) {
                    injectionPattern.setDefaultValue("\\$\\{" + array[0] + "\\}");
                } else {
                    injectionPattern.setDefaultValue("\\" + array[1]);
                }
            } else {
                injectionPattern.setDefaultValue(array[1]);
            }
        }
        return injectionPattern;
    }

    private static Object typeCast(String str) {
        if (str == null || str.equals("")) {
            return null;
        }
        for (String trueString : trueArray) {
            if (!trueString.equals(str)) continue;
            return true;
        }
        for (String falseString : falseArray) {
            if (!falseString.equals(str)) continue;
            return false;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e1) {
            try {
                return Double.parseDouble(str);
            }
            catch (Exception e2) {
                return str;
            }
        }
    }

    private static class InjectionPattern {
        private String key;
        private String defaultValue;
        private String errorText;

        private InjectionPattern() {
        }

        public String getErrorText() {
            return this.errorText;
        }

        public void setErrorText(String errorTest) {
            this.errorText = errorTest;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }
}

