/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ActivityCorrelator;
import com.microsoft.sqlserver.jdbc.DataTypeFilter;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.IntColumnIdentityFilter;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerDriverBooleanProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverIntProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.Util;
import com.microsoft.sqlserver.jdbc.ZeroFixupFilter;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SQLServerDatabaseMetaData
implements DatabaseMetaData {
    private SQLServerConnection connection;
    static final String urlprefix = "jdbc:sqlserver://";
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerDatabaseMetaData");
    private static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.DatabaseMetaData");
    private static final AtomicInteger baseID = new AtomicInteger(0);
    private final String traceID;
    static final int MAXLOBSIZE = Integer.MAX_VALUE;
    static final int uniqueidentifierSize = 36;
    EnumMap<CallableHandles, HandleAssociation> handleMap = new EnumMap(CallableHandles.class);
    private static final String ASC_OR_DESC = "ASC_OR_DESC";
    private static final String ATTR_NAME = "ATTR_NAME";
    private static final String ATTR_TYPE_NAME = "ATTR_TYPE_NAME";
    private static final String ATTR_SIZE = "ATTR_SIZE";
    private static final String ATTR_DEF = "ATTR_DEF";
    private static final String BASE_TYPE = "BASE_TYPE";
    private static final String BUFFER_LENGTH = "BUFFER_LENGTH";
    private static final String CARDINALITY = "CARDINALITY";
    private static final String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
    private static final String CLASS_NAME = "CLASS_NAME";
    private static final String COLUMN_DEF = "COLUMN_DEF";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String COLUMN_SIZE = "COLUMN_SIZE";
    private static final String COLUMN_TYPE = "COLUMN_TYPE";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    private static final String DEFERRABILITY = "DEFERRABILITY";
    private static final String DELETE_RULE = "DELETE_RULE";
    private static final String FILTER_CONDITION = "FILTER_CONDITION";
    private static final String FK_NAME = "FK_NAME";
    private static final String FKCOLUMN_NAME = "FKCOLUMN_NAME";
    private static final String FKTABLE_CAT = "FKTABLE_CAT";
    private static final String FKTABLE_NAME = "FKTABLE_NAME";
    private static final String FKTABLE_SCHEM = "FKTABLE_SCHEM";
    private static final String GRANTEE = "GRANTEE";
    private static final String GRANTOR = "GRANTOR";
    private static final String INDEX_NAME = "INDEX_NAME";
    private static final String INDEX_QUALIFIER = "INDEX_QUALIFIER";
    private static final String IS_GRANTABLE = "IS_GRANTABLE";
    private static final String IS_NULLABLE = "IS_NULLABLE";
    private static final String KEY_SEQ = "KEY_SEQ";
    private static final String LENGTH = "LENGTH";
    private static final String NON_UNIQUE = "NON_UNIQUE";
    private static final String NULLABLE = "NULLABLE";
    private static final String NUM_INPUT_PARAMS = "NUM_INPUT_PARAMS";
    private static final String NUM_OUTPUT_PARAMS = "NUM_OUTPUT_PARAMS";
    private static final String NUM_PREC_RADIX = "NUM_PREC_RADIX";
    private static final String NUM_RESULT_SETS = "NUM_RESULT_SETS";
    private static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    private static final String PAGES = "PAGES";
    private static final String PK_NAME = "PK_NAME";
    private static final String PKCOLUMN_NAME = "PKCOLUMN_NAME";
    private static final String PKTABLE_CAT = "PKTABLE_CAT";
    private static final String PKTABLE_NAME = "PKTABLE_NAME";
    private static final String PKTABLE_SCHEM = "PKTABLE_SCHEM";
    private static final String PRECISION = "PRECISION";
    private static final String PRIVILEGE = "PRIVILEGE";
    private static final String PROCEDURE_CAT = "PROCEDURE_CAT";
    private static final String PROCEDURE_NAME = "PROCEDURE_NAME";
    private static final String PROCEDURE_SCHEM = "PROCEDURE_SCHEM";
    private static final String PROCEDURE_TYPE = "PROCEDURE_TYPE";
    private static final String PSEUDO_COLUMN = "PSEUDO_COLUMN";
    private static final String RADIX = "RADIX";
    private static final String REMARKS = "REMARKS";
    private static final String SCALE = "SCALE";
    private static final String SCOPE = "SCOPE";
    private static final String SCOPE_CATALOG = "SCOPE_CATALOG";
    private static final String SCOPE_SCHEMA = "SCOPE_SCHEMA";
    private static final String SCOPE_TABLE = "SCOPE_TABLE";
    private static final String SOURCE_DATA_TYPE = "SOURCE_DATA_TYPE";
    private static final String SQL_DATA_TYPE = "SQL_DATA_TYPE";
    private static final String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
    private static final String SS_DATA_TYPE = "SS_DATA_TYPE";
    private static final String SUPERTABLE_NAME = "SUPERTABLE_NAME";
    private static final String SUPERTYPE_CAT = "SUPERTYPE_CAT";
    private static final String SUPERTYPE_NAME = "SUPERTYPE_NAME";
    private static final String SUPERTYPE_SCHEM = "SUPERTYPE_SCHEM";
    private static final String TABLE_CAT = "TABLE_CAT";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TABLE_SCHEM = "TABLE_SCHEM";
    private static final String TABLE_TYPE = "TABLE_TYPE";
    private static final String TYPE = "TYPE";
    private static final String TYPE_CAT = "TYPE_CAT";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String TYPE_SCHEM = "TYPE_SCHEM";
    private static final String UPDATE_RULE = "UPDATE_RULE";
    private static final String FUNCTION_CAT = "FUNCTION_CAT";
    private static final String FUNCTION_NAME = "FUNCTION_NAME";
    private static final String FUNCTION_SCHEM = "FUNCTION_SCHEM";
    private static final String FUNCTION_TYPE = "FUNCTION_TYPE";
    private static final String SS_IS_SPARSE = "SS_IS_SPARSE";
    private static final String SS_IS_COLUMN_SET = "SS_IS_COLUMN_SET";
    private static final String SS_IS_COMPUTED = "SS_IS_COMPUTED";
    private static final String IS_AUTOINCREMENT = "IS_AUTOINCREMENT";
    private static final String[] getColumnPrivilegesColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
    private static final String[] getTablesColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS"};
    static final char LEFT_BRACKET = '[';
    static final char RIGHT_BRACKET = ']';
    static final char ESCAPE = '\\';
    static final char PERCENT = '%';
    static final char UNDERSCORE = '_';
    static final char[] DOUBLE_RIGHT_BRACKET = new char[]{']', ']'};
    private static final String[] getColumnsColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
    private static final String[] getColumnsColumnNamesKatmai = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SS_IS_SPARSE", "SS_IS_COLUMN_SET", "SS_IS_COMPUTED", "IS_AUTOINCREMENT"};
    private static final String[] getFunctionsColumnNames = new String[]{"FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "NUM_INPUT_PARAMS", "NUM_OUTPUT_PARAMS", "NUM_RESULT_SETS", "REMARKS", "FUNCTION_TYPE"};
    private static final String[] getFunctionsColumnsColumnNames = new String[]{"FUNCTION_CAT", "FUNCTION_SCHEM", "FUNCTION_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
    private static final String[] getBestRowIdentifierColumnNames = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
    private static final String[] pkfkColumnNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
    private static final String[] getIndexInfoColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
    private static final String[] getPrimaryKeysColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
    private static final String[] getProcedureColumnsColumnNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
    private static final String[] getProceduresColumnNames = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "NUM_INPUT_PARAMS", "NUM_OUTPUT_PARAMS", "NUM_RESULT_SETS", "REMARKS", "PROCEDURE_TYPE"};
    private static final String[] getTablePrivilegesColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
    private static final String[] getVersionColumnsColumnNames = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};

    private static int nextInstanceID() {
        return baseID.incrementAndGet();
    }

    public final String toString() {
        return this.traceID;
    }

    public SQLServerDatabaseMetaData(SQLServerConnection con) {
        this.traceID = " SQLServerDatabaseMetaData:" + SQLServerDatabaseMetaData.nextInstanceID();
        this.connection = con;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (" + this.connection.toString() + ")");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        boolean f = iface.isInstance(this);
        return f;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        T t;
        try {
            t = iface.cast(this);
        }
        catch (ClassCastException e) {
            throw new SQLServerException(e.getMessage(), e);
        }
        return t;
    }

    private void checkClosed() throws SQLServerException {
        if (this.connection.isClosed()) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), "08003", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLServerResultSet getResultSetFromInternalQueries(String catalog, String query) throws SQLServerException, SQLTimeoutException {
        this.checkClosed();
        String orgCat = null;
        orgCat = this.switchCatalogs(catalog);
        SQLServerResultSet rs = null;
        try {
            rs = ((SQLServerStatement)this.connection.createStatement()).executeQueryInternal(query);
        }
        finally {
            if (null != orgCat) {
                this.connection.setCatalog(orgCat);
            }
        }
        return rs;
    }

    private CallableStatement getCallableStatementHandle(CallableHandles request, String catalog) throws SQLServerException {
        HandleAssociation previous;
        CallableStatement CS = null;
        HandleAssociation hassoc = this.handleMap.get((Object)request);
        if (!(null != hassoc && null != hassoc.databaseName && hassoc.databaseName.equals(catalog) || null == (previous = this.handleMap.put(request, hassoc = new HandleAssociation(catalog, CS = request.prepare(this.connection)))))) {
            ((SQLServerCallableStatement)previous.stmt).handleDBName = previous.databaseName;
            previous.close();
            ((SQLServerCallableStatement)previous.stmt).handleDBName = null;
        }
        return hassoc.stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLServerResultSet getResultSetFromStoredProc(String catalog, CallableHandles procedure, String[] arguments) throws SQLServerException, SQLTimeoutException {
        this.checkClosed();
        assert (null != arguments);
        String orgCat = null;
        orgCat = this.switchCatalogs(catalog);
        SQLServerResultSet rs = null;
        try {
            SQLServerCallableStatement call = (SQLServerCallableStatement)this.getCallableStatementHandle(procedure, catalog);
            for (int i = 1; i <= arguments.length; ++i) {
                call.setString(i, arguments[i - 1]);
            }
            rs = (SQLServerResultSet)call.executeQueryInternal();
        }
        finally {
            if (null != orgCat) {
                this.connection.setCatalog(orgCat);
            }
        }
        return rs;
    }

    private SQLServerResultSet getResultSetWithProvidedColumnNames(String catalog, CallableHandles procedure, String[] arguments, String[] columnNames) throws SQLServerException, SQLTimeoutException {
        SQLServerResultSet rs = this.getResultSetFromStoredProc(catalog, procedure, arguments);
        for (int i = 0; i < columnNames.length; ++i) {
            rs.setColumnName(1 + i, columnNames[i]);
        }
        return rs;
    }

    private String switchCatalogs(String catalog) throws SQLServerException {
        String sNew;
        if (catalog == null) {
            return null;
        }
        String sCurr = null;
        sCurr = this.connection.getCatalog().trim();
        if (sCurr.equals(sNew = catalog.trim())) {
            return null;
        }
        this.connection.setCatalog(sNew);
        if (sCurr == null || sCurr.length() == 0) {
            return null;
        }
        return sCurr;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC42();
        this.checkClosed();
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC42();
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsSharding() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC43();
        this.checkClosed();
        return false;
    }

    @Override
    public ResultSet getCatalogs() throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String s2 = "SELECT name AS TABLE_CAT FROM sys.databases order by name";
        return this.getResultSetFromInternalQueries(null, s2);
    }

    @Override
    public String getCatalogSeparator() throws SQLServerException {
        this.checkClosed();
        return ".";
    }

    @Override
    public String getCatalogTerm() throws SQLServerException {
        this.checkClosed();
        return "database";
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String col) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        col = SQLServerDatabaseMetaData.EscapeIDName(col);
        String[] arguments = new String[]{table, schema, catalog, col};
        return this.getResultSetWithProvidedColumnNames(catalog, CallableHandles.SP_COLUMN_PRIVILEGES, arguments, getColumnPrivilegesColumnNames);
    }

    @Override
    public ResultSet getTables(String catalog, String schema, String table, String[] types) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        table = SQLServerDatabaseMetaData.EscapeIDName(table);
        schema = SQLServerDatabaseMetaData.EscapeIDName(schema);
        String[] arguments = new String[4];
        arguments[0] = table;
        arguments[1] = schema;
        arguments[2] = catalog;
        String tableTypes = null;
        if (types != null) {
            tableTypes = "'";
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    tableTypes = tableTypes + ",";
                }
                tableTypes = tableTypes + "''" + types[i] + "''";
            }
            tableTypes = tableTypes + "'";
        }
        arguments[3] = tableTypes;
        return this.getResultSetWithProvidedColumnNames(catalog, CallableHandles.SP_TABLES, arguments, getTablesColumnNames);
    }

    private static String EscapeIDName(String inID) throws SQLServerException {
        if (null == inID) {
            return inID;
        }
        StringBuilder outID = new StringBuilder(inID.length() + 2);
        for (int i = 0; i < inID.length(); ++i) {
            char ch = inID.charAt(i);
            if ('\\' == ch && ++i < inID.length()) {
                ch = inID.charAt(i);
                switch (ch) {
                    case '%': 
                    case '[': 
                    case '_': {
                        outID.append('[');
                        outID.append(ch);
                        outID.append(']');
                        break;
                    }
                    case '\\': 
                    case ']': {
                        outID.append(ch);
                        break;
                    }
                    default: {
                        outID.append('\\');
                        outID.append(ch);
                        break;
                    }
                }
                continue;
            }
            outID.append(ch);
        }
        return outID.toString();
    }

    @Override
    public ResultSet getColumns(String catalog, String schema, String table, String col) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String column = SQLServerDatabaseMetaData.EscapeIDName(col);
        table = SQLServerDatabaseMetaData.EscapeIDName(table);
        schema = SQLServerDatabaseMetaData.EscapeIDName(schema);
        String[] arguments = this.connection.isKatmaiOrLater() ? new String[6] : new String[5];
        arguments[0] = table;
        arguments[1] = schema;
        arguments[2] = catalog;
        arguments[3] = column;
        if (this.connection.isKatmaiOrLater()) {
            arguments[4] = "2";
            arguments[5] = "3";
        } else {
            arguments[4] = "3";
        }
        SQLServerResultSet rs = this.connection.isKatmaiOrLater() ? this.getResultSetWithProvidedColumnNames(catalog, CallableHandles.SP_COLUMNS, arguments, getColumnsColumnNamesKatmai) : this.getResultSetWithProvidedColumnNames(catalog, CallableHandles.SP_COLUMNS, arguments, getColumnsColumnNames);
        rs.getColumn(5).setFilter(new DataTypeFilter());
        if (this.connection.isKatmaiOrLater()) {
            rs.getColumn(22).setFilter(new IntColumnIdentityFilter());
            rs.getColumn(7).setFilter(new ZeroFixupFilter());
            rs.getColumn(8).setFilter(new ZeroFixupFilter());
            rs.getColumn(16).setFilter(new ZeroFixupFilter());
        }
        return rs;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        this.checkClosed();
        if (catalog != null && catalog.length() == 0) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
            Object[] msgArgs = new Object[]{"catalog"};
            SQLServerException.makeFromDriverError(null, null, form.format(msgArgs), null, false);
        }
        String[] arguments = new String[]{SQLServerDatabaseMetaData.EscapeIDName(functionNamePattern), SQLServerDatabaseMetaData.EscapeIDName(schemaPattern), catalog};
        return this.getResultSetWithProvidedColumnNames(catalog, CallableHandles.SP_STORED_PROCEDURES, arguments, getFunctionsColumnNames);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        this.checkClosed();
        if (catalog != null && catalog.length() == 0) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
            Object[] msgArgs = new Object[]{"catalog"};
            SQLServerException.makeFromDriverError(null, null, form.format(msgArgs), null, false);
        }
        String[] arguments = new String[]{SQLServerDatabaseMetaData.EscapeIDName(functionNamePattern), SQLServerDatabaseMetaData.EscapeIDName(schemaPattern), catalog, SQLServerDatabaseMetaData.EscapeIDName(columnNamePattern), "3"};
        SQLServerResultSet rs = this.getResultSetWithProvidedColumnNames(catalog, CallableHandles.SP_SPROC_COLUMNS, arguments, getFunctionsColumnsColumnNames);
        rs.getColumn(6).setFilter(new DataTypeFilter());
        if (this.connection.isKatmaiOrLater()) {
            rs.getColumn(8).setFilter(new ZeroFixupFilter());
            rs.getColumn(9).setFilter(new ZeroFixupFilter());
            rs.getColumn(17).setFilter(new ZeroFixupFilter());
        }
        return rs;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        this.checkClosed();
        return this.getResultSetFromInternalQueries(null, "SELECT cast(NULL as char(1)) as NAME, cast(0 as int) as MAX_LEN, cast(NULL as char(1)) as DEFAULT_VALUE, cast(NULL as char(1)) as DESCRIPTION  where 0 = 1");
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] arguments = new String[]{table, schema, catalog, "R", 0 == scope ? "C" : "T", nullable ? "U" : "O", "3"};
        SQLServerResultSet rs = this.getResultSetWithProvidedColumnNames(catalog, CallableHandles.SP_SPECIAL_COLUMNS, arguments, getBestRowIdentifierColumnNames);
        rs.getColumn(3).setFilter(new DataTypeFilter());
        return rs;
    }

    @Override
    public ResultSet getCrossReference(String cat1, String schem1, String tab1, String cat2, String schem2, String tab2) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] arguments = new String[]{tab1, schem1, cat1, tab2, schem2, cat2};
        SQLServerResultSet fkeysRS = this.getResultSetWithProvidedColumnNames(null, CallableHandles.SP_FKEYS, arguments, pkfkColumnNames);
        return this.getResultSetForForeignKeyInformation(fkeysRS, null);
    }

    @Override
    public String getDatabaseProductName() throws SQLServerException {
        this.checkClosed();
        return "Microsoft SQL Server";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLServerException {
        this.checkClosed();
        return this.connection.sqlServerVersion;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLServerException {
        this.checkClosed();
        return 2;
    }

    @Override
    public int getDriverMajorVersion() {
        return 6;
    }

    @Override
    public int getDriverMinorVersion() {
        return 5;
    }

    @Override
    public String getDriverName() throws SQLServerException {
        this.checkClosed();
        return "Microsoft JDBC Driver 6.5 for SQL Server";
    }

    @Override
    public String getDriverVersion() throws SQLServerException {
        int n = this.getDriverMinorVersion();
        String s2 = this.getDriverMajorVersion() + ".";
        s2 = s2 + "" + n;
        s2 = s2 + ".";
        s2 = s2 + 1;
        s2 = s2 + ".";
        s2 = s2 + 0;
        return s2;
    }

    @Override
    public ResultSet getExportedKeys(String cat, String schema, String table) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] arguments = new String[]{table, schema, cat, null, null, null};
        SQLServerResultSet fkeysRS = this.getResultSetWithProvidedColumnNames(cat, CallableHandles.SP_FKEYS, arguments, pkfkColumnNames);
        return this.getResultSetForForeignKeyInformation(fkeysRS, cat);
    }

    @Override
    public String getExtraNameCharacters() throws SQLServerException {
        this.checkClosed();
        return "$#@";
    }

    @Override
    public String getIdentifierQuoteString() throws SQLServerException {
        this.checkClosed();
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String cat, String schema, String table) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] arguments = new String[]{null, null, null, table, schema, cat};
        SQLServerResultSet fkeysRS = this.getResultSetWithProvidedColumnNames(cat, CallableHandles.SP_FKEYS, arguments, pkfkColumnNames);
        return this.getResultSetForForeignKeyInformation(fkeysRS, cat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getResultSetForForeignKeyInformation(SQLServerResultSet fkeysRS, String cat) throws SQLServerException, SQLTimeoutException {
        UUID uuid = UUID.randomUUID();
        String fkeys_results_tableName = "[#fkeys_results" + uuid + "]";
        String foreign_keys_combined_tableName = "[#foreign_keys_combined_results" + uuid + "]";
        String sys_foreign_keys = "sys.foreign_keys";
        String fkeys_results_column_definition = "PKTABLE_QUALIFIER sysname, PKTABLE_OWNER sysname, PKTABLE_NAME sysname, PKCOLUMN_NAME sysname, FKTABLE_QUALIFIER sysname, FKTABLE_OWNER sysname, FKTABLE_NAME sysname, FKCOLUMN_NAME sysname, KEY_SEQ smallint, UPDATE_RULE smallint, DELETE_RULE smallint, FK_NAME sysname, PK_NAME sysname, DEFERRABILITY smallint";
        String foreign_keys_combined_column_definition = "name sysname, delete_referential_action_desc nvarchar(60), update_referential_action_desc nvarchar(60)," + fkeys_results_column_definition;
        SQLServerStatement stmt = (SQLServerStatement)this.connection.createStatement();
        stmt.execute("create table " + fkeys_results_tableName + " (" + fkeys_results_column_definition + ")");
        SQLServerPreparedStatement ps = (SQLServerPreparedStatement)((Object)this.connection.prepareCall("insert into " + fkeys_results_tableName + "values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)"));
        try {
            while (fkeysRS.next()) {
                ps.setString(1, fkeysRS.getString(1));
                ps.setString(2, fkeysRS.getString(2));
                ps.setString(3, fkeysRS.getString(3));
                ps.setString(4, fkeysRS.getString(4));
                ps.setString(5, fkeysRS.getString(5));
                ps.setString(6, fkeysRS.getString(6));
                ps.setString(7, fkeysRS.getString(7));
                ps.setString(8, fkeysRS.getString(8));
                ps.setInt(9, fkeysRS.getInt(9));
                ps.setInt(10, fkeysRS.getInt(10));
                ps.setInt(11, fkeysRS.getInt(11));
                ps.setString(12, fkeysRS.getString(12));
                ps.setString(13, fkeysRS.getString(13));
                ps.setInt(14, fkeysRS.getInt(14));
                ps.execute();
            }
        }
        finally {
            if (null != ps) {
                ps.close();
            }
            if (null != fkeysRS) {
                fkeysRS.close();
            }
        }
        stmt.addBatch("create table " + foreign_keys_combined_tableName + " (" + foreign_keys_combined_column_definition + ")");
        stmt.addBatch("insert into " + foreign_keys_combined_tableName + " select " + sys_foreign_keys + ".name, " + sys_foreign_keys + ".delete_referential_action_desc, " + sys_foreign_keys + ".update_referential_action_desc," + fkeys_results_tableName + ".PKTABLE_QUALIFIER," + fkeys_results_tableName + ".PKTABLE_OWNER," + fkeys_results_tableName + ".PKTABLE_NAME," + fkeys_results_tableName + ".PKCOLUMN_NAME," + fkeys_results_tableName + ".FKTABLE_QUALIFIER," + fkeys_results_tableName + ".FKTABLE_OWNER," + fkeys_results_tableName + ".FKTABLE_NAME," + fkeys_results_tableName + ".FKCOLUMN_NAME," + fkeys_results_tableName + ".KEY_SEQ," + fkeys_results_tableName + ".UPDATE_RULE," + fkeys_results_tableName + ".DELETE_RULE," + fkeys_results_tableName + ".FK_NAME," + fkeys_results_tableName + ".PK_NAME," + fkeys_results_tableName + ".DEFERRABILITY from " + sys_foreign_keys + " right join " + fkeys_results_tableName + " on " + sys_foreign_keys + ".name=" + fkeys_results_tableName + ".FK_NAME");
        stmt.addBatch("update " + foreign_keys_combined_tableName + " set DELETE_RULE=3 where delete_referential_action_desc='NO_ACTION';update " + foreign_keys_combined_tableName + " set DELETE_RULE=0 where delete_referential_action_desc='Cascade';update " + foreign_keys_combined_tableName + " set DELETE_RULE=2 where delete_referential_action_desc='SET_NULL';update " + foreign_keys_combined_tableName + " set DELETE_RULE=4 where delete_referential_action_desc='SET_DEFAULT';update " + foreign_keys_combined_tableName + " set UPDATE_RULE=3 where update_referential_action_desc='NO_ACTION';update " + foreign_keys_combined_tableName + " set UPDATE_RULE=0 where update_referential_action_desc='Cascade';update " + foreign_keys_combined_tableName + " set UPDATE_RULE=2 where update_referential_action_desc='SET_NULL';update " + foreign_keys_combined_tableName + " set UPDATE_RULE=4 where update_referential_action_desc='SET_DEFAULT';");
        try {
            stmt.executeBatch();
        }
        catch (BatchUpdateException e) {
            throw new SQLServerException(e.getMessage(), e.getSQLState(), e.getErrorCode(), null);
        }
        return stmt.executeQuery("select PKTABLE_QUALIFIER as 'PKTABLE_CAT',PKTABLE_OWNER as 'PKTABLE_SCHEM',PKTABLE_NAME,PKCOLUMN_NAME,FKTABLE_QUALIFIER as 'FKTABLE_CAT',FKTABLE_OWNER as 'FKTABLE_SCHEM',FKTABLE_NAME,FKCOLUMN_NAME,KEY_SEQ,UPDATE_RULE,DELETE_RULE,FK_NAME,PK_NAME,DEFERRABILITY from " + foreign_keys_combined_tableName + " order by FKTABLE_QUALIFIER, FKTABLE_OWNER, FKTABLE_NAME, KEY_SEQ");
    }

    @Override
    public ResultSet getIndexInfo(String cat, String schema, String table, boolean unique, boolean approximate) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] arguments = new String[]{table, schema, cat, "%", unique ? "Y" : "N", approximate ? "Q" : "E"};
        return this.getResultSetWithProvidedColumnNames(cat, CallableHandles.SP_STATISTICS, arguments, getIndexInfoColumnNames);
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLServerException {
        this.checkClosed();
        return 16;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLServerException {
        this.checkClosed();
        return 4096;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLServerException {
        this.checkClosed();
        return 1024;
    }

    @Override
    public int getMaxConnections() throws SQLServerException, SQLTimeoutException {
        this.checkClosed();
        try {
            String s2 = "sp_configure 'user connections'";
            SQLServerResultSet rs = this.getResultSetFromInternalQueries(null, s2);
            if (!rs.next()) {
                return 0;
            }
            return rs.getInt("maximum");
        }
        catch (SQLServerException e) {
            return 0;
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLServerException {
        this.checkClosed();
        return 900;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    @Override
    public int getMaxRowSize() throws SQLServerException {
        this.checkClosed();
        return 8060;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    @Override
    public int getMaxStatementLength() throws SQLServerException {
        this.checkClosed();
        return 65536 * this.connection.getTDSPacketSize();
    }

    @Override
    public int getMaxStatements() throws SQLServerException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLServerException {
        this.checkClosed();
        return 256;
    }

    @Override
    public int getMaxUserNameLength() throws SQLServerException {
        this.checkClosed();
        return 128;
    }

    @Override
    public String getNumericFunctions() throws SQLServerException {
        this.checkClosed();
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP, FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    public ResultSet getPrimaryKeys(String cat, String schema, String table) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] arguments = new String[]{table, schema, cat};
        return this.getResultSetWithProvidedColumnNames(cat, CallableHandles.SP_PKEYS, arguments, getPrimaryKeysColumnNames);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schema, String proc, String col) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] arguments = new String[]{proc = SQLServerDatabaseMetaData.EscapeIDName(proc), schema, catalog, col = SQLServerDatabaseMetaData.EscapeIDName(col), "3"};
        SQLServerResultSet rs = this.getResultSetWithProvidedColumnNames(catalog, CallableHandles.SP_SPROC_COLUMNS, arguments, getProcedureColumnsColumnNames);
        rs.getColumn(6).setFilter(new DataTypeFilter());
        if (this.connection.isKatmaiOrLater()) {
            rs.getColumn(8).setFilter(new ZeroFixupFilter());
            rs.getColumn(9).setFilter(new ZeroFixupFilter());
            rs.getColumn(17).setFilter(new ZeroFixupFilter());
        }
        return rs;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schema, String proc) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] arguments = new String[]{SQLServerDatabaseMetaData.EscapeIDName(proc), schema, catalog};
        return this.getResultSetWithProvidedColumnNames(catalog, CallableHandles.SP_STORED_PROCEDURES, arguments, getProceduresColumnNames);
    }

    @Override
    public String getProcedureTerm() throws SQLServerException {
        this.checkClosed();
        return "stored procedure";
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        return this.getResultSetFromInternalQueries(catalog, "SELECT cast(NULL as char(1)) as TABLE_CAT, cast(NULL as char(1)) as TABLE_SCHEM, cast(NULL as char(1)) as TABLE_NAME, cast(NULL as char(1)) as COLUMN_NAME, cast(0 as int) as DATA_TYPE, cast(0 as int) as COLUMN_SIZE, cast(0 as int) as DECIMAL_DIGITS, cast(0 as int) as NUM_PREC_RADIX, cast(NULL as char(1)) as COLUMN_USAGE, cast(NULL as char(1)) as REMARKS, cast(0 as int) as CHAR_OCTET_LENGTH, cast(NULL as char(1)) as IS_NULLABLE where 0 = 1");
    }

    @Override
    public ResultSet getSchemas() throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        return this.getSchemasInternal(null, null);
    }

    private ResultSet getSchemasInternal(String catalog, String schemaPattern) throws SQLServerException, SQLTimeoutException {
        SQLServerResultSet rs;
        String constSchemas = " ('dbo', 'guest','INFORMATION_SCHEMA','sys','db_owner', 'db_accessadmin', 'db_securityadmin', 'db_ddladmin'  ,'db_backupoperator','db_datareader','db_datawriter','db_denydatareader','db_denydatawriter') ";
        String schema = "sys.schemas";
        String schemaName = "sys.schemas.name";
        if (null != catalog && catalog.length() != 0) {
            schema = catalog + "." + schema;
            schemaName = catalog + "." + schemaName;
        }
        String s2 = "select " + schemaName + " 'TABLE_SCHEM',";
        if (null != catalog && catalog.length() == 0) {
            s2 = s2 + "null 'TABLE_CATALOG' ";
        } else {
            s2 = s2 + " CASE WHEN " + schemaName + "  IN " + constSchemas + " THEN null ELSE ";
            s2 = null != catalog && catalog.length() != 0 ? s2 + "'" + catalog + "' " : s2 + " DB_NAME() ";
            s2 = s2 + " END 'TABLE_CATALOG' ";
        }
        s2 = s2 + "   from " + schema;
        if (null != catalog && catalog.length() == 0) {
            s2 = null != schemaPattern ? s2 + " where " + schemaName + " like ?  and " : s2 + " where ";
            s2 = s2 + schemaName + " in " + constSchemas;
        } else if (null != schemaPattern) {
            s2 = s2 + " where " + schemaName + " like ?  ";
        }
        s2 = s2 + " order by 2, 1";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " schema query (" + s2 + ")");
        }
        if (null == schemaPattern) {
            catalog = null;
            rs = this.getResultSetFromInternalQueries(catalog, s2);
        } else {
            SQLServerPreparedStatement ps = (SQLServerPreparedStatement)this.connection.prepareStatement(s2);
            ps.setString(1, schemaPattern);
            rs = (SQLServerResultSet)ps.executeQueryInternal();
        }
        return rs;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        return this.getSchemasInternal(catalog, schemaPattern);
    }

    @Override
    public String getSchemaTerm() throws SQLServerException {
        this.checkClosed();
        return "schema";
    }

    @Override
    public String getSearchStringEscape() throws SQLServerException {
        this.checkClosed();
        return "\\";
    }

    @Override
    public String getSQLKeywords() throws SQLServerException {
        this.checkClosed();
        return "BACKUP,BREAK,BROWSE,BULK,CHECKPOINT,CLUSTERED,COMPUTE,CONTAINS,CONTAINSTABLE,DATABASE,DBCC,DENY,DISK,DISTRIBUTED,DUMMY,DUMP,ERRLVL,EXIT,FILE,FILLFACTOR,FREETEXT,FREETEXTTABLE,FUNCTION,HOLDLOCK,IDENTITY_INSERT,IDENTITYCOL,IF,KILL,LINENO,LOAD,NOCHECK,NONCLUSTERED,OFF,OFFSETS,OPENDATASOURCE,OPENQUERY,OPENROWSET,OPENXML,OVER,PERCENT,PLAN,PRINT,PROC,RAISERROR,READTEXT,RECONFIGURE,REPLICATION,RESTORE,RETURN,ROWCOUNT,ROWGUIDCOL,RULE,SAVE,SETUSER,SHUTDOWN,STATISTICS,TEXTSIZE,TOP,TRAN,TRIGGER,TRUNCATE,TSEQUAL,UPDATETEXT,USE,WAITFOR,WHILE,WRITETEXT";
    }

    @Override
    public String getStringFunctions() throws SQLServerException {
        this.checkClosed();
        return "ASCII,CHAR,CONCAT, DIFFERENCE,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE";
    }

    @Override
    public String getSystemFunctions() throws SQLServerException {
        this.checkClosed();
        return "DATABASE,IFNULL,USER";
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schema, String table) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        table = SQLServerDatabaseMetaData.EscapeIDName(table);
        schema = SQLServerDatabaseMetaData.EscapeIDName(schema);
        String[] arguments = new String[]{table, schema, catalog};
        return this.getResultSetWithProvidedColumnNames(catalog, CallableHandles.SP_TABLE_PRIVILEGES, arguments, getTablePrivilegesColumnNames);
    }

    @Override
    public ResultSet getTableTypes() throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String s2 = "SELECT 'VIEW' 'TABLE_TYPE' UNION SELECT 'TABLE' UNION SELECT 'SYSTEM TABLE'";
        SQLServerResultSet rs = this.getResultSetFromInternalQueries(null, s2);
        return rs;
    }

    @Override
    public String getTimeDateFunctions() throws SQLServerException {
        this.checkClosed();
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        SQLServerResultSet rs = this.connection.isKatmaiOrLater() ? this.getResultSetFromInternalQueries(null, "sp_datatype_info_100 @ODBCVer=3") : this.getResultSetFromInternalQueries(null, "sp_datatype_info @ODBCVer=3");
        rs.setColumnName(11, "FIXED_PREC_SCALE");
        rs.getColumn(2).setFilter(new DataTypeFilter());
        return rs;
    }

    @Override
    public String getURL() throws SQLServerException {
        this.checkClosed();
        StringBuilder url = new StringBuilder();
        Properties props = this.connection.activeConnectionProperties;
        DriverPropertyInfo[] info = SQLServerDriver.getPropertyInfoFromProperties(props);
        String serverName = null;
        String portNumber = null;
        String instanceName = null;
        int index = info.length;
        while (--index >= 0) {
            String val;
            String name = info[index].name;
            if (name.equals(SQLServerDriverBooleanProperty.INTEGRATED_SECURITY.toString()) || name.equals(SQLServerDriverStringProperty.USER.toString()) || name.equals(SQLServerDriverStringProperty.PASSWORD.toString()) || name.equals(SQLServerDriverStringProperty.KEY_STORE_SECRET.toString()) || 0 == (val = info[index].value).length()) continue;
            if (name.equals(SQLServerDriverStringProperty.SERVER_NAME.toString())) {
                serverName = val;
                continue;
            }
            if (name.equals(SQLServerDriverStringProperty.INSTANCE_NAME.toString())) {
                instanceName = val;
                continue;
            }
            if (name.equals(SQLServerDriverIntProperty.PORT_NUMBER.toString())) {
                portNumber = val;
                continue;
            }
            url.append(name);
            url.append("=");
            url.append(val);
            url.append(";");
        }
        url.insert(0, ";");
        url.insert(0, portNumber);
        url.insert(0, ":");
        if (null != instanceName) {
            url.insert(0, instanceName);
            url.insert(0, "\\");
        }
        url.insert(0, serverName);
        url.insert(0, urlprefix);
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserName() throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        SQLServerStatement s2 = null;
        SQLServerResultSet rs = null;
        String result = "";
        try {
            s2 = (SQLServerStatement)this.connection.createStatement();
            rs = s2.executeQueryInternal("select system_user");
            boolean next = rs.next();
            assert (next);
            result = rs.getString(1);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (s2 != null) {
                s2.close();
            }
        }
        return result;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        String[] arguments = new String[]{table, schema, catalog, "V", "T", "U", "3"};
        SQLServerResultSet rs = this.getResultSetWithProvidedColumnNames(catalog, CallableHandles.SP_SPECIAL_COLUMNS, arguments, getVersionColumnsColumnNames);
        rs.getColumn(3).setFilter(new DataTypeFilter());
        return rs;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean isReadOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLServerException {
        this.checkClosed();
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 4096: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(type);
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 2003: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(type);
        this.checkConcurrencyType(concurrency);
        switch (type) {
            case 1003: 
            case 1005: 
            case 1006: 
            case 2004: {
                return true;
            }
            case 1004: 
            case 2003: {
                return 1007 == concurrency;
            }
        }
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(type);
        return type == 1006 || 1003 == type || 1005 == type || 1005 == type || 2004 == type;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(type);
        return type == 1006 || 1003 == type || 1005 == type || 1005 == type || 2004 == type;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(type);
        return type == 1006 || 1003 == type || 1005 == type || 1005 == type || 2004 == type;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(type);
        return type == 1006 || 1003 == type || 1005 == type || 1005 == type || 2004 == type;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(type);
        return type == 1006 || 1003 == type || 1005 == type || 1005 == type || 2004 == type;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(type);
        return type == 1006 || 1003 == type || 2004 == type;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(type);
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(type);
        return 1005 == type;
    }

    private void checkResultType(int type) throws SQLServerException {
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 2003: 
            case 2004: {
                return;
            }
        }
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] msgArgs = new Object[]{type};
        throw new SQLServerException(null, form.format(msgArgs), null, 0, true);
    }

    private void checkConcurrencyType(int type) throws SQLServerException {
        switch (type) {
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: {
                return;
            }
        }
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] msgArgs = new Object[]{type};
        throw new SQLServerException(null, form.format(msgArgs), null, 0, true);
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLServerException {
        this.checkClosed();
        this.checkResultType(type);
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        return this.getResultSetFromInternalQueries(catalog, "SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as CLASS_NAME, cast(0 as int) as DATA_TYPE, cast(NULL as char(1)) as REMARKS, cast(0 as smallint) as BASE_TYPE where 0 = 1");
    }

    @Override
    public Connection getConnection() throws SQLServerException {
        this.checkClosed();
        return this.connection.getConnection();
    }

    @Override
    public int getSQLStateType() throws SQLServerException {
        this.checkClosed();
        if (this.connection != null && this.connection.xopenStates) {
            return 1;
        }
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLServerException {
        this.checkClosed();
        String s2 = this.connection.sqlServerVersion;
        int p = s2.indexOf(46);
        if (p > 0) {
            s2 = s2.substring(0, p);
        }
        try {
            return new Integer(s2);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLServerException {
        this.checkClosed();
        String s2 = this.connection.sqlServerVersion;
        int p = s2.indexOf(46);
        int q = s2.indexOf(46, p + 1);
        if (p > 0 && q > 0) {
            s2 = s2.substring(p + 1, q);
        }
        try {
            return new Integer(s2);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLServerException {
        this.checkClosed();
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLServerException {
        this.checkClosed();
        return 2;
    }

    @Override
    public int getResultSetHoldability() throws SQLServerException {
        this.checkClosed();
        return 1;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        this.checkClosed();
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLServerException {
        this.checkClosed();
        if (1 == holdability || 2 == holdability) {
            return true;
        }
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] msgArgs = new Object[]{holdability};
        throw new SQLServerException(null, form.format(msgArgs), null, 0, true);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        return this.getResultSetFromInternalQueries(catalog, "SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as ATTR_NAME, cast(0 as int) as DATA_TYPE, cast(NULL as char(1)) as ATTR_TYPE_NAME, cast(0 as int) as ATTR_SIZE, cast(0 as int) as DECIMAL_DIGITS, cast(0 as int) as NUM_PREC_RADIX, cast(0 as int) as NULLABLE, cast(NULL as char(1)) as REMARKS, cast(NULL as char(1)) as ATTR_DEF, cast(0 as int) as SQL_DATA_TYPE, cast(0 as int) as SQL_DATETIME_SUB, cast(0 as int) as CHAR_OCTET_LENGTH, cast(0 as int) as ORDINAL_POSITION, cast(NULL as char(1)) as IS_NULLABLE, cast(NULL as char(1)) as SCOPE_CATALOG, cast(NULL as char(1)) as SCOPE_SCHEMA, cast(NULL as char(1)) as SCOPE_TABLE, cast(0 as smallint) as SOURCE_DATA_TYPE where 0 = 1");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        return this.getResultSetFromInternalQueries(catalog, "SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as SUPERTABLE_NAME where 0 = 1");
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLServerException, SQLTimeoutException {
        if (loggerExternal.isLoggable(Level.FINER) && Util.IsActivityTraceOn()) {
            loggerExternal.finer(this.toString() + " ActivityId: " + ActivityCorrelator.getNext().toString());
        }
        this.checkClosed();
        return this.getResultSetFromInternalQueries(catalog, "SELECT cast(NULL as char(1)) as TYPE_CAT, cast(NULL as char(1)) as TYPE_SCHEM, cast(NULL as char(1)) as TYPE_NAME, cast(NULL as char(1)) as SUPERTYPE_CAT, cast(NULL as char(1)) as SUPERTYPE_SCHEM, cast(NULL as char(1)) as SUPERTYPE_NAME where 0 = 1");
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsSavepoints() throws SQLServerException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        this.checkClosed();
        return true;
    }

    final class HandleAssociation {
        final String databaseName;
        final CallableStatement stmt;

        HandleAssociation(String databaseName, CallableStatement stmt) {
            this.databaseName = databaseName;
            this.stmt = stmt;
        }

        final void close() throws SQLServerException {
            ((SQLServerCallableStatement)this.stmt).close();
        }
    }

    static enum CallableHandles {
        SP_COLUMNS("{ call sp_columns(?, ?, ?, ?, ?) }", "{ call sp_columns_100(?, ?, ?, ?, ?, ?) }"),
        SP_COLUMN_PRIVILEGES("{ call sp_column_privileges(?, ?, ?, ?)}", "{ call sp_column_privileges(?, ?, ?, ?)}"),
        SP_TABLES("{ call sp_tables(?, ?, ?, ?) }", "{ call sp_tables(?, ?, ?, ?) }"),
        SP_SPECIAL_COLUMNS("{ call sp_special_columns (?, ?, ?, ?, ?, ?, ?)}", "{ call sp_special_columns_100 (?, ?, ?, ?, ?, ?, ?)}"),
        SP_FKEYS("{ call sp_fkeys (?, ?, ?, ? , ? ,?)}", "{ call sp_fkeys (?, ?, ?, ? , ? ,?)}"),
        SP_STATISTICS("{ call sp_statistics(?,?,?,?,?, ?) }", "{ call sp_statistics_100(?,?,?,?,?, ?) }"),
        SP_SPROC_COLUMNS("{ call sp_sproc_columns(?, ?, ?,?,?) }", "{ call sp_sproc_columns_100(?, ?, ?,?,?) }"),
        SP_STORED_PROCEDURES("{call sp_stored_procedures(?, ?, ?) }", "{call sp_stored_procedures(?, ?, ?) }"),
        SP_TABLE_PRIVILEGES("{call sp_table_privileges(?,?,?) }", "{call sp_table_privileges(?,?,?) }"),
        SP_PKEYS("{ call sp_pkeys (?, ?, ?)}", "{ call sp_pkeys (?, ?, ?)}");

        private final String preKatProc;
        private final String katProc;

        private CallableHandles(String name, String katName) {
            this.preKatProc = name;
            this.katProc = katName;
        }

        CallableStatement prepare(SQLServerConnection conn) throws SQLServerException {
            return conn.prepareCall(conn.isKatmaiOrLater() ? this.katProc : this.preKatProc);
        }
    }
}

