/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.schema.type.TypeKind;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeMismatchException;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import com.hazelcast.sql.impl.type.converter.BigDecimalConverter;
import com.hazelcast.sql.impl.type.converter.BigIntegerConverter;
import com.hazelcast.sql.impl.type.converter.BooleanConverter;
import com.hazelcast.sql.impl.type.converter.ByteConverter;
import com.hazelcast.sql.impl.type.converter.CalendarConverter;
import com.hazelcast.sql.impl.type.converter.CharacterConverter;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import com.hazelcast.sql.impl.type.converter.DateConverter;
import com.hazelcast.sql.impl.type.converter.DoubleConverter;
import com.hazelcast.sql.impl.type.converter.FloatConverter;
import com.hazelcast.sql.impl.type.converter.InstantConverter;
import com.hazelcast.sql.impl.type.converter.IntegerConverter;
import com.hazelcast.sql.impl.type.converter.IntervalConverter;
import com.hazelcast.sql.impl.type.converter.JsonConverter;
import com.hazelcast.sql.impl.type.converter.LocalDateConverter;
import com.hazelcast.sql.impl.type.converter.LocalDateTimeConverter;
import com.hazelcast.sql.impl.type.converter.LocalTimeConverter;
import com.hazelcast.sql.impl.type.converter.LongConverter;
import com.hazelcast.sql.impl.type.converter.MapConverter;
import com.hazelcast.sql.impl.type.converter.NullConverter;
import com.hazelcast.sql.impl.type.converter.ObjectConverter;
import com.hazelcast.sql.impl.type.converter.OffsetDateTimeConverter;
import com.hazelcast.sql.impl.type.converter.RowConverter;
import com.hazelcast.sql.impl.type.converter.ShortConverter;
import com.hazelcast.sql.impl.type.converter.StringConverter;
import com.hazelcast.sql.impl.type.converter.ZonedDateTimeConverter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryDataType
implements IdentifiedDataSerializable,
Serializable {
    public static final int MAX_DECIMAL_PRECISION = 76;
    public static final int MAX_DECIMAL_SCALE = 38;
    public static final int OBJECT_TYPE_KIND_NONE = TypeKind.NONE.value();
    public static final int OBJECT_TYPE_KIND_JAVA = TypeKind.JAVA.value();
    public static final int OBJECT_TYPE_KIND_PORTABLE = TypeKind.PORTABLE.value();
    public static final int OBJECT_TYPE_KIND_COMPACT = TypeKind.COMPACT.value();
    public static final QueryDataType VARCHAR = new QueryDataType(StringConverter.INSTANCE);
    public static final QueryDataType VARCHAR_CHARACTER = new QueryDataType(CharacterConverter.INSTANCE);
    public static final QueryDataType BOOLEAN = new QueryDataType(BooleanConverter.INSTANCE);
    public static final QueryDataType TINYINT = new QueryDataType(ByteConverter.INSTANCE);
    public static final QueryDataType SMALLINT = new QueryDataType(ShortConverter.INSTANCE);
    public static final QueryDataType INT = new QueryDataType(IntegerConverter.INSTANCE);
    public static final QueryDataType BIGINT = new QueryDataType(LongConverter.INSTANCE);
    public static final QueryDataType DECIMAL = new QueryDataType(BigDecimalConverter.INSTANCE);
    public static final QueryDataType DECIMAL_BIG_INTEGER = new QueryDataType(BigIntegerConverter.INSTANCE);
    public static final QueryDataType REAL = new QueryDataType(FloatConverter.INSTANCE);
    public static final QueryDataType DOUBLE = new QueryDataType(DoubleConverter.INSTANCE);
    public static final QueryDataType TIME = new QueryDataType(LocalTimeConverter.INSTANCE);
    public static final QueryDataType DATE = new QueryDataType(LocalDateConverter.INSTANCE);
    public static final QueryDataType TIMESTAMP = new QueryDataType(LocalDateTimeConverter.INSTANCE);
    public static final QueryDataType TIMESTAMP_WITH_TZ_DATE = new QueryDataType(DateConverter.INSTANCE);
    public static final QueryDataType TIMESTAMP_WITH_TZ_CALENDAR = new QueryDataType(CalendarConverter.INSTANCE);
    public static final QueryDataType TIMESTAMP_WITH_TZ_INSTANT = new QueryDataType(InstantConverter.INSTANCE);
    public static final QueryDataType TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME = new QueryDataType(OffsetDateTimeConverter.INSTANCE);
    public static final QueryDataType TIMESTAMP_WITH_TZ_ZONED_DATE_TIME = new QueryDataType(ZonedDateTimeConverter.INSTANCE);
    public static final QueryDataType OBJECT = new QueryDataType(ObjectConverter.INSTANCE);
    public static final QueryDataType NULL = new QueryDataType(NullConverter.INSTANCE);
    public static final QueryDataType INTERVAL_YEAR_MONTH = new QueryDataType(IntervalConverter.YEAR_MONTH);
    public static final QueryDataType INTERVAL_DAY_SECOND = new QueryDataType(IntervalConverter.DAY_SECOND);
    public static final QueryDataType MAP = new QueryDataType(MapConverter.INSTANCE);
    public static final QueryDataType JSON = new QueryDataType(JsonConverter.INSTANCE);
    public static final QueryDataType ROW = new QueryDataType(RowConverter.INSTANCE);
    private Converter converter;
    private String objectTypeName = "";
    private Integer objectTypeKind = OBJECT_TYPE_KIND_NONE;
    private List<QueryDataTypeField> objectFields = new ArrayList<QueryDataTypeField>();
    private String objectTypeMetadata = "";

    public QueryDataType() {
    }

    public QueryDataType(String objectTypeName) {
        this.converter = ObjectConverter.INSTANCE;
        this.objectTypeKind = OBJECT_TYPE_KIND_NONE;
        this.objectTypeName = objectTypeName;
    }

    public QueryDataType(String objectTypeName, int typeKind) {
        this.converter = ObjectConverter.INSTANCE;
        this.objectTypeName = objectTypeName;
        this.objectTypeKind = typeKind;
    }

    QueryDataType(Converter converter) {
        this.converter = converter;
    }

    public String getObjectTypeName() {
        return this.objectTypeName;
    }

    public List<QueryDataTypeField> getObjectFields() {
        return this.objectFields;
    }

    public String getObjectTypeMetadata() {
        return this.objectTypeMetadata;
    }

    public void setObjectTypeMetadata(String objectTypeMetadata) {
        this.objectTypeMetadata = objectTypeMetadata;
    }

    public QueryDataTypeFamily getTypeFamily() {
        return this.converter.getTypeFamily();
    }

    public Converter getConverter() {
        return this.converter;
    }

    public Integer getObjectTypeKind() {
        return this.objectTypeKind;
    }

    public void setObjectTypeKind(Integer objectTypeKind) {
        this.objectTypeKind = objectTypeKind;
    }

    public Object normalize(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == this.converter.getNormalizedValueClass()) {
            return value;
        }
        if (!this.converter.getValueClass().isAssignableFrom(valueClass)) {
            throw new QueryDataTypeMismatchException(this.converter.getValueClass(), valueClass);
        }
        return this.converter.convertToSelf(this.converter, value);
    }

    public Object convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == this.converter.getNormalizedValueClass()) {
            return value;
        }
        return this.converter.convertToSelf(Converters.getConverter(valueClass), value);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.converter.getId());
        if (!this.converter.getTypeFamily().equals((Object)QueryDataTypeFamily.OBJECT)) {
            return;
        }
        QueryDataType.writeObjectTypeMetadata(this, out);
        if (!this.isCustomType()) {
            return;
        }
        HashMap<String, QueryDataType> nestedTypes = new HashMap<String, QueryDataType>();
        this.collectNestedTypes(this, nestedTypes);
        out.writeInt(nestedTypes.size());
        for (QueryDataType nestedType : nestedTypes.values()) {
            QueryDataType.writeObjectTypeMetadata(nestedType, out);
            out.writeInt(nestedType.getObjectFields().size());
            for (QueryDataTypeField field : nestedType.getObjectFields()) {
                out.writeString(field.name);
                out.writeInt(((QueryDataTypeField)field).dataType.converter.getId());
                QueryDataType.writeObjectTypeMetadata(field.dataType, out);
            }
        }
    }

    private static void writeObjectTypeMetadata(QueryDataType queryDataType, ObjectDataOutput out) throws IOException {
        out.writeInt(queryDataType.objectTypeKind);
        out.writeString(queryDataType.objectTypeName);
        out.writeString(queryDataType.objectTypeMetadata);
    }

    private void collectNestedTypes(QueryDataType dataType, Map<String, QueryDataType> collected) {
        collected.putIfAbsent(dataType.objectTypeName, dataType);
        for (QueryDataTypeField field : dataType.objectFields) {
            if (!field.getDataType().isCustomType() || collected.containsKey(((QueryDataTypeField)field).dataType.objectTypeName)) continue;
            this.collectNestedTypes(field.dataType, collected);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.converter = Converters.getConverter(in.readInt());
        if (!this.converter.getTypeFamily().equals((Object)QueryDataTypeFamily.OBJECT)) {
            return;
        }
        this.objectTypeKind = in.readInt();
        this.objectTypeName = in.readString();
        this.objectTypeMetadata = in.readString();
        if (!this.isCustomType()) {
            return;
        }
        this.objectFields = new ArrayList<QueryDataTypeField>();
        int typeMapSize = in.readInt();
        HashMap<String, QueryDataType> nestedTypes = new HashMap<String, QueryDataType>();
        nestedTypes.put(this.objectTypeName, this);
        for (int i = 0; i < typeMapSize; ++i) {
            Integer currentTypeKind = in.readInt();
            String currentTypeName = in.readString();
            String currentTypeMetadata = in.readString();
            int fieldsSize = in.readInt();
            QueryDataType currentType = nestedTypes.computeIfAbsent(currentTypeName, s2 -> {
                QueryDataType fieldType = new QueryDataType(currentTypeName);
                fieldType.setObjectTypeMetadata(currentTypeMetadata);
                fieldType.setObjectTypeKind(currentTypeKind);
                return fieldType;
            });
            for (int j = 0; j < fieldsSize; ++j) {
                String fieldName = in.readString();
                int fieldConverterId = in.readInt();
                int fieldTypeKind = in.readInt();
                String fieldTypeName = in.readString();
                String fieldTypeMetadata = in.readString();
                if (fieldConverterId == OBJECT.getConverter().getId() && fieldTypeName != null && !fieldTypeName.isEmpty()) {
                    currentType.getObjectFields().add(new QueryDataTypeField(fieldName, nestedTypes.computeIfAbsent(fieldTypeName, s2 -> {
                        QueryDataType fieldType = new QueryDataType(fieldTypeName);
                        fieldType.setObjectTypeMetadata(fieldTypeMetadata);
                        fieldType.setObjectTypeKind(fieldTypeKind);
                        return fieldType;
                    })));
                    continue;
                }
                QueryDataType fieldDataType = QueryDataTypeUtils.resolveTypeForClass(Converters.getConverter(fieldConverterId).getValueClass());
                currentType.getObjectFields().add(new QueryDataTypeField(fieldName, fieldDataType));
            }
        }
    }

    public int hashCode() {
        if (this.converter.getTypeFamily().equals((Object)QueryDataTypeFamily.OBJECT)) {
            return 31 * this.converter.getId();
        }
        if (this.converter.getTypeFamily().equals((Object)QueryDataTypeFamily.ROW)) {
            return 31 * this.converter.getId();
        }
        return 31 * this.converter.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryDataType type = (QueryDataType)o;
        if (this.converter.getTypeFamily().equals((Object)QueryDataTypeFamily.OBJECT)) {
            return this.converter.getId() == type.converter.getId();
        }
        if (this.converter.getTypeFamily().equals((Object)QueryDataTypeFamily.ROW)) {
            return this.converter.getId() == type.converter.getId();
        }
        return this.converter.getId() == type.converter.getId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {family=" + (Object)((Object)this.getTypeFamily()) + "}";
    }

    public boolean isCustomType() {
        return this.converter.getTypeFamily().equals((Object)QueryDataTypeFamily.OBJECT) && !this.objectTypeName.isEmpty();
    }

    public static class QueryDataTypeField
    implements IdentifiedDataSerializable,
    Serializable {
        private String name;
        private QueryDataType dataType;

        public QueryDataTypeField() {
        }

        public QueryDataTypeField(String name, QueryDataType dataType) {
            this.name = name;
            this.dataType = dataType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public QueryDataType getDataType() {
            return this.dataType;
        }

        public void setDataType(QueryDataType dataType) {
            this.dataType = dataType;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeString(this.name);
            out.writeObject(this.dataType);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.name = in.readString();
            this.dataType = (QueryDataType)in.readObject();
        }

        @Override
        public int getFactoryId() {
            return SqlDataSerializerHook.F_ID;
        }

        @Override
        public int getClassId() {
            return 67;
        }
    }
}

