/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.string;

import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.ConcurrentInitialSetCache;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.TriExpression;
import com.hazelcast.sql.impl.expression.string.StringFunctionUtils;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LikeFunction
extends TriExpression<Boolean>
implements IdentifiedDataSerializable {
    private static final int PATTERN_CACHE_SIZE = 100;
    private static final long serialVersionUID = 2L;
    private static final char ONE_SQL = '_';
    private static final char MANY_SQL = '%';
    private static final String ONE_JAVA = ".";
    private static final String MANY_JAVA = ".*";
    private static final String ESCAPE_CHARACTERS_JAVA = "[]()|^+*?{}$\\.";
    private boolean negated;
    private transient ConcurrentInitialSetCache<Tuple2<String, String>, Pattern> patternCache;

    public LikeFunction() {
    }

    private LikeFunction(Expression<?> source2, Expression<?> pattern, Expression<?> escape, boolean negated) {
        super(source2, pattern, escape);
        this.negated = negated;
        this.patternCache = new ConcurrentInitialSetCache(100);
    }

    public static LikeFunction create(Expression<?> source2, Expression<?> pattern, Expression<?> escape, boolean negated) {
        return new LikeFunction(source2, pattern, escape, negated);
    }

    @Override
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="SQL has three-valued boolean logic")
    public Boolean eval(Row row, ExpressionEvalContext context) {
        String escape;
        String source2 = StringFunctionUtils.asVarchar(this.operand1, row, context);
        if (source2 == null) {
            return null;
        }
        String pattern = StringFunctionUtils.asVarchar(this.operand2, row, context);
        if (pattern == null) {
            return null;
        }
        if (this.operand3 != null) {
            escape = StringFunctionUtils.asVarchar(this.operand3, row, context);
            if (escape == null) {
                return null;
            }
        } else {
            escape = null;
        }
        boolean res = this.like(source2, pattern, escape);
        if (this.negated) {
            res = !res;
        }
        return res;
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.BOOLEAN;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 45;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeBoolean(this.negated);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.negated = in.readBoolean();
        this.patternCache = new ConcurrentInitialSetCache(100);
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.patternCache = new ConcurrentInitialSetCache(100);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LikeFunction that = (LikeFunction)o;
        return this.negated == that.negated;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.negated);
    }

    public boolean like(String source2, String pattern, String escape) {
        Pattern javaPattern = this.convertToJavaPattern(pattern, escape);
        Matcher matcher = javaPattern.matcher(source2);
        return matcher.matches();
    }

    private Pattern convertToJavaPattern(String pattern, String escape) {
        Tuple2<String, String> cacheKey = Tuple2.tuple2(pattern, escape);
        return this.patternCache.computeIfAbsent(cacheKey, key -> {
            String javaPatternStr = LikeFunction.constructJavaPatternString(pattern, escape);
            return Pattern.compile(javaPatternStr, 32);
        });
    }

    private static String constructJavaPatternString(String pattern, String escape) {
        Character escapeChar;
        if (escape != null) {
            if (escape.length() != 1) {
                throw QueryException.error("ESCAPE parameter must be a single character");
            }
            escapeChar = Character.valueOf(escape.charAt(0));
        } else {
            escapeChar = null;
        }
        StringBuilder javaPattern = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char patternChar = pattern.charAt(i);
            if (ESCAPE_CHARACTERS_JAVA.indexOf(patternChar) >= 0) {
                javaPattern.append('\\');
            }
            if (escapeChar != null && patternChar == escapeChar.charValue()) {
                if (i == pattern.length() - 1) {
                    throw LikeFunction.escapeWildcardsOnly();
                }
                char nextPatternChar = pattern.charAt(i + 1);
                if (nextPatternChar == '_' || nextPatternChar == '%' || nextPatternChar == escapeChar.charValue()) {
                    javaPattern.append(nextPatternChar);
                    ++i;
                    continue;
                }
                throw LikeFunction.escapeWildcardsOnly();
            }
            if (patternChar == '_') {
                javaPattern.append(ONE_JAVA);
                continue;
            }
            if (patternChar == '%') {
                javaPattern.append(MANY_JAVA);
                continue;
            }
            javaPattern.append(patternChar);
        }
        return javaPattern.toString();
    }

    private static QueryException escapeWildcardsOnly() {
        return QueryException.error("Only '_', '%' and the escape character can be escaped");
    }
}

