/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.ResultIterator;
import com.hazelcast.sql.impl.SqlRowImpl;
import com.hazelcast.sql.impl.client.SqlClientService;
import com.hazelcast.sql.impl.client.SqlFetchResult;
import com.hazelcast.sql.impl.client.SqlPage;
import com.hazelcast.sql.impl.client.SqlResubmissionResult;
import com.hazelcast.sql.impl.row.JetSqlRow;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class SqlClientResult
implements SqlResult {
    private final SqlClientService service;
    private final int cursorBufferSize;
    private final Function<QueryId, ClientMessage> sqlExecuteMessageSupplier;
    private final boolean selectQuery;
    private volatile QueryId queryId;
    private Connection connection;
    private int resubmissionCount;
    private final Object mux = new Object();
    private State state;
    private boolean iteratorRequested;
    private boolean closed;
    private volatile boolean returnedAnyResult;
    private volatile Boolean isInfiniteRows;
    private SqlFetchResult fetch;
    private boolean lastFetchResubmitted;

    public SqlClientResult(SqlClientService service, Connection connection, QueryId queryId, int cursorBufferSize, Function<QueryId, ClientMessage> sqlExecuteMessageSupplier, SqlStatement statement) {
        this.service = service;
        this.connection = connection;
        this.queryId = queryId;
        this.cursorBufferSize = cursorBufferSize;
        this.sqlExecuteMessageSupplier = sqlExecuteMessageSupplier;
        this.selectQuery = statement.getSql().trim().toLowerCase().startsWith("select");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExecuteResponse(SqlRowMetadata rowMetadata, SqlPage rowPage, long updateCount, Boolean isInfiniteRows) {
        Object object = this.mux;
        synchronized (object) {
            this.isInfiniteRows = isInfiniteRows;
            if (this.closed) {
                return;
            }
            if (rowMetadata != null) {
                ClientIterator iterator2 = new ClientIterator(rowMetadata);
                iterator2.onNextPage(rowPage);
                this.state = new State(iterator2, -1L, null);
            } else {
                this.state = new State(null, updateCount, null);
                this.markClosed();
            }
            this.mux.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResubmissionResponse(SqlResubmissionResult result) {
        Object object = this.mux;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (this.state != null && this.state.iterator != null && !this.state.iterator.rowMetadata.equals(result.getRowMetadata())) {
                throw new HazelcastSqlException(this.queryId.getMemberId(), -1, "Row metadata changed after resubmission", null, null);
            }
            this.fetch = null;
            this.connection = result.getConnection();
            ++this.resubmissionCount;
            if (result.getRowMetadata() != null) {
                ClientIterator iterator2 = this.state == null ? new ClientIterator(result.getRowMetadata()) : this.state.iterator;
                iterator2.onNextPage(result.getRowPage());
                this.state = new State(iterator2, -1L, null);
            } else {
                this.state = new State(null, result.getUpdateCount(), null);
                this.markClosed();
            }
            this.mux.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExecuteError(RuntimeException error) {
        Object object = this.mux;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.state = new State(null, -1L, error);
            this.mux.notifyAll();
        }
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"})
    public SqlRowMetadata getRowMetadata() {
        State state = this.awaitState();
        ClientIterator iterator2 = state.iterator;
        if (iterator2 == null) {
            throw new IllegalStateException("This result contains only update count");
        }
        return iterator2.rowMetadata;
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public ResultIterator<SqlRow> iterator() {
        State state = this.awaitState();
        ClientIterator iterator2 = state.iterator;
        if (iterator2 == null) {
            throw new IllegalStateException("This result contains only update count");
        }
        if (this.iteratorRequested) {
            throw new IllegalStateException("Iterator can be requested only once");
        }
        this.iteratorRequested = true;
        return iterator2;
    }

    @Override
    public long updateCount() {
        State state = this.awaitState();
        return state.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mux;
        synchronized (object) {
            try {
                if (this.closed) {
                    return;
                }
                if (this.state == null) {
                    this.onExecuteError(QueryException.cancelledByUser());
                }
                if (this.fetch == null) {
                    this.fetch = new SqlFetchResult();
                }
                this.onFetchFinished(null, QueryException.cancelledByUser());
                this.service.close(this.connection, this.queryId);
            }
            finally {
                this.closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markClosed() {
        Object object = this.mux;
        synchronized (object) {
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlPage fetch(long timeoutNanos) {
        this.lastFetchResubmitted = false;
        Object object = this.mux;
        synchronized (object) {
            long startNanos;
            if (this.fetch != null) {
                if (this.fetch.getError() != null) {
                    throw this.wrap(this.fetch.getError());
                }
            } else {
                this.fetch = new SqlFetchResult();
                this.service.fetchAsync(this.connection, this.queryId, this.cursorBufferSize, this);
            }
            for (long waitNanos = timeoutNanos; this.fetch.isPending() && waitNanos > 0L; waitNanos -= System.nanoTime() - startNanos) {
                try {
                    startNanos = System.nanoTime();
                    TimeUnit.NANOSECONDS.timedWait(this.mux, waitNanos);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw this.wrap(QueryException.error("Interrupted while waiting for the response from the server.", e));
                }
            }
            if (this.fetch.isPending()) {
                return null;
            }
            if (this.fetch.getError() != null) {
                SqlResubmissionResult resubmissionResult = this.service.resubmitIfPossible(this, this.fetch.getError());
                if (resubmissionResult == null) {
                    throw this.wrap(this.fetch.getError());
                }
                this.lastFetchResubmitted = true;
                this.onResubmissionResponse(resubmissionResult);
                return this.state.iterator.currentPage;
            }
            SqlPage page = this.fetch.getPage();
            assert (page != null);
            this.fetch = null;
            return page;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFetchFinished(SqlPage page, RuntimeException error) {
        Object object = this.mux;
        synchronized (object) {
            assert (this.fetch != null && this.fetch.isPending());
            this.fetch.onResult(page, error);
            this.mux.notifyAll();
        }
    }

    private State awaitState() {
        State state = this.awaitStateNoThrow();
        if (state.error != null) {
            throw this.wrap(state.error);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State awaitStateNoThrow() {
        Object object = this.mux;
        synchronized (object) {
            while (this.state == null) {
                try {
                    this.mux.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    QueryException error = QueryException.error("Interrupted while waiting for the response from the server.", e);
                    return new State(null, -1L, error);
                }
            }
            return this.state;
        }
    }

    private HazelcastSqlException wrap(Throwable error) {
        throw QueryUtils.toPublicException(error, this.service.getClientId());
    }

    ClientMessage getSqlExecuteMessage(QueryId newId) {
        return this.sqlExecuteMessageSupplier.apply(newId);
    }

    boolean isSelectQuery() {
        return this.selectQuery;
    }

    boolean isReturnedAnyResult() {
        return this.returnedAnyResult;
    }

    QueryId getQueryId() {
        return this.queryId;
    }

    void setQueryId(QueryId queryId) {
        this.queryId = queryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wasResubmission() {
        Object object = this.mux;
        synchronized (object) {
            return this.resubmissionCount > 0;
        }
    }

    public Boolean isInfiniteRows() {
        return this.isInfiniteRows;
    }

    private final class ClientIterator
    implements ResultIterator<SqlRow> {
        private final SqlRowMetadata rowMetadata;
        private SqlPage currentPage;
        private int currentRowCount;
        private int currentPosition;
        private boolean last;

        private ClientIterator(SqlRowMetadata rowMetadata) {
            assert (rowMetadata != null);
            this.rowMetadata = rowMetadata;
        }

        @Override
        public ResultIterator.HasNextResult hasNext(long timeout2, TimeUnit timeUnit) {
            if (this.currentPosition == this.currentRowCount) {
                if (!this.last) {
                    do {
                        SqlPage page;
                        if ((page = SqlClientResult.this.fetch(timeUnit.toNanos(timeout2))) == null) {
                            return ResultIterator.HasNextResult.TIMEOUT;
                        }
                        this.onNextPage(page);
                    } while (SqlClientResult.this.lastFetchResubmitted && !this.last && this.currentPosition == this.currentRowCount);
                } else {
                    return ResultIterator.HasNextResult.DONE;
                }
            }
            if (this.currentPosition == this.currentRowCount) {
                assert (this.last);
                return ResultIterator.HasNextResult.DONE;
            }
            return ResultIterator.HasNextResult.YES;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext(Long.MAX_VALUE, TimeUnit.NANOSECONDS) == ResultIterator.HasNextResult.YES;
        }

        @Override
        public SqlRow next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            JetSqlRow row = this.getCurrentRow();
            ++this.currentPosition;
            SqlClientResult.this.returnedAnyResult = true;
            return new SqlRowImpl(this.rowMetadata, row);
        }

        private void onNextPage(SqlPage page) {
            this.currentPage = page;
            this.currentRowCount = page.getRowCount();
            this.currentPosition = 0;
            if (page.isLast()) {
                this.last = true;
                SqlClientResult.this.markClosed();
            }
        }

        private JetSqlRow getCurrentRow() {
            Object[] values2 = new Object[this.rowMetadata.getColumnCount()];
            for (int i = 0; i < this.currentPage.getColumnCount(); ++i) {
                values2[i] = this.currentPage.getColumnValueForClient(i, this.currentPosition);
            }
            return new JetSqlRow(SqlClientResult.this.service.getSerializationService(), values2);
        }
    }

    private static final class State {
        private final ClientIterator iterator;
        private final long updateCount;
        private final RuntimeException error;

        private State(ClientIterator iterator2, long updateCount, RuntimeException error) {
            this.iterator = iterator2;
            this.updateCount = updateCount;
            this.error = error;
        }
    }
}

